/* Copyright (c) 1996 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI dp83840.h,v 1.4 1999/07/11 14:38:40 geertj Exp
 */

#ifndef	_DP83840_H_
#define	_DP83840_H_

/*
 * Defines for National Semiconductor dp83840 PHY
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define	NSPHY_OUI		0x080017
#define	NSPHY_MODEL_83840	0
#define	NSPHY_MODEL_83843	1

/* PHY specific registers */
#define	MII_PHYSTS	0x10	/* PHY status (83843) */
#define	MII_PCR		0x17	/* PCS Configuration register */
#define	MII_PAR		0x19	/* Physical address and status (83840) */

/* PHYSTS bits (83843 only) */
#define	PHYSTS_10	0x02	/* 10mbit mode */

/* PCR bits */
#define	PCR_TXR_SEL	0x0400	/* Enable TXREADY */
#define	PCR_FCONN	0x0020	/* Disable disconnect function */
#define	PCR_DUP_10_EN	0x0002	/* LED4=FDX also in 10mbit mode */

/* PAR bits (83840 only) */
#define	PAR_10		0x40	/* 10mbit mode */

#endif /* !_DP83840_H_ */
