/* Copyright (c) 1997 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI i82555.h,v 1.3 2001/03/06 19:48:37 geertj Exp
 */

#ifndef _I82555_H_
#define _I82555_H_

/*
 * Defines for Intel 82555 PHY
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define INTEL_OUI	0x00aa00
#define I82555_MODEL	0x15
#define	I82562EM_MODEL	0x32
#define	I82562ET_MODEL	0x33

/* PHY specific registers */
#define	MII_STCTL	0x10	/* status and control */
#define	MII_SPCTL	0x11	/* special control */
#define	MII_RDSC	0x14	/* RCV disconnect counter */
#define	MII_RERR	0x15	/* RCV error frame counter */
#define	MII_RSYM	0x16	/* RCV symbol error counter */
#define	MII_PEOF	0x17	/* Premature EOF counter */
#define	MII_EOF		0x18	/* 10baseT RCV end of frame error counter */
#define	MII_JDC		0x19	/* 10baseT XMT Jabber detect counter */
#define	MII_LED		0x1b	/* LED control */

/* MII_STCTL bits */
#define	STCTL_FLOWCTL	0x8000	/* Bay/82557 flow control */
#define	STCTL_T4EN	0x4000	/* Enable T4 when AN disabled */
#define	STCTL_CRS	0x2000	/* CRS disconnect feature select */
#define	STCTL_TFCD	0x1000	/* Transmit flow control disable */
#define	STCTL_DIS	0x0800	/* RX deserializer in sync */
#define	STCTL_100PD	0x0400	/* 100baseT power down */
#define	STCTL_10PD	0x0200	/* 10baseT power down */
#define	STCTL_POL	0x0100	/* 10baseT polarity indication */
#define	STCTL_T4	0x0004	/* ANEG result - 100baseT4 present */
#define	STCTL_SPD	0x0002	/* ANEG result - 100/10 mbit */
#define	STCTL_FDX	0x0001	/* ANEG result - full duplex */

#define	STCTL_FMT	"\20\20FLOWCTL\17T4EN\16CRS\15TFCD\14DIS\13PD100\12PD10\11POL\3T4\2SPD\1FDX"

/* MII_SPCTL bits */
#define	SPCTL_SBYP	0x8000	/* Scrambler bypass */
#define	SPCTL_BYP45	0x4000	/* Bypass 4bit to 5bit */
#define	SPCTL_FHP	0x2000	/* Force xmit H pattern */
#define	SPCTL_F34	0x1000	/* Force xmit 34 pattern */
#define	SPCTL_GLINK	0x0800	/* good link forces LISTAT_N output */
#define	SPCTL_TCSD	0x0200	/* Transmit carrier sense disable */
#define	SPCTL_DDPD	0x0100	/* Disable dynamic power down */
#define	SPCTL_ANLB	0x0080	/* auto negotiation loopback */
#define	SPCTL_MDI3ST	0x0040	/* tristate MDI driver */
#define	SPCTL_FBYP	0x0020	/* filter bypass */
#define	SPCTL_APDIS	0x0010	/* auto polarity disable */
#define	SPCTL_SQEDIS	0x0008	/* SQE disable */
#define	SPCTL_XSQ	0x0004	/* Extended squelch control */
#define	SPCTL_LIDIS	0x0002	/* Link integrity disable */
#define	SPCTL_JABDIS	0x0001	/* Jabber function disable */

/* MII_LED bits                     ACTLED	LILED */
#define	LED_ACT_LINK	0	/*  Activity	Link 		*/
#define	LED_SP_COL	1	/*  Speed	Collision	*/
#define	LED_SP_LINK	2	/*  Speed	Link		*/
#define	LED_ACT_COL	3	/*  Activity	Collision	*/
#define	LED_SET		4	/* set this bit to control LED's directly */
#define	LED_ACT		1	/* turn on ACTLED */
#define	LED_LI		2	/* turn on LILED */

#endif /* !_I82555_H_ */
