/* Copyright (c) 1996 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI ics1890.h,v 1.2.24.1 2001/03/22 02:50:05 geertj Exp
 */

#ifndef _ICS1890_H_
#define _ICS1890_H_

/*
 * Defines for Integrated Circuit Systems 1890 PHYceiver
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define	ICS_OUI		0x00a0be
#define	ICS90P_MODEL	2		/* ICS 1890 */

/* PHY specific registers */
#define	MII_ECR		0x10	/* Extended control register */
#define	MII_QPR		0x11	/* Quick poll register */
#define	MII_TTR		0x12	/* 10baseT operations Register */
#define	MII_ECR2	0x13	/* Extended control register 2 */

/* ECR bits */
#define	ECR_OVR		0x8000	/* RW: Do not allow writes to cmd reg */
#define	ECR_PHYADDR	0x07c0	/* RO: PHY address */
#define	ECR_CTEST	0x0020	/* RW: Stream cipher test mode */
#define	ECR_IECT	0x0004	/* RW: Invalid error code test */
#define	ECR_SSD		0x0001	/* RW: Stream cipher disable */

/* QPR bits */
#define	QPR_SPEED	0x8000	/* RO: 100 mbit mode */
#define	QPR_FDX		0x4000	/* RO: Full duplex */
#define	QPR_ANB2	0x2000	/* RO: Autonegotiation monitor bit 2 */
#define	QPR_ANB1	0x1000	/* RO: Autonegotiation monitor bit 1 */
#define	QPR_ANB0	0x0800	/* RO: Autonegotiation monitor bit 0 */
#define	QPR_RXERR	0x0400	/* RO: Receive signal lost */
#define	QPR_PLLERR	0x0200	/* RO: PLL Lock error */
#define	QPR_FCARR	0x0100	/* RO: False carrier detected */
#define	QPR_INVSYM	0x0080	/* RO: Invalid symbol detected */
#define	QPR_HALT	0x0040	/* RO: Halt symbol detected */
#define	QPR_PREEM	0x0020	/* RO: Two idles detected in a row */
#define	QPR_ACOMP	0x0010	/* RO: Autonegotiation complete */
#define	QPR_JABBER	0x0004	/* RO: Jabber detected */
#define	QPR_RFAULT	0x0002	/* RO: Remote fault */
#define	QPR_LINK	0x0001	/* RO: Link valid */

#define	QPR_FMT		"\20\20SPEED\17FDX\16ANB2\15ANB1\14ANB0\13RXERR\12PLLERR\11FCARR\10INVSYM\7HALT\6PREEM\5ACOMP\3JABBER\2RFAULT\1LINK"

/* TTR bits */
#define	TTR_RJABBER	0x8000	/* RO: Remote jabber */
#define	TTR_POLARITY	0x4000	/* RO: Polarity reversed */
#define	TTR_NOJABBER	0x0020	/* RW: Inhibit jabber check */
#define	TTR_LOOP	0x0010	/* RW: Enable loopback mode */
#define	TTR_NOAPOLARITY	0x0008	/* RW: Inhibit automatic polarity correction */
#define	TTR_NOSQE	0x0004	/* RW: Inhibit SQE test */
#define	TTR_NOLINKCHK	0x0002	/* RW: Inhibit link loss test */
#define	TTR_NOSQUELCH	0x0001	/* RW: Inhibit squelch */

/* ECR2 bits */
#define	ECR2_REPEATER	0x8000	/* RO: Repeater mode set */
#define	ECR2_HWSW	0x4000	/* RO: Hardware/software config priority */
#define	ECR2_LPRF	0x2000	/* RO: Link partner supports remote fault */
#define	ECR2_XRF	0x0400	/* RW: Force remote fault transmit */
#define	ECR2_RFPUP	0x0010	/* RW: Remote fault on power up */
#define	ECR2_Q10T	0x0004	/* RW: Use qualified 10baseT data */
#define	ECR2_10TPROT	0x0002	/* RW: Protect against 100baseTX data */
#define	ECR2_AUTODOWN	0x0001	/* RW: Power down automatically */

#endif /* !_ICS1890_H_ */
