/* Copyright (c) 1996,2000 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI lu6612.h,v 1.4 2001/03/06 15:11:18 geertj Exp
 */

#ifndef	_LU6612_H_
#define	_LU6612_H_

/*
 * Defines for the Lucent LU6612F/LU1216F PHY.
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define	LUPHY_OUI		0x601d	/* Lucent */
#define	LU6612_MODEL		12	/* LU6612 */
#define	LUASIC_MODEL		53	/* ASIC cell */

/*
 * Lucent LU6612 data sheet says that ANAR bits 15:0 are all r/w, not r/o --
 * typo?  Or do we have to set bit 15 to enable "next page" stuff?
 */

/* PHY specific registers */
#define	MII_DSR1	28	/* Device Specific Regiser 1 (status) */
#define	MII_DSR2	29	/* Device Specific Regiser 2 (100 Mb ctrl) */
#define	MII_DSR3	30	/* Device Specific Regiser 2 (10 Mb ctrl) */

#define	DSR1_BADFRM	0x0100	/* Bad Frame */
#define	DSR1_CODE	0x0080	/* Code Violation */
#define	DSR1_APS	0x0040	/* Autopolarity Status */
#define	DSR1_DISCON	0x0020	/* Disconnect */
#define	DSR1_UNLOCKED	0x0010	/* Unlocked */
#define	DSR1_RXERR_ST	0x0008	/* RX Error Status */
#define	DSR1_FRC_JAM	0x0004	/* Force Jam */
#define	DSR1_LNK100UP	0x0002	/* Link Up 100 */
#define	DSR1_LNK10UP	0x0001	/* Link Up 10 */

#define	DSR1_FMT	"\20\11BADFRM\10CODE\7APS\6DISCON\5UNLOCKED\4RXERR_ST\3FRC_JAM\2LNK100UP\1LNK10UP"

#define	DSR2_LOCALRST	0x8000	/* Local Management Reset */
#define	DSR2_RST1	0x4000	/* Generic Reset 1 (manufacture test only) */
#define	DSR2_RST2	0x2000	/* Generic Reset 2 (manufacture test only) */
#define	DSR2_100OFF	0x1000	/* 100 Mbit/s Transmitter Off */
/*			0x0800	-- reserved, must be zero */
#define	DSR2_CRS_SEL	0x0400	/* Carrier Sense Select */
#define	DSR2_LINK_ERR	0x0200	/* Link Error Indication */
#define	DSR2_PKT_ERR	0x0100	/* Packet Error Indication Enable */
/*			0x0080	-- reserved, must be zero */
#define	DSR2_EDB	0x0040	/* Encoder/Decoder Bypass */
#define	DSR2_SAB	0x0020	/* Symbol Aligner Bypass */
#define	DSR2_SDB	0x0010	/* Scrambler/Descrambler Bypass */
#define	DSR2_CARIN_EN	0x0008	/* Carrier Integrity Enable */
#define	DSR2_JAM_COL	0x0004	/* Jam Enable */
/*			0x0002	-- reserved, must be zero */
/*			0x0001	-- reserved, must be zero */

#define	DSR2_FMT	"\20\20LOCALRST\17RST1\16RST2\015100OFF\13CRS_SEL\12LINK_ERR\11PKT_ERR\7EDB\6SAB\5SDB\4CARIN_EN\3JAM_COL"

/*			0xffc0	-- reserved, read as zero */
#define	DSR3_HBT_EN	0x0020	/* Heartbeat Enable */
#define	DSR3_ELL_EN	0x0010	/* Extended Line Length Enable */
#define	DSR3_APF_EN	0x0008	/* Autopolarity Function Enable */
#define	DSR3_REF_SEL	0x0004	/* Reference Select */
#define	DSR3_SERIAL_SEL	0x0002	/* Serial Select */
#define	DSR3_ENA_NO_LP	0x0001	/* No Link Pulse Mode */

#define	DSR3_FMT	"\20\6HBT_EN\5ELL_EN\4APF_EN\3REF_SEL\2SERIAL_SEL\1ENA_NO_LP"

#endif /* !_LU6612_H_ */
