/* Copyright (c) 1998 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI lxt970.h,v 1.1.18.1 2001/03/22 02:50:02 geertj Exp
 */

#ifndef _LXT970_H_
#define _LXT970_H_

/*
 * Defines for Level One LXT 970 PHYceiver
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define	LXT_OUI		0x782000	/* XXX OUI is 0x00207b */
#define	LXT970P_MODEL	0		/* LXT 970 */

/* PHY specific registers */
#define	MII_IER		0x11	/* Interrupt Enable register */
#define	MII_ISR		0x12	/* Interrupt Status register */
#define	MII_CR		0x13	/* Configuration register */
#define	MII_CSR		0x14	/* Chip Status register */

/* CSR bits */
#define	CSR_LINK	0x2000	/* RO: link up */
#define	CSR_FDX		0x1000	/* RO: FDX mode */
#define	CSR_100		0x0800	/* RO: 100mbit mode */
#define	CSR_ACOMP	0x0200	/* RO: autoneg complete */
#define	CSR_PREC	0x0100	/* RO: page received */
#define	CSR_SLOCK	0x0040	/* RO: stream scrambler lock */
#define	CSR_SERR	0x0020	/* RO: symbol error */
#define	CSR_MLTE	0x0010	/* RO: MLT3 error */
#define	CSR_LOW		0x0004	/* RO: Low voltage */
#define	CSR_PLOCK	0x0001	/* RO: PLL lock */

#endif /* !_LXT970_H_ */
