/* 
 * Copyright (c) 2001 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI mar1000.h,v 1.1.2.1 2001/03/22 02:50:04 geertj Exp
 */

#ifndef _MAR1000_H_
#define _MAR1000_H_

/*
 * Defines for Marvell 'Alaska" 88E1000 PHYceivers
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define	MARVELL_OUI	0x005043
#define	M88E1000_MODEL	0x5		/* 88E1000 */
#define	M88E1000S_MODEL	0x4		/* 88E1000S */

/* PHY specific registers */
#define	MII_PSCR	0x10		/* PHY Specific Command Register */
#define	MII_PSSR	0x11		/* PHY Specific Status Register */
#define	MII_EPSC	0x14		/* Extended PHY Specfic Control */

/* PHY Specific Command Register - MII_PSCR */
#define	PSCR_CRS	0x0800		/* Assert CRS on TX */
#define	PSCR_CM_MASK	0x0060		/* Crossover mode mask */
#define	PSCR_CM_MDI	0x0000		/* MDI mode */
#define	PSCR_CM_MDIX	0x0020		/* MDI mode */
#define	PSCR_CM_AUTO	0x0060		/* MDI/MDIX auto crossover */

/* PHY Specific Status Register - MII_PSSR */
#define	PSSR_S_MASK	0xc000		/* Speed bits mask */	
#define	PSSR_S_1000	0x8000		/* 1000 Mb/s */
#define	PSSR_S_100	0x4000		/* 100 Mb/s */
#define	PSSR_S_10	0x0000		/* 10 Mb/s */
#define	PSSR_FD		0x2000		/* Full Duplex */	
#define	PSSR_PR		0x1000		/* Page Received */
#define	PSSR_SDR	0x0800		/* Speed/Duplex Resolved */
#define	PSSR_LINK	0x0400		/* Link */
#define	PSSR_MDIX	0x0040		/* 1=MDIX, 0=MDI */

/* Extended PHY Specfic Control - MII_EPSC */
#define	EPSC_TXCLK_0	0x0000		/* TX_CLK speed = 0 MHz */
#define	EPSC_TXCLK_2_5	0x0060		/* TX_CLK speed = 2.5 MHz */
#define	EPSC_TXCLK_25	0x0070		/* TX_CLK speed = 25 MHz */

#endif /* !_MAR1000_H_ */
