/* Copyright (c) 1996 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI mii.h,v 1.2.24.1 2001/03/22 02:50:03 geertj Exp
 */

#ifndef _MII_H_
#define	_MII_H_

/*
 * MII (IEE802.3u) hardware level defines
 */

#define	MII_NPHY	0x20	/* Maximum number of PHY's on a bus */

/* Standard PHY register numbers */
#define	MII_BMCR	0x00	/* Basic mode control */
#define	MII_BMSR	0x01	/* Basic mode status */
#define	MII_PHYIDR1	0x02	/* PHY Ident #1 (OUI MSB) */
#define	MII_PHYIDR2	0x03	/* PHY Ident #2 */
#define	MII_ANAR	0x04	/* Autonegotiation advertisement */
#define	MII_ANLPAR	0x05	/* Autonegotiation link partner abilities */
#define	MII_ANER	0x06	/* Autonegotiation expansion */
#define	MII_ANNPTR	0x07	/* Next-Page Transmit Register */
#define	MII_ANLPNPR	0x08	/* Link Partner Next Page Register */
#define	MII_MSCR	0x09	/* Master-Slave Control Register */
#define	MII_MSSR	0x0a	/* Master-Slave Status Register */
#define	MII_ESR		0x0f	/* Extended Status Register */

/* Mode control - MII_BMCR */
#define	BMCR_RESET	0x8000	/* RW: Software reset */
#define	BMCR_LOOP	0x4000	/* RW: Loopback */
#define	BMCR_AUTOEN	0x1000	/* RW: Enable autonegotiation */
#define	BMCR_PDOWN	0x0800	/* RW: Power down */
#define	BMCR_ISO	0x0400	/* RW: Isolate media and data */
#define	BMCR_STARTNEG	0x0200	/* RW: Restart autonegotiation */
#define	BMCR_FDX	0x0100	/* RW: Full duplex mode */
#define	BMCR_CTEST	0x0080	/* RW: Enable collision test */
#define	BMCR_S_MASK	0x2040	/*     Speed selector bits (mask) */
#define	BMCR_S_10	0x0000	/* RW: Select 10mbit */
#define	BMCR_S_100	0x2000	/* RW: Select 100mbit */
#define	BMCR_S_1000	0x0040	/* RW: Select 1000mbit */

#define	BMCR_FMT	"\20\20RESET\17LOOPBACK\16S100\15AUTOEN\14PDOWN"\				"\13ISO\12STARTNEG\11FDX\10CTEST\7S1000"

/* Mode status - MII_BMSR */
#define	BMSR_100T4	0x8000	/* RO: 100baseT4 capable */
#define	BMSR_100TXFDX	0x4000	/* RO: 100baseTX full duplex capable */
#define	BMSR_100TXHDX	0x2000	/* RO: 100baseTX half duplex capable */
#define	BMSR_10TFDX	0x1000	/* RO: 10baseT full duplex capable */
#define	BMSR_10THDX	0x0800	/* RO: 10baseT half duplex capable */
#define	BMSR_100T2FDX	0x0400	/* RO: 100baseT2 full duplex capable */
#define	BMSR_100T2HDX	0x0200	/* RO: 100baseT2 half duplex capable */
#define	BMSR_ESR	0x0100	/* RO: Extended Status (MII_ESR) exists */
#define	BMSR_PRESUPP	0x0040	/* RO: MIO preable suppressed OK */
#define	BMSR_ACOMP	0x0020	/* RO: Autonegotiation complete */
#define	BMSR_RFAULT	0x0010	/* RO: Remote fault */
#define	BMSR_ANEG	0x0008	/* RO: Autonegiation capable */
#define	BMSR_LINK	0x0004	/* RO: Link established */
#define	BMSR_JABBER	0x0002	/* RO: Jabber detected */
#define	BMSR_EXT	0x0001	/* RO: Extended register capable */

#define	BMSR_FMT	"\20\20T4\17TXFDX\16TXHDX\15TFDX\14THDX"\
			"\13T2FDX\12T2HDX\11ESR\7PRESUP\6ACOMP"\
			"\5RFAULT\4ANEG\3LINK\2JABBER\1EXT"

/* Ident 1 - MII_PHYIDR2 */
#define	IDR2_OUIMSB	0xfc00	/* RO: OUI MSB */
#define	IDR2_MODEL	0x03f0	/* RO: Vendor model  */
#define	IDR2_REV	0x000f	/* RO: Vendor revision */

/* Autonegotiation advertisement register - MII_ANAR */
#define	ANAR_NP		0x8000	/* RO: Next page able */
#define	ANAR_RF		0x2000	/* RO: Remote fault */
#define	ANAR_ASMDIR	0x0800	/* RW: Asymetric Pause */
#define	ANAR_PAUSE	0x0400	/* RW: Pause supported */
#define	ANAR_T4		0x0200	/* RW: 100BaseT4 supported */
#define	ANAR_TX_FD	0x0100	/* RW: 100BaseTX full duplex supported */
#define	ANAR_TX		0x0080	/* RW: 100BaseTX half duplex supported */
#define	ANAR_10_FD	0x0040	/* RW: 10BaseT full duplex supported */
#define	ANAR_10		0x0020	/* RW: 10BaseT half duplex supported */
#define	ANAR_CSMA	0x0001	/* RW: Protocol selector CSMA/CD */

#define	ANAR_FMT	"\20\20NP\16RF\14ASMDIR\13PAUSE\12T4"\
			"\11TXFDX\10TXHDX\7TFDX\6THDX\1CSMA"

/* Autonegotiation link partner ability register - MII_ANLPAR */
#define	ANLPAR_NP	0x8000	/* RO: Next page able */
#define	ANLPAR_RF	0x2000	/* RO: Remote fault */
#define	ANLPAR_ASMDIR	0x0800	/* R0: Asymetric Pause supported */
#define	ANLPAR_PAUSE	0x0400	/* R0: Pause supported */
#define	ANLPAR_T4	0x0200	/* R0: 100BaseT4 supported */
#define	ANLPAR_TX_FD	0x0100	/* R0: 100BaseTX full duplex supported */
#define	ANLPAR_TX	0x0080	/* R0: 100BaseTX half duplex supported */
#define	ANLPAR_10_FD	0x0040	/* R0: 10BaseT full duplex supported */
#define	ANLPAR_10	0x0020	/* R0: 10BaseT half duplex supported */
#define	ANLPAR_CSMA	0x0001	/* R0: Protocol selector CSMA/CD */

#define	ANLPAR_FMT	"\20\20NP\16RF\14ASMDIR\13PAUSE\12T4"\
			"\11TXFDX\10TXHDX\7TFDX\6THDX"\
			"\6THDX\1CSMA"

/* Autonegotiation expansion register - MII_ANER */
#define	ANER_MLF	0x0010	/* RO: Multiple link fault */
#define	ANER_LPNP	0x0008	/* RO: Link partner next page able */
#define	ANER_NP		0x0004	/* RO: Local next page able */
#define	ANER_PAGE_RX	0x0002	/* RO: Link code word page received */
#define	ANER_LPAN	0x0001	/* RO: Link partner supports autonegotiation */

#define	ANER_FMT	"\20\5MLF\4LPNP\3NP\2PAGE_RX\1LPAN"

/* Autonegotation Next Page Transmit Register - MII_ANNPTR */
#define	ANNPTR_NP	0x8000	/* RW: Next Page */
#define	ANNPTR_MP	0x2000	/* RO: Message Page */
#define	ANNPTR_ACK2	0x1000	/* RW: Acknowledge 2 */
#define	ANNPTR_TOGGLE	0x0800	/* RW: Toggle */

#define	ANNPTR_FMT	"\20\20NP\16\MP\15ACK2\14TOGGLE"

/* Autonegotation Link Partner Next Page Register - MII_ANLPNPR */
#define	ANLPNPR_NP	0x8000	/* RO: Next Page */
#define	ANLPNPR_ACK	0x4000	/* RO: Acknowledge */
#define	ANLPNPR_MP	0x2000	/* RO: Message Page */
#define	ANLPNPR_ACK2	0x1000	/* RO: Acknowledge 2 */
#define	ANLPNPR_TOGGLE	0x0800	/* RO: Toggle */

#define	ANLPNPR_FMT	"\20\20NP\17ACK\16\MP\15ACK2\14TOGGLE"

/* Master-Slave Control Register - MII_MSCR */
#define	MSCR_NORM	0x0000	/* RW: Test mode (normal) */
#define	MSCR_MMS	0x1000	/* RW: Manual master-slave configuration */
#define	MSCR_MASTER	0x0800	/* RW: 1=master, 0=slave */
#define	MSCR_MPORT	0x0400	/* RW: Prefer mult-port device */
#define	MSCR_1000_FD	0x0200	/* RW: 1000BASE-T full duplex supported */
#define	MSCR_1000	0x0100	/* RW: 1000BASET-T half duplex supported */

#define	MSCR_FMT	"\20\15MMS\14MASTER\13MPORT\121000FDX\111000"

/* Master-Slave Status Register - MII_MSSR */
#define	MSSR_MSERR	0x8000	/* RO: Master-Slave Error */
#define	MSSR_MASTER	0x4000	/* RO: Local PHY is Master */
#define	MSSR_LROK	0x2000	/* RO: Local receiver OK */
#define	MSSR_RROK	0x1000	/* RO: Remote receiver OK */
#define	MSSR_1000_FD	0x0800	/* RO: 1000BASE-T full duplex supported */
#define	MSSR_1000	0x0400	/* RO: 1000BASET-T half duplex supported */

#define	MSSR_FMT	"\20\20MSERR\17MASTER\16LROK\15\RROK\141000FD\131000"

/* Extended Status Register - MII_ESR */
#define	ESR_1000XFDX	0x8000	/* RO: 1000BASE-X full duplex capable */
#define	ESR_1000X	0x4000	/* RO: 1000BASE-X half duplex capable */
#define	ESR_1000TFDX	0x2000	/* RO: 1000BASE-T full duplex capable */
#define	ESR_1000T	0x1000	/* RO: 1000BASE-T half duplex capable */

#define	ESR_FMT	"\20\201000XFDX\171000X\161000TFDX\15\1000T"

#endif /* !_MII_H_ */

