/* Copyright (c) 1996 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI miivar.h,v 1.3.24.1 2001/03/22 02:50:03 geertj Exp
 */

#ifndef	_MIIVAR_H_
#define	_MIIVAR_H_

/*
 * MII (IEE802.3u) driver defines and interfaces
 */

typedef u_int32_t mii_oui_t;

typedef int (*mii_readreg_t) __P((struct device *parent, int phy, int reg));
typedef void (*mii_writereg_t) __P((struct device *parent, int phy, int reg,
    int val));
typedef void (*mii_statchg_t) __P((struct device *parent));

/* Parent softc data to support MII children */
typedef struct mii_data {
	struct ifmedia mii_media;	/* Published media */
	struct ifnet *mii_ifp;		/* For flags and packet counters */
	LIST_HEAD(mii_listhead, mii_softc) mii_phys;	/* All phys */
	int mii_instance;		/* Next available instance */

	/* Phy driver (whoever is the active one) status */
	int mii_media_status;		/* IFM_AVALID/IFM_ACTIVE */
	int mii_media_active;		/* Current synthesized media options */

	/* Calls from PHY drivers back up to parent */
	mii_readreg_t mii_readreg;
	mii_writereg_t mii_writereg;
	mii_statchg_t mii_statchg;
} mii_data_t;

/* Service calls from to PHY driver from parent */
typedef int (*mii_downcall_t) __P((struct mii_softc *self,
    struct mii_data *data, int cmd));

/* Downcall commands */
#define	MII_TICK	1
#define	MII_MEDIACHG	2
#define	MII_POLLSTAT	3

/* Base MII driver class */
typedef struct mii_softc {
	struct	device mii_dev;			/* Generic device */
	LIST_ENTRY(mii_softc)	mii_list;	/* All MIIs on interface */
	int	mii_phy;			/* phys address on MII bus */
	int	mii_inst;			/* Ifmedia instance # */
	mii_downcall_t mii_service;		/* Parent service downcall */
	struct mii_data *mii_pdata;		/* Parent data */
} mii_softc_t;


typedef struct mii_attach_args {
	mii_data_t		*mii_data;	/* Parent data */
	int			mii_phyno;	/* PHY address on bus */
	int			mii_id1;	/* PHY ident 1 */
	int			mii_id2;	/* PHY ident 2 */
	int			mii_capmask;	/* BMSR capability mask */
	int			mii_ecapmask;	/* KTSR capability mask */
} mii_attach_args_t;

#define	LOC_PHY		0		/* Phy locator index */

#ifdef KERNEL
/* MII_OUI macro is gone - see mii_oui() but read the comments!! */
#define	MII_MODEL(id2)		((id2) >> 4 & 0x3f)
#define	MII_REV(id2)		((id2) & 0xf )

int mii_anar __P((int));
int mii_ktcr __P((int));
int mii_phy_print __P((void *, char *));
int mii_mediachg __P((mii_data_t *));
void mii_tick __P((mii_data_t *));
void mii_pollstat __P((mii_data_t *));
void mii_phy_probe __P((struct device *, mii_data_t *, int, int));
mii_oui_t mii_oui __P((u_int id1, u_int id2));
mii_oui_t mii_oui_rev __P((u_int id1, u_int id2));
#endif

#endif /* !_MIIVAR_H_ */

