/* Copyright (c) 1997 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI qs6612.h,v 1.1 1997/09/08 23:11:04 geertj Exp
 */

#ifndef _QS6612_H_
#define _QS6612_H_

/*
 * Defines for Quality Semiconductor 6612 PHYceiver
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define	QS_OUI		0x006051
#define	QS_MODEL	0		/* QS6612, note error in datasheet */

/* PHY specific registers */
#define	MII_MCTL	0x11		/* Mode control */
#define	MII_ISRC	0x1d		/* Interrupt source */
#define	MII_IMASK	0x1e		/* Interrupt mask */
#define	MII_PCTL	0x1f		/* BASE-TX PHY control */

/* MCTL bits */
#define	MCTL_T4PRE	0x1000		/* RW: 100baseT4 interface present */
#define	MCTL_BTEXT	0x0800		/* RW: Reduce 10BT squelch level */

/* ISRC/IMASK bits */
#define	ISRC_TLINTR	0x8000		/* ThunderLAN interrupt mode */
#define	ISRC_ANCPL	0x0040		/* Auto-negotiation complete */
#define	ISRC_RFD	0x0020		/* Remote Fault detected */
#define	ISRC_LD		0x0010		/* Link Down */
#define	ISRC_ANLPA	0x0008		/* Auto-Negotiation LP ack */
#define	ISRC_PDT	0x0004		/* Parallel Detection Fault */
#define	ISRC_ANPR	0x0002		/* Auto-negotiation page received */
#define	ISRC_REF	0x0001		/* RX error counter full */

#define	PCTL_RXERDIS	0x2000		/* RW: RX error counter disable */
#define	PCTL_ANC	0x1000		/* RO: Auto Negotiation complete */
#define	PCTL_RLBEN	0x0200		/* RW: Remote coopback Enable */
#define	PCTL_DCREN	0x0100		/* RW: DC restoration enable */
#define	PCTL_4B5BEN	0x0040		/* RW: Enable 4B/5B encoding/decoding */
#define	PCTL_PHYISO	0x0020		/* RW: Isolate PHY */
#define	PCTL_OPMASK	0x001c		/*     Operation mode mask: */
#define	PCTL_AN		0x0000		/*      Auto-negotiation in progress */
#define	PCTL_10_T	0x0004		/*      10baseT HDX */
#define	PCTL_100_TX	0x0008		/*      100baseTX HDX */
#define	PCTL_100_T4	0x0010		/*      100baseT4 HDX */
#define	PCTL_10_T_FDX	0x0014		/*      10baseT FDX */
#define	PCTL_100_TX_FDX 0x0018		/*      100baseTX HDX */
#define	PCTL_MLT3DIS	0x0002		/* RW: Disable MLT3 encoding */
#define	PCTL_SCRDIS	0x0001		/* RW: Disable scrambling */

#endif /* !_QS6612_H_ */
