/* Copyright (c) 1998 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI sis900.h,v 1.1.2.1 2001/03/22 02:50:05 geertj Exp
 */

#ifndef _SIS900_H_
#define _SIS900_H_

/*
 * Defines for SiS 900 PHYceiver
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define	SIS_OUI		0x00e006

/* PHY specific registers */
#define	MII_CONFIG1	0x10	/* Interrupt Enable register */
#define	MII_CONFIG2	0x11	/* Interrupt Status register */
#define	MII_STSOUT	0x12	/* Interrupt Status register */
#define	MII_MASK	0x13	/* Configuration register */
#define	MII_RESERVED	0x14	/* Chip Status register */

#define	LNK_DIS		0x8000
#define	XMT_DIS		0x4000
#define	XMT_PDN		0x2000
#define	TXEN_CRS	0x1000
#define	UNSCR_DIS	0x0200
#define	EQLZR		0x0100
#define	CABLE		0x0080
#define	RLVL0		0x0040
#define	TLVL		0x003c
#define	TRF_n25		0x0003
#define	TRF_p00		0x0002
#define	TRF_p25		0x0001
#define	TRF_p50		0x0000

#define	PLED3		0xc000
#define	PLED2		0x3000
#define	PLED1		0x0c00
#define	PLED0		0x0300
#define	LED_DEV		0x00c0
#define	APOL_DIS	0x0020
#define	JAB_DIS		x00010

#define	INT		0x8000
#define	LNK_FAIL	0x4000
#define	LOSS_SYNC	0x2000
#define	CWRD		0x1000
#define	SSD		0x0800
#define	ESD		0x0400
#define	RPOL		0x0200
#define	JAB		0x0100
#define	SPD_DET		0x0080
#define	SPD_100		SPD_DET
#define	SPD_10		0
#define	DPLX_DET	0x0040
#define	ANEG_STS	0x0030
#define	ANEG_STARTED	0x0030
#define	ANEG_STUCK	0x0020
#define	ANEG_DONE	0x0010
#define	ANEG_NONE	0x0000

#define	MASK_INT	0x8000
#define	MASK_LNK_FAIL	0x4000
#define	MASK_LOSS_SYNC	0x2000
#define	MASK_CWRD	0x1000
#define	MASK_SSD	0x0800
#define	MASK_ESD	0x0400
#define	MASK_RPOL	0x0200
#define	MASK_JAB	0x0100
#define	MASK_SPD_DET	0x0080
#define	MASK_DPLX_DET	0x0040
#define	MASK_LNK_TMR	0x0007

#endif /* !_SIS900_H_ */
