/*
 * Copyright (c) 1999 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI sq80220.h,v 1.2.6.1 2001/03/22 02:50:04 geertj Exp
 */

#ifndef _SQ80220_H_
#define _SQ80220_H_

/*
 * Defines for Seeq 80220/80221/80223/80225 PHY
 *
 * Note: the bulk of the registers are defined in mii.h.
 *
 * While the 8022[013] has a number of registers in the private range
 * (register 16-19), the 80225 only has MII_SO, and only two bits defined
 * of that. Therefore, only these two bits are defined here.
 */

#define	SEEQ_OUI	0x00a07d
#define	SQ80220_MODEL	3
#define	SQ80223_MODEL	4
#define	SQ80225_MODEL	7

/* PHY specific registers */
#define	MII_SO		0x12	/* Status Out */

/* S0 bits */
#define	SO_SPD_DET	0x0080	/* RO: Speed: 1=100, 0=10 */
#define	SO_DPLX_DET	0x0040	/* RO: Full-Duplex */

#endif /* !_SQ80220_H_ */
