/*-
 * Copyright (c) 1996, 1997 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	tnete100a.h,v 1.1 1997/08/13 21:45:03 geertj Exp
 */

#ifndef _TNETE100A_H_
#define _TNETE100A_H_

/*
 * Defines for Texas Instruments TNETE100A built-in PHY.
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define	TN_OUI		0x100010	/* 0x10001[45] really */
#define	TN_OUIMASK	0xfffffff0
#define	TN100A_MODEL	1		/* TNETE100A */

/* PHY specific registers */
#define	TN_ID		0x10	/* PHY identifier */
#define	TN_CTL		0x11	/* PHY control register */
#define	TN_STS		0x12	/* PHY status register */

/* TN_CTL bits */
#define	TCTL_IGLINK	0x8000	/* RW: Ignore (lack of) link pulses */
#define	TCTL_SWAPOL	0x4000	/* RW: Swap polarity on input pair */
#define	TCTL_AUISEL	0x2000	/* RW: Use AUI(1) instead of baseT(0) */
#define	TCTL_SQEEN	0x1000	/* RW: SQE test enable */
#define	TCTL_NFEW	0x0004	/* RW: Not Far End Wrap */
#define	TCTL_INTEN	0x0002	/* RW: PHY interrupt enable */
#define	TCTL_TINT	0x0001	/* RW: Generate test interrupt */

/* TN_STS bits */
#define	TSTS_MINT	0x8000	/* RO: MII interrupt */
#define	TSTS_PHOK	0x4000	/* RO: Xtal osc OK */
#define	TSTS_POLOK	0x2000	/* RO: Polarity OK */
#define	TSTS_TPENERGY	0x1000	/* RO: TP enery detect */

#endif /* !_TNETE100A_H_ */
