/*
 * Copyright (c) 1996, 1999 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI scsi_spivar.h,v 2.15 2000/01/21 21:41:45 torek Exp
 */

#ifndef _SCSI_SPIVAR_H_
#define _SCSI_SPIVAR_H_


typedef struct spi_hba {
	struct	device hba_dev;		/* generic part */
	struct	spi_hbadriver *hba_driver;	/* hba driver */
	LIST_HEAD(h_t, targ) hba_tlist;
	scp_tailq_t	hba_startq;
	scp_list_t	hba_active;
	u_int	hba_maxoutstanding;	/* how many can be outstanding */
	u_int	hba_free2queue;		/* how many more we can queue */
	long	hba_iotime;		/* last io start or finish */
	u_int	hba_needreset;		/* set by HBA drivers to reset now */ 
} spi_hba_t;

#define SPI_NOHBAQUEUING  0xffffffff

scp_t	*spi_create_scp __P((unit_t *, int flags));
scp_t	*spi_create_unattached_scp __P((scp_t *, spi_hba_t *,
	    targ_t *, int tid, int lun, size_t hpsize, int flags));
void	spi_destroy_scp __P((scp_t *));

/*
 * these are the upcalls into the hba driver
 */
#define spistart_fn scp_fn
typedef void (*spireset_fn) __P((spi_hba_t *));
#define spirecover_fn scpv_fn
typedef void (*spiscpinit_fn) __P((scp_t *, int flags)); 

typedef struct spi_hbadriver {
    	spistart_fn	hd_start;
	spistart_fn	hd_start_s;	/* just used for boot and dump */
	spireset_fn	hd_reset;
	spirecover_fn	hd_recover;	
	spiscpinit_fn	hd_scpinit;
	scpv_fn		hd_scpdestroy;
} spi_hbadriver_t;

typedef struct spi_attach_args {
	scsi_attach_args_t	spia_sa;
	size_t	spia_htp_size;
	/*
	 * The following function gets called after the target
	 * as been found. Users of the low level spi code fill
	 * this in with spi_targ_negotiation. It is not required
	 * to be supplied.
	 */
	scpv_fn		spia_targcode;
	/*
	 * rest of stuff is specific to hba drivers which
	 * use the spi generic low level code.
	 */
	scp_fn		spia_notify;	/* transfer mode changed */
	u_int		spia_disconnect;
	u_int		spia_sync;
	u_int		spia_fast;
	u_int		spia_ultra;
	u_int		spia_ultra2;
	u_int		spia_ultra160;
	u_int		spia_wide;
	u_int		spia_tags;
	u_int		filler[4];
} spi_attach_args_t;


void	spi_establish __P((unit_t *, struct device *, scsi_attach_args_t*));
void	spi_reset_targets __P((spi_hba_t *));
targ_t	*spi_get_targ __P((spi_hba_t *, int tid));
unit_t	*spi_get_unit __P((spi_hba_t *, int tid, int lun));
int	spi_probe_targ __P((spi_hba_t *, spi_attach_args_t *));
int	spi_probe_targs __P((spi_hba_t *, spi_attach_args_t *, u_int targs));
int	spi_targprint __P((void *, char *));

void	spi_attachresetdelay __P((spi_hba_t *));
void	spi_probetimeout_init __P((spi_hba_t *, int *));
int	spi_probetimeout_check __P((spi_hba_t *, int *));
int	spi_busted_enquiry __P((scp_t *));

void	spi_setmaxtops __P((scp_t *, int max));
spi_attach_args_t *spi_get_spia __P((scp_t *));

void	spi_watch __P((void *)); /* really takes "spi_hba_t *" */
#define SPI_WATCH_INTERVAL	hz

#define	SPI_FOUNDTARGET(hba, sa) { \
	config_found(&(hba)->hba_dev, (void *)sa, spi_targprint); \
}

#define SPI_HBACONCURRENCY(hba, howmany) \
	(hba)->hba_maxoutstanding = (howmany); \
	(hba)->hba_free2queue = (howmany)

/*
 * This is here because the generic target code (scsi_spi.c) needs it as
 * well as the code in scsi_spilow.c
 */
typedef struct spi_softc {
	struct targ 	 sc_targ;	/* generic scsi target must be first */
	u_int		 sc_ioout;	/* count of outstanding ios */
	u_int		 sc_iomax;	/* maximum number of outstanding ios */
	size_t		 sc_upsize;	/* spc unit private size */
	size_t		 sc_hpsize;	/* spc hba private size */
	scp_tailq_t	 sc_startq;
	char		 sc_queueheld;
	scp_t		 *sc_scp;	/* for target initiated operations */
	scpv_fn		 sc_targcode;
	spi_attach_args_t *sc_spia;
} spi_softc_t;

/*
 * everything from here down deals with the low level support
 * provided by scsi_spilow.c
 */
void	spi_targ_negotiation __P((scp_t*));
int	spi_message __P((scp_t *, u_char *));
int	spi_buildmessage __P((scp_t *, u_char *, int));
void	spi_unstart __P((scp_t *));
#define SM_TOSS		0x100	/* toss the message and continue */
#define SM_REJECT	0x200	/* send a reject */


typedef struct spi_hba_target_private {
	u_int	htp_flags;
	u_char	htp_version;		/* scsi version */
	u_char	htp_msglen;		/* used to send negotition messages */
	u_char	htp_message[8];		/* lots of slop */
	u_int	htp_scsirate;		/* sync rate */
	u_char	htp_scsioffset;		/* sync offset */
	u_char	htp_scsiwidth;		/* width exponent */
	scp_fn	htp_notify;		/* something changed */
	struct scsi_inquiry htp_si;	/* used to negotiate transfer */
} spi_hba_target_private_t;


#define HTP_REJECT_OK	0x0010		/* ok for target to reject message */
#define HTP_REJECT_ED	0x0020		/* target rejected a message */
#define HTP_NOTLVD	0x0040		/* current target not on LVD segment*/

#define HTP_SEND_ID		0x0100	/* set by build_message */
#define HTP_SEND_TAG		0x0200
#define HTP_SET_DISCONNECT	0x0400
#define HTP_ID_CHECKED		0x0800
#define HTP_SET_DT		0x1000	    /* run in double transition mode */

#define	HTP_DO_DISCONNECT	0x01000000
#define	HTP_DO_TAGS		0x02000000
#define HTP_DO_SYNC		0x04000000
#define HTP_DO_FAST		0x08000000  /* negotiate up to 10 MB */
#define HTP_DO_WIDE		0x10000000
#define HTP_DO_ULTRA		0x20000000  /* negotiate up to 20 MB */	
#define HTP_DO_ULTRA2		0x40000000  /* negotiate up to 40 MB */
#define HTP_DO_ULTRA160		0x80000000  /* double transition 40 MB */

#endif /* !_SCSI_SPIVAR_H_ */
