/*
 * Copyright (c) 1992, 1993, 1994, 1996 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI scsivar.h,v 2.13 2000/01/21 21:41:45 torek Exp
 */

/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * All advertising materials mentioning features or use of this software
 * must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Lawrence Berkeley Laboratories.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)scsivar.h	8.1 (Berkeley) 6/10/93
 *
 * from: Header: scsivar.h,v 1.7 92/12/02 03:54:05 torek Exp (LBL)
 */

#ifndef _SCSI_VAR_H_
#define _SCSI_VAR_H_

#include <dev/scsi/scsi_ioctl.h>	/* sucko */

/*
 * in case we ever have to make them a full blown 64 bits
 * This only needs to be used by the unit drivers. Target and
 * hba drivers know how big the fields are
 */
typedef int	scsi_tid_t;	/* target id */
typedef int	scsi_lun_t;	/* logical unit number */	

#define SCP_HEAPSIZE	20

/*
 * Defines for data private to a particular module. This
 * allows the various modules to have small amounts of private
 * data quickly and easily accessable. In order of this
 * to work all users of this stuff must be defined to something
 * with the same length as a pointer.
 */
#ifndef U_SCP_PTYPE
#define U_SCP_PTYPE void *
#endif
#ifndef U_SCP_PTYPE1
#define U_SCP_PTYPE1 void *
#endif
#ifndef U_SCP_PTYPE2
#define U_SCP_PTYPE2 void *
#endif

#ifndef T_SCP_PTYPE
#define T_SCP_PTYPE void *
#endif
#ifndef T_SCP_PTYPE1
#define T_SCP_PTYPE1 void *
#endif
#ifndef T_SCP_PTYPE2
#define T_SCP_PTYPE2 void *
#endif

#ifndef H_SCP_PTYPE
#define H_SCP_PTYPE void *
#endif
#ifndef H_SCP_PTYPE1
#define H_SCP_PTYPE1 void *
#endif
#ifndef H_SCP_PTYPE2
#define H_SCP_PTYPE2 void *
#endif


typedef struct scp {
	/*
	 * To put on various queus. Define all types
	 * and let user choose which they are using.
	 */
	union	{
		LIST_ENTRY(scp)	l;
		TAILQ_ENTRY(scp)	t;
		CIRCLEQ_ENTRY(scp)	c;
	} scp_q;
	scsi_tid_t	 scp_tid;	/* target identifier */
	scsi_lun_t	 scp_lun;	/* logical unit number */
	struct unit	*scp_unit;
	struct targ	*scp_targ;
	int		(*scp_unitupstart)(struct scp *);
	int		(*scp_targupstart)(struct scp *);
	void		*scp_hba;	/* void because multiple hba types */
	volatile u_int	*scp_heapp;
	u_int		 scp_timeout;	/* bus is hung,  in seconds */
	/*
	 * end of stuff initialized by target routine which allocates
	 */
	volatile int	 scp_status;	
	size_t		 scp_len;	/* when no buf */
	volatile u_int	 scp_flags;
	int		 scp_resid;
	U_SCP_PTYPE	 scp_uprivate;	/* scp unit private data */
	U_SCP_PTYPE1	 scp_uprivate1;	/* scp unit private data */
	U_SCP_PTYPE2	 scp_uprivate2;	/* scp unit private data */
	T_SCP_PTYPE	 scp_tprivate;	/* scp target private data */
	T_SCP_PTYPE1	 scp_tprivate1;	/* scp target private data */
	T_SCP_PTYPE2	 scp_tprivate2;	/* scp target private data */
	H_SCP_PTYPE	 scp_hprivate;	/* scp hba private data */
	H_SCP_PTYPE1	 scp_hprivate1;	/* scp hba private data */
	H_SCP_PTYPE2	 scp_hprivate2;	/* scp hba private data */
	union {
	    struct buf	*scp_du_bp;
	    void	*scp_du_data;	/* when no buf */
	} scp_dataunion;
#define scp_bp	scp_dataunion.scp_du_bp
#define scp_data	scp_dataunion.scp_du_data
	size_t		 scp_cdblen;
	struct scsi_cdb	 scp_cdb;
	u_int		 scp_heap[SCP_HEAPSIZE];
	struct scsi_sense scp_sn;	/* contents from same */
	int		  scp_sn_avail;
} scp_t;

typedef LIST_HEAD(scp_list, scp) scp_list_t;
typedef TAILQ_HEAD(scp_tailq, scp) scp_tailq_t;
typedef CIRCLEQ_HEAD(scp_circleq, scp) scp_circleq_t;

/*
 * don't change the SCP_READ definition hba drivers count on it
 */
#define SCP_READ	B_READ
#define SCP_CONTINGENCY	0x01	/* put at head of queue and hold queue */
#define SCP_ATTACHING	0x02	/* no unit data yet */
#define SCP_WAITIO	0x04	/* don't return until complete */
#define SCP_NEEDWAKEUP	0x08	/* sleeping for IO to complete */
#define SCP_NOBP	0x10	/* no bp scp_data points at data */
#define SCP_NEEDRESID	0x20	/* tell hba driver resid is required */

typedef int (*scp_fn) __P((scp_t*));
typedef void (*scpv_fn) __P((scp_t*));

#define SCP_PUSH(scp, value)	*(scp->scp_heapp++) = (u_int) (value)  
#define SCP_CALL(scp)	 	((scpv_fn)*(--scp->scp_heapp))(scp)
#define SCP_POP(scp)		scp->scp_heapp--
#define SCP_POP1(scp)		scp->scp_heapp--
#define SCP_POP2(scp)		scp->scp_heapp -= 2
#define SCP_POP3(scp)		scp->scp_heapp -= 3
#define SCP_POP4(scp)		scp->scp_heapp -= 4
#define SCP_POPVP(scp)		((void*)*(--scp->scp_heapp))
#define SCP_POPI(scp)		((int)*(--scp->scp_heapp))
#define SCP_HEAPADR(scp)	((void*)(scp->scp_heapp))


typedef struct targ {
	struct device	 	t_dev;		/* generic driver part */
	scsi_tid_t	 	t_tid;		/* target identifier */
	LIST_ENTRY(targ) 	t_tlist;	/* targets on an hba */
	LIST_HEAD(t_u, unit)  	t_ulist;	/* units on this target */
	void            	*t_hba_private; /* per target hba storage */
} targ_t;


/* since a unit may be a disk, tape, etc., it has only pointer to dev */
typedef struct unit {
	struct device		*u_dev;		/* backpointer to generic */
	scsi_lun_t	 	 u_lun;		/* unit number on target */
	struct unitdriver	*u_driver;	/* unit driver */
	void		  	*u_hba_private;
	void		  	*u_targ_private;
	LIST_ENTRY(unit)    	 u_ulist;
	struct scsi_user_sense	 u_sense;	/* sense from last error */
} unit_t;

/*
 * SCSI unit driver (`downcalls' from target to unit).
 */
struct unitdriver {
	void	(*ud_reset) __P((struct unit *));	/* SCSI bus reset */
} unitdriver_t;

typedef struct scsi_attach_args {
	scsi_tid_t	 sa_tid;	/* target identifier */
	scsi_lun_t	 sa_lun;	/* unit number */
	int		 sa_req_status;	/* status from REQUEST SENSE */
	int		 sa_flgs;
#define SAF_RAID	0x01
	struct scsi_sense sa_sn;	/* contents from same */
	int		 sa_inq_status;	/* status from INQUIRY command */
	u_int		 sa_maxuops;	/* maximum ops per unit */
	u_int		 sa_maxtops;	/* maximum ops per target */
	size_t		 sa_upsize;	/* unit private scp size */
	size_t		 sa_hpsize;	/* hba private scp size */
	struct scsi_inquiry sa_si;	/* contents from same */
	scsi_lun_t	 sa_luns;	/* total number luns on target */
} scsi_attach_args_t;

/*
 * The SCSISENSEMSG macro converts a sense key into an error message
 * suitable for printing.
 */
extern const char *const scsisensekeymsg[];
#define	SCSISENSEKEYMSG(key) scsisensekeymsg[key]

/*
 * Declarations for exported functions in scsi_subr.c
 */
int	scsi_test_unit_ready __P((scp_t *));
int	scsi_request_sense __P((scp_t *, void *, int));
int	scsi_enquiry __P((scp_t *, void *, int));
void	scsi_printinq __P((struct scsi_inquiry *));
void	scsi_inq_ansi __P((struct scsi_inq_ansi *, char *, char *, char *));
const	char *scsi_translate_asc __P((int, int));
int	scsi_mode_select __P((scp_t *scp, char *buf, int len, 
		int pf, int sp));
int	scsi_mode_sense __P((scp_t *scp, char *buf, int len,
		int pc, int pagecode));

int	scsi_ioctl __P((dev_t, u_long cmd, void *data, struct proc *,	\
		scp_t*(*get_scp)(struct device *),			\
		void (*free_scp)(scp_t*),				\
		unit_t *u,
		int anyone));
void	scsi_nullcall __P((scp_t *scp));
void	scsi_timeoutcall __P((void *scp));

/*
 * The hba status bits want to remain out of the low order byte
 */
#define HBA_STATUS		0x8000		/* HBA supplying status */
#define HBA_BUSRESET		0x0100		/* Bus was reset */
#define HBA_AGAIN		0x0200		/* It may work if io is rerun */
#define HBA_MEDIUM		0x0400		/* the medium may have moved */
#define HBA_SELECTION_TIMEOUT	0x0800		/* selection timed out */
#define HBA_ALIGNMENT		0x1000		/* Wide SCSI odd alignment */

/*
 * The following will go away / be significantly changed
 * when there is more than one hba type
 * don't include scsi_spivar.h because the unit drivers will know
 * about things they shouldn't. Knowledge of spi_hba_t crept into
 * sd because of this.
 */
#define	scsi_start(scp)	(scp)->scp_unitupstart(scp)
#define scsi_dump(scp) spi_dump(scp)
#define scsi_establish(p, s, a) spi_establish(p, s, a)
#define scsi_create_scp(unit, flags) spi_create_scp(unit, flags)
scp_t   *spi_create_scp __P((unit_t *, int));
#define	scsi_destroy_scp(scp)	spi_destroy_scp(scp)
void	 spi_destroy_scp __P((scp_t *));

/*
 * SCP_S_NOINT is flag to scsi_create_scp
 * that says the scp will possibly be used while
 * interrupts are disabled.
 */
#define SCP_C_NOINT	1

#endif /* !_SCSI_VAR_H_ */
