/*
 * Copyright (c) 1996 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI spioctl.h,v 1.2 1996/10/11 16:00:24 pjd Exp
 */

#ifndef _SPIOCTL_H_
#define _SPIOCTL_H_

typedef struct splice_row {
	struct splice_row	*r_next;
	daddr_t			 r_firstblk;
	daddr_t			 r_lastblk;
	u_int			 r_interlace;
	u_int			 r_cyclesize;	/* interlace * devcount */
	u_int			 r_devcount;
	dev_t			*r_devs;
	daddr_t			 r_offset;
} splice_row_t;

typedef struct splice_config {
	u_int			 c_unit;	/* unit being build */
	u_int			 c_rpm;
	splice_row_t		*c_row;
} splice_config_t;

#define SPSETSPLICE	_IOW('S', 1, splice_config_t)

#endif /* !_SPIOCTL_H_ */
