/*
 * Copyright (c) 1997 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI cpuioctl.h,v 2.2 1997/10/28 22:36:09 ewv Exp
 */

#ifndef _CPUIOCTL_H_
#define _CPUIOCTL_H_

struct cpu_getbootp {
	int num;
	int len;
	void *data;
};

struct cpu_dregs {
	int	dr0;
	int	dr1;
	int	dr2;
	int	dr3;
	int	dr6;
	int	dr7;
};

#define	CPU_DESCLEN	64		/* # of chars copied for ii_desc */

struct cpu_inin {
	int	isrc;
	intr_info_t ent;
	char	desc[CPU_DESCLEN];
};

struct cpu_phmap {
	int	num;		/* Cpu or IOAPIC number */
	u_long	paddr;		/* Physical address */
};

struct cpu_apicop {
	int	apic_num;	/* APIC number, -1 for local apic */
	int	reg;		/* Register number or byte offset */
	int	data;
};

struct cpu_setlint {
	int	cpu_id;		/* Cpu number */
	int	lint_no;	/* 0 or 1 */
	int	lvtdata;	/* What to put in LVT entry */
};

struct cpu_defhand {
	int ioapic;
	int pin;
	char *message;
};

struct cpu_getpciinfo {
	int cnt;
	struct cpu_pciinfo *pip;
};

struct cpu_pciinfo {
	int	bus;
	int	agent;
	int	function;
	int	vendor;
	int	device;
	int	irq;
	int	pin;
};

struct cpu_stat {
	int	sio_mode;
	int	numcpu;
	int	state[MAXCPUS];
};

struct cpu_getihand {
	int	irqno;
	int	num;
	struct intrhand ih;
};

#define	CPUGETBOOTP	_IOWR('G', 0, struct cpu_getbootp)
#define	CPUMAP_LAPIC	_IOW('G', 1, struct cpu_phmap)
#define	CPUMAP_IAPIC	_IOW('G', 2, struct cpu_phmap)
#define	CPUSETUPBSP	_IOW('G', 3, int)
#define	CPURDAPIC	_IOWR('G', 6, struct cpu_apicop)
#define	CPUWRAPIC	_IOWR('G', 7, struct cpu_apicop)
#define	CPUSETLINT	_IOW('G', 8, struct cpu_setlint)
#define	CPUGO		_IOW('G', 10, int)
#define	CPUSTOP		_IOW('G', 11, int)
#define	CPUSETDR	_IOW('G', 12, struct cpu_dregs)
#define	CPUGETDR	_IOR('G', 13, struct cpu_dregs)
#define	CPUGETPCIINFO	_IOWR('G', 16, struct cpu_getpciinfo)
#define	CPUCLKSYNC	_IO('G', 17)
#define	CPUSTAT		_IOR('G', 18, struct cpu_stat)
#define	CPUGETIHAND	_IOWR('G', 19, struct cpu_getihand)
#define	CPUSETININ	_IOW('G', 20, struct cpu_inin)
#define	CPUGETININ	_IOWR('G', 21, struct cpu_inin)
#define	CPUSIO		_IOW('G', 22, int)

/* Bits for CPUSIO (hacks / workarounds/etc...) */
#define	CPU_IMCR	0x0001	/* Touch IMCR register during transition */
#define	CPU_NOSTOPBSP	0x0002	/* Not allowed to stop boot processor */
#define	CPU_AUTOEOI	0x0004	/* Program 8259's for Auto-EOI mode */

#ifdef KERNEL
int cpu_setdr __P((struct cpu_dregs *sbp));
#endif	/* KERNEL */
#endif	/* _CPUIOCTL_H_ */
