/*-
 * Copyright (c) 1997, 1998 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI cpuvar.h,v 2.6 1998/06/03 18:33:06 karels Exp
 */

#ifndef _CPUVAR_H_
#define	_CPUVAR_H_

/*
 * BIOS warm boot vector (in real page 0, used in real mode)
 */
#define	WARMBOOT_OFF		(KERNBASE + 0x467)
#define	WARMBOOT_SEG		(KERNBASE + 0x469)

/*
 * IDT vectors for SMP
 *
 * Note: at this point the priorities (IDT# >> 4) don't matter much, we 
 *       always EOI the interrupt just about as soon as we receive it.
 *	 We do spread the I/O interrupts through the IDT space as
 *       recommended by Intel (they say one should avoid more than 2 I/O
 *	 interrupts per priority level, due to the size of a FIFO on the 
 *	 APIC).
 *
 *       Currently the only (safe) way to block IPI's is with 'cli', although
 *       we may eventually want to use the task priority register to block
 *       all interrupts less than a given priority value. At this point the
 *       spl mechanism blocks specific groups of interrupt sources in S/W.
 */
#define	IDT_MIN_IOVEC		0x20
#define	IDT_MAX_IOVEC		0xf5		/* IDT's available for I/O */

/* IPI's (can steal down to 0xf4 if needed) */
#define	IDT_IPI_STOP		0xf6
#define	IDT_IPI_SETDR		0xf7
#define	IDT_IPI_HALT		0xf8
#define	IDT_IPI_TLBSHOOT	0xf9
#define	IDT_IPI_AST		0xfa
#define	IDT_IPI_PCLOCK		0xfb
#define	IDT_IPI_CLKSYNC		0xfc
#define	IDT_IPI_TLBSHOOTPG	0xfd

/* Local APIC interrupts (SPURIOUS must be at (VEC & 0xf) == 0xf) */
#define	IDT_APIC_ERR		0xfe
#define	IDT_APIC_SPURIOUS	0xff		/* bits 0-3 must be 1's */

/*
 * IPI macros
 *
 * Use: specify target as a cpu number (0-15).
 */
#define	IPI_TLBSHOOT()		i386_ipi_short( IDT_IPI_TLBSHOOT |	\
						ICR_LEVEL_ASSERT |	\
						ICR_DH_ALLE)
#define	IPI_AST(target)		i386_ipi(target,IDT_IPI_AST  |		\
						ICR_LEVEL_ASSERT |	\
						ICR_DH_DEST)
#define	IPI_CLKSYNC()		i386_ipi_short( IDT_IPI_CLKSYNC |	\
					 	ICR_LEVEL_ASSERT | 	\
						ICR_DH_ALLS)

#define	IPI_TLBSHOOTPG()	i386_ipi_short( IDT_IPI_TLBSHOOTPG |	\
						ICR_LEVEL_ASSERT |	\
						ICR_DH_ALLE)
#define	IPI_SETDR()		i386_ipi_short( IDT_IPI_SETDR |		\
						ICR_LEVEL_ASSERT |	\
						ICR_DH_ALLE)

/* Machine independent macro to run pcpu_hardclock */
#define	IPI_PCLOCK_ALL()	i386_ipi_short( IDT_IPI_PCLOCK |	\
					 	ICR_LEVEL_ASSERT | 	\
						ICR_DH_ALLE)

#if defined(KERNEL) && !defined(LOCORE)

struct bpinfo {
	caddr_t addr;
	int data;
	int type;
	int len;
};

struct cpu_getpciinfo;
struct cpu_defhand;

void cputick __P((void *dummy));
void cpuattach __P((int num));
int cpuioctl __P((dev_t dev, u_long cmd, caddr_t data, int fflag,
    struct proc *p));
int cpu_getbootp __P((caddr_t data));
int cpu_map_local_apic __P((caddr_t data));
int cpu_map_io_apic __P((caddr_t data));
int cpu_symio __P((int flags));
char *alloc_idt_handler __P((u_int esi, u_int edi, int htype));
void cpu_init_local_apic __P((void));
struct pcpu *cpu_alloc_pcpu __P((int cpuno));
int cpu_go __P((void *data));
int cpu_ap_startup __P((void));
int cpu_clocksync __P((void));
void cpu_set_shutdown __P((u_char code));
void halt_other_cpus __P((void));
int cpu_getpciinfo __P((struct cpu_getpciinfo *pp));
void cpu_disable_all_ioapic_vecs __P((void));
int cpu_get_ioapic_nregs __P((int n));

void idleproc __P((int cpu));
int npxinit __P((struct proc *p, int control));
void rtcout __P((int addr, int data));

/* Locore.s funcs */
struct pcb;
struct gate_descriptor;

void lidt __P((struct gate_descriptor *, int cnt));
void lldt __P((int sel));
void ltr __P((int sel));
void load_cr0 __P((int cr0));
void identifycpu __P((void));
void restorectx __P((struct pcb *pcb));
int rcr0 __P((void));
void tlbflush __P((void));
int get_clk_diff __P((struct pcpu *));
int set_slave_clk __P((struct pcpu *));

#endif

#define	APIC_DEF_SHFT	4		/* log2(sizeof(apic_defdata)) */

#endif	/* _CPUVAR_H_ */
