/*	BSDI genassym.c,v 2.13 2000/04/28 03:00:43 donn Exp	*/

/*-
 * Copyright (c) 1982, 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)genassym.c	8.2 (Berkeley) 9/23/93
 */

#ifndef lint
static char sccsid[] = "@(#)genassym.c	8.2 (Berkeley) 9/23/93";
#endif /* not lint */

#define KERNEL

#include <sys/param.h>
#include <sys/buf.h>
#include <sys/map.h>
#include <sys/proc.h>
#include <sys/mbuf.h>
#include <sys/msgbuf.h>
#include <sys/device.h>
#include <machine/cpu.h>
#include <machine/trap.h>
#include <machine/pcpu.h>
#include <machine/psl.h>
#include <machine/reg.h>
#include <machine/mutex.h>
#include <vm/vm.h>
#include <sys/user.h>
#include <i386/isa/isa.h>
#include <i386/isa/isavar.h>
#include <i386/i386/cpuioctl.h>

#include "syscall.h"

main()
{
	struct proc *p = (struct proc *)0;
	struct vmmeter *vm = (struct vmmeter *)0;
	struct user *up = (struct user *)0;
	struct rusage *rup = (struct rusage *)0;
	struct uprof *uprof = (struct uprof *)0;
	struct vmspace *vms = (struct vmspace *)0;
	struct pcb *pcb = (struct pcb *)0;
	struct syscframe *sf = (struct syscframe *)0;
	struct pcpu *pc = (struct pcpu *)0;
	struct ktr_entry *kp = (struct ktr_entry *)0;
	mutex_t *m = (mutex_t *)0;
	intr_info_t *ii = (intr_info_t *)0;
	local_apic_t *la = (local_apic_t *)APIC_VA;
	struct io_apic *ioa = (struct io_apic *)0;
	struct trapframe *tfp = (struct trapframe *)0;
	struct cpu_dregs *kdr = (struct cpu_dregs *)0;

	printf("#define\tCPU_386 %d\n", CPU_386);
	printf("#define\tCPU_486 %d\n", CPU_486);
	printf("#define\tCPU_586 %d\n", CPU_586);
	printf("#define\tP_FORW %d\n", &p->p_forw);
	printf("#define\tP_BACK %d\n", &p->p_back);
	printf("#define\tP_VMSPACE %d\n", &p->p_vmspace);
	printf("#define\tVM_PMAP %d\n", &vms->vm_pmap);
	printf("#define\tP_ADDR %d\n", &p->p_addr);
	printf("#define\tP_PRIORITY %d\n", &p->p_priority);
	printf("#define\tP_STAT %d\n", &p->p_stat);
	printf("#define\tP_WCHAN %d\n", &p->p_wchan);
	printf("#define\tP_FLAG %d\n", &p->p_flag);
	printf("#define\tP_PID %d\n", &p->p_pid);
	printf("#define\tSSLEEP %d\n", SSLEEP);
	printf("#define\tSRUN %d\n", SRUN);
	printf("#define\tV_SWTCH %d\n", &vm->v_swtch);
	printf("#define\tV_TRAP %d\n", &vm->v_trap);
	printf("#define\tV_SYSCALL %d\n", &vm->v_syscall);
	printf("#define\tV_INTR %d\n", &vm->v_intr);
	printf("#define\tV_SOFT %d\n", &vm->v_soft);
	printf("#define\tV_FAULTS %d\n", &vm->v_faults);
	printf("#define\tUPAGES %d\n", UPAGES);
	printf("#define\tCLSIZE %d\n", CLSIZE);
	printf("#define\tNBPG %d\n", NBPG);
	printf("#define\tPGSHIFT %d\n", PGSHIFT);
	printf("#define\tPDRSHIFT %d\n", PDRSHIFT);
	printf("#define\tSZ_PDE %d\n", sizeof(struct pde));
	printf("#define\tSZ_PTE %d\n", sizeof(struct pte));
	printf("#define\tSZ_PCPU %d\n", sizeof(struct pcpu) + KTR_SIZE);
	printf("#define\tPCPU_TSS_ESP0 %d\n", &pc->tss.tss_esp0);
	printf("#define\tPCPU_TSS_CR3 %d\n", &pc->tss.tss_cr3);
	printf("#define\tPCB_LINK %d\n", &pcb->pcb_tss.tss_link);
	printf("#define\tPCB_ESP0 %d\n", &pcb->pcb_tss.tss_esp0);
	printf("#define\tPCB_SS0 %d\n", &pcb->pcb_tss.tss_ss0);
	printf("#define\tPCB_ESP1 %d\n", &pcb->pcb_tss.tss_esp1);
	printf("#define\tPCB_SS1 %d\n", &pcb->pcb_tss.tss_ss1);
	printf("#define\tPCB_ESP2 %d\n", &pcb->pcb_tss.tss_esp2);
	printf("#define\tPCB_SS2 %d\n", &pcb->pcb_tss.tss_ss2);
	printf("#define\tPCB_CR3 %d\n", &pcb->pcb_tss.tss_cr3);
	printf("#define\tPCB_EIP %d\n", &pcb->pcb_tss.tss_eip);
	printf("#define\tPCB_EFLAGS %d\n", &pcb->pcb_tss.tss_eflags);
	printf("#define\tPCB_EAX %d\n", &pcb->pcb_tss.tss_eax);
	printf("#define\tPCB_ECX %d\n", &pcb->pcb_tss.tss_ecx);
	printf("#define\tPCB_EDX %d\n", &pcb->pcb_tss.tss_edx);
	printf("#define\tPCB_EBX %d\n", &pcb->pcb_tss.tss_ebx);
	printf("#define\tPCB_ESP %d\n", &pcb->pcb_tss.tss_esp);
	printf("#define\tPCB_EBP %d\n", &pcb->pcb_tss.tss_ebp);
	printf("#define\tPCB_ESI %d\n", &pcb->pcb_tss.tss_esi);
	printf("#define\tPCB_EDI %d\n", &pcb->pcb_tss.tss_edi);
	printf("#define\tPCB_ES %d\n", &pcb->pcb_tss.tss_es);
	printf("#define\tPCB_CS %d\n", &pcb->pcb_tss.tss_cs);
	printf("#define\tPCB_SS %d\n", &pcb->pcb_tss.tss_ss);
	printf("#define\tPCB_DS %d\n", &pcb->pcb_tss.tss_ds);
	printf("#define\tPCB_FS %d\n", &pcb->pcb_tss.tss_fs);
	printf("#define\tPCB_GS %d\n", &pcb->pcb_tss.tss_gs);
	printf("#define\tPCB_LDT %d\n", &pcb->pcb_tss.tss_ldt);
	printf("#define\tPCB_IOOPT %d\n", &pcb->pcb_tss.tss_ioopt);
	printf("#define\tU_PROF %d\n", &up->u_stats.p_prof);
	printf("#define\tU_PROFSCALE %d\n", &up->u_stats.p_prof.pr_scale);
	printf("#define\tPR_BASE %d\n", &uprof->pr_base);
	printf("#define\tPR_SIZE %d\n", &uprof->pr_size);
	printf("#define\tPR_OFF %d\n", &uprof->pr_off);
	printf("#define\tPR_SCALE %d\n", &uprof->pr_scale);
	printf("#define\tRU_MINFLT %d\n", &rup->ru_minflt);
	printf("#define\tPCB_FLAGS %d\n", &pcb->pcb_flags);
	printf("#define\tPCB_SAVEFPU %d\n", &pcb->pcb_savefpu);
	printf("#define\tFP_WASUSED %d\n", FP_WASUSED);
	printf("#define\tFP_USESEMC %d\n", FP_USESEMC);
	printf("#define\tPCB_CMAP2 %d\n", &pcb->pcb_cmap2);
	printf("#define\tPCB_LDTDEFCALL %d\n", &pcb->pcb_ldtdefcall);
	printf("#define\tPCB_IDT80GATE %d\n", &pcb->pcb_idt80gate);
	printf("#define\tPCB_ONFAULT %d\n", &pcb->pcb_onfault);
	printf("#define\tSYSC_FRAMESIZE %d\n", sizeof(struct syscframe));
	printf("#define\tSF_EFLAGS %d\n", &sf->sf_eflags);
	printf("#define\tSF_EIP %d\n", &sf->sf_eip);
	printf("#define\tSF_CS %d\n", &sf->sf_cs);
	printf("#define\tSF_ESP %d\n", &sf->sf_esp);
	printf("#define\tSF_SS %d\n", &sf->sf_ss);

	printf("#define\tB_READ %d\n", B_READ);
	printf("#define\tENOENT %d\n", ENOENT);
	printf("#define\tEFAULT %d\n", EFAULT);
	printf("#define\tENAMETOOLONG %d\n", ENAMETOOLONG);
	printf("#define\tMAXHOSTNAMELEN %d\n", MAXHOSTNAMELEN);
	printf("#define\tAPIC_VA 0x%x\n", APIC_VA);
	printf("#define\tPCPU_STATE 0x%x\n", &pc->pc_state);
	printf("#define\tPCPU_ASTPENDING 0x%x\n", &pc->astpending);
	printf("#define\tPCPU_CURPROC 0x%x\n", &pc->curproc);
	printf("#define\tPCPU_CURPCB 0x%x\n", &pc->curpcb);
	printf("#define\tPCPU_PREVPROC 0x%x\n", &pc->prevproc);
	printf("#define\tPCPU_NPXPROC 0x%x\n", &pc->npxproc);
	printf("#define\tPCPU_WANTRESCHED 0x%x\n", &pc->want_resched);
	printf("#define\tPCPU_LDT 0x%x\n", &pc->ldt);
	printf("#define\tPCPU_IDT 0x%x\n", &pc->idt);
	printf("#define\tPCPU_USER_TPR 0x%x\n", &pc->pc_user_tpr);
	printf("#define\tPCPU_APIC_ERR_INTRS 0x%x\n", &pc->pc_apic_err_intrs);
	printf("#define\tPCPU_APIC_SEND_CSUM 0x%x\n", &pc->pc_apic_send_csum);
	printf("#define\tPCPU_APIC_RECV_CSUM 0x%x\n", &pc->pc_apic_recv_csum);
	printf("#define\tPCPU_APIC_SEND_ACC 0x%x\n", &pc->pc_apic_send_acc);
	printf("#define\tPCPU_APIC_RECV_ACC 0x%x\n", &pc->pc_apic_recv_acc);
	printf("#define\tPCPU_APIC_SEND_ILL_VEC 0x%x\n",
	    &pc->pc_apic_send_ill_vec);
	printf("#define\tPCPU_APIC_RECV_ILL_VEC 0x%x\n",
	    &pc->pc_apic_recv_ill_vec);
	printf("#define\tPCPU_APIC_ILL_REG_ADRS 0x%x\n",
	    &pc->pc_apic_ill_reg_adrs);
	printf("#define\tPCPU_APIC_STRAY 0x%x\n", &pc->pc_apic_stray);
	printf("#define\tPCPU_RESCHED_IPI 0x%x\n", &pc->pc_resched_ipi);
	printf("#define\tPCPU_RESCHED_IPI_N 0x%x\n", &pc->pc_resched_ipi_n);
	printf("#define\tPCPU_HALT_ESP 0x%x\n", &pc->pc_halt_esp);
	printf("#define\tPCPU_CLKLO 0x%x\n", &pc->pc_clk[0]);
	printf("#define\tPCPU_CLKHI 0x%x\n", &pc->pc_clk[1]);
	printf("#define\tPCPU_GDT 0x%x\n", &pc->gdt[0]);
	printf("#define\tPCPU_ERROR 0x%x\n", &pc->pc_error);
	printf("#define\tPCPU_TRIGGER 0x%x\n", &pc->pc_trigger);
#ifdef KTR
	printf("#define\tPCPU_KTR_IDX 0x%x\n", &pc->pc_ktr_idx);
	printf("#define\tPCPU_KTR_BUF 0x%x\n", &pc->pc_ktr_buf);
#endif
	printf("#define\tPCPU_CPUNO 0x%x\n", &pc->cpuno);
	printf("#define\tMUTEX_OWN 0x%x\n", &m->m_owner);
	printf("#define\tMUTEX_COUNT 0x%x\n", &m->m_count);
	printf("#define\tMUTEX_GATE 0x%x\n", &m->m_gate);
#ifdef SMP_DEBUG
	printf("#define\tMUTEX_NAME 0x%x\n", &m->m_name);
#endif
	printf("#define\tNO_CPU 0x%x\n", NO_CPU);
	printf("#define\tKTR_CLKV 0x%x\n", &kp->u.ktr_clk);
	printf("#define\tKTR_DESC 0x%x\n", &kp->ktr_desc);
	printf("#define\tKTR_PARM1 0x%x\n", &kp->ktr_parm1);
	printf("#define\tKTR_PARM2 0x%x\n", &kp->ktr_parm2);
	printf("#define\tKTR_PARM3 0x%x\n", &kp->ktr_parm3);
	printf("#define\tKTR_PARM4 0x%x\n", &kp->ktr_parm4);
	printf("#define\tKTR_PARM5 0x%x\n", &kp->ktr_parm5);
	printf("#define\tII_MASK 0x%x\n", &ii->ii_mask);
	printf("#define\tII_FLAGS 0x%x\n", &ii->ii_flags);
	printf("#define\tII_BASE 0x%x\n", &ii->ii_base);
	printf("#define\tII_REGSEL 0x%x\n", &ii->ii_regsel);
	printf("#define\tII_DISABLE 0x%x\n", &ii->ii_disable);
	printf("#define\tII_ENABLE 0x%x\n", &ii->ii_enable);
	printf("#define\tII_IPENDMASK 0x%x\n", &ii->ii_ipendmask);
	printf("#define\tII_DESC 0x%x\n", &ii->ii_desc);
	printf("#define\tII_IRQ 0x%x\n", &ii->ii_irq);
	printf("#define\tII_CNT 0x%x\n", &ii->ii_cnt);
	printf("#define\tII_SIZE 0x%x\n", sizeof(intr_info_t));
	if (sizeof(intr_info_t) != 1 << II_SHIFT)
		errx(1, "intr_info_t changed size, fix II_SHIFT");
	printf("#define\tLAPIC_TPR 0x%x\n", &la->la_tpr);
	printf("#define\tLAPIC_ICR 0x%x\n", &la->la_int_command);
	printf("#define\tLAPIC_EOI 0x%x\n", &la->la_eoi);
	printf("#define\tLAPIC_ESR 0x%x\n", &la->la_esr);
	printf("#define\tLAPIC_ID 0x%x\n", &la->la_unit_id);
	printf("#define\tLAPIC_ERR 0x%x\n", &la->la_error_vec);
	printf("#define\tLAPIC_SPURIOUS 0x%x\n", &la->la_spurious_vector);
	printf("#define\tIOAPIC_REGSEL 0x%x\n", &ioa->ia_select);
	printf("#define\tIOAPIC_REGWIN 0x%x\n", &ioa->ia_window);
	printf("#define\tSIZEOF_TF 0x%x\n", sizeof(struct trapframe));
	printf("#define\tTF_EFLAGS 0x%x\n", &tfp->tf_eflags);
	printf("#define\tTF_CS 0x%x\n", &tfp->tf_cs);
	printf("#define\tTF_EIP 0x%x\n", &tfp->tf_eip);
	printf("#define\tGDT_SIZE 0x%x\n", sizeof(pc->gdt));
	printf("#define\tKDR_DR0 0x%x\n", &kdr->dr0);
	printf("#define\tKDR_DR1 0x%x\n", &kdr->dr1);
	printf("#define\tKDR_DR2 0x%x\n", &kdr->dr2);
	printf("#define\tKDR_DR3 0x%x\n", &kdr->dr3);
	printf("#define\tKDR_DR6 0x%x\n", &kdr->dr6);
	printf("#define\tKDR_DR7 0x%x\n", &kdr->dr7);
	printf("#define\tIDTSPACE 0x%x\n", IDTSIZE *
	    sizeof(struct gate_descriptor));
	exit(0);
}
