/*-
 * Copyright (c) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999
 * Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI globals.s,v 2.2 2000/04/28 03:00:44 donn Exp
 */
 
/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)locore.s	7.3 (Berkeley) 5/13/91
 *	from NetBSD: Id: locore.s,v 1.12 1993/05/27 16:44:13 cgd Exp
 *
 *      @(#)locore.s	8.3 (Berkeley) 9/23/93
 */

#include "assym.s"

#include <machine/vmlayout.h>

	.global	_KERNBASE
	.set	_KERNBASE, __KERNBASE

	.global	_USRSTACK
	.set	_USRSTACK, __USRSTACK

	.global	_KPTDI_FIRST
	.set	_KPTDI_FIRST, __KPTDI_FIRST

	.global	_NKPTD
	.set	_NKPTD, __NKPTD

	.global	_PTDPTDI
	.set	_PTDPTDI, __PTDPTDI

	.global	SYSTEM
	.set	SYSTEM, __KERNBASE + NBPG

	.global	_VM_MIN_ADDRESS
	.set	_VM_MIN_ADDRESS, __VM_MIN_ADDRESS

	.global	_VM_MAXUSER_ADDRESS
	.set	_VM_MAXUSER_ADDRESS, __VM_MAXUSER_ADDRESS

/*
 * PTmap is recursive pagemap at top of virtual address space.
 * Within PTmap, the page directory can be found (third indirection).
 */
	.global	PTmap, PTD, PTDpde
	.set	PTmap, __PTMAP
	.set	PTD, __PTMAP + (PTDPTDI * NBPG)
	.set	PTDpde, PTD + (SZ_PDE * PTDPTDI)

/*
 * APTmap, APTD is the alternate recursive pagemap.
 * It's used when modifying another process's page tables.
 */
	.global	APTmap, APTD, APTDpde
	.set	APTmap, __APTMAP
	.set	APTD, __APTMAP + (APTDPTDI * NBPG)
	.set	APTDpde, PTD + (SZ_PDE * APTDPTDI)

/*
 * Per CPU pages
 */
	.global	apic
	.set	apic, APIC_VA
