/*-
 * Copyright (c) 1993, 1994, 1998 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI i386_param.c,v 2.23 2000/04/21 07:44:03 dab Exp
 */

/*
 * Configuration-dependent data for i386 kernels.
 */

#include <sys/param.h>
#include <sys/reboot.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <machine/pcpu.h>

#include <i386/i386/cons.h>

/*
 * Parameters
 */
#ifndef SYSPTSIZE
#define	SYSPTSIZE 0		/* dynamically chosen based on physmem */
#endif
int	sysptsize = SYSPTSIZE;	/* system page table size, in pages */

/*
 * Root configuration
 */
configroot()
{

#if GENERIC
	if ((boothowto & RB_ASKNAME) == 0)
		setroot();
	setconf();
#else
	setroot();
#endif
}

/*
 * Machine-dependent onfiguration parameters.
 */
#ifdef PARITY_ERR_PANIC
int	nmi_panic = 1;	/* panic on NMI parity errors/channel checks */
#else
int	nmi_panic = 0;	/* do not panic on NMI parity errors/channel checks */
#endif

/*
 * Configuration for com driver.
 * This is referenced by checkbootparams, so is always included. These
 * are overridden if the bootstrap passes a com console specification.
 */
#include <i386/isa/isa.h>

#include "com.h"

#ifdef COMCONSOLE
int	comconsole = COMCONSOLE;
#else
int	comconsole = -1;
#endif
#ifndef	COMCNADDR
#define COMCNADDR IO_COM1
#endif
int	com_cnaddr = COMCNADDR;		/* console base address */
int	com_cnrate = TTYDEF_SPEED;	/* for console */


/*
 * configuration for pccons console driver
 */
#include "pccons.h"
#if NPCCONS > 0

#include <i386/isa/isavar.h>
#include <i386/isa/pcconsvar.h>
#include <i386/isa/pcconsioctl.h>

#ifdef PCCONS_NOCOLOR
int	pccons_trycolor = 0;
#else
int	pccons_trycolor = 1;
#endif

#ifndef	KBD
#define	KBD	US
#endif

/*
 * Macro magic to #include KBDPREF ## KBD
 */
#undef i386
#ifdef __STDC__ 
#define KBDPREF	i386/isa/kbd/pcconstab.
#define	R(a,b)	< ## a ## b ## >
#define	S(a,b)	R(a,b)

#include S(KBDPREF,KBD)

#else /* __STDC__ */

#define KBDPREF	i386/isa/kbd/pcconstab
#define	D	KBDPREF.KBD
#define	I	<D>
#include I
#endif /* __STDC__ */
#define	i386

struct constab pcct = {
	sizeof(pcconstab) / sizeof(pcconstab[0]),
	pcextstart,
	pcextend,
	sizeof(pcaltconstab) / sizeof(pcaltconstab[0]),
	maxaccent,
	sizeof(accenttab) / sizeof(accenttab[0]),
	pcconstab,
	pcexttab,
	pcexttab,
	accenttab
};
#endif

#ifndef CNTLALTDEL
#define CNTLALTDEL -1
#endif
int	cntlaltdel = CNTLALTDEL;/* recognize cntl-alt-del, ask reboot? */

#ifndef CNTLALTDELCORE
#ifdef DEBUG
#define CNTLALTDELCORE 1
#else
#define CNTLALTDELCORE 0
#endif
#endif
int	cntlaltdelcore = CNTLALTDELCORE; /* ask about core dump? */

/* configuration for indirect console driver */
/* XXX - all this could be autoconfig()ed */
#if NPCCONS > 0
int pccnprobe(), pccninit(), pccngetc(), pccnputc();
#endif
#if NCOM > 0
int comcnprobe(), comcninit(), comcngetc(), comcnputc();
#endif

struct	consdev constab[] = {
#if NPCCONS > 0
	{ pccnprobe,	pccninit,	pccngetc,	pccnputc },
#endif
#if NCOM > 0
	{ comcnprobe,	comcninit,	comcngetc,	comcnputc },
#endif
	{ 0 },
};
/* end XXX */

#include "npx.h"
#if NNPX == 0
npxinit(p, control)
	struct proc *p;
	int control;
{
}
#endif

/* 
 * Only look a the first 32 of 256 pci buses. Some machines wrap the
 * address space. The Compaq Proliant wraps at 64.
 */
#ifndef	PCI_SCAN_BUSES
#define	PCI_SCAN_BUSES 32
#endif 
int	pci_scan_buses = PCI_SCAN_BUSES;

/*
 * By default look at the first 8 functions on each pci agent.
 */
#ifndef	PCI_SCAN_FUNCTIONS
#define	PCI_SCAN_FUNCTIONS 8
#endif
int	pci_scan_functions = PCI_SCAN_FUNCTIONS;

/*
 * Stub for ATAPI changer code
 */
#ifndef ATAPICHG
void
wchg_attach()
{
}
#endif

/*
 * Stub for decether.c
 * Binary distribution fails to build if ISO not defined
 */
#ifndef ISO
char all_es_snpa[] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };
#endif

/*
 * Stubs for building without SMP support
 */
#include "cpu.h"
#if NCPU == 0
void
halt_other_cpus()
{
	asm("	.global apic_handler_vecs;"
	    "apic_handler_vecs:;"
	    "	.global	START_INTRS2, END_INTRS2;"
	    "	.set	START_INTRS2, 0;"
	    "	.set	END_INTRS2, 1;");
}

int
cpu_ap_startup()
{
	return (0);
}
#endif

/*
 * First per-cpu structure (for boot CPU)
 */
char first_pcpu[sizeof(struct pcpu) + KTR_SIZE]
    __attribute__((__aligned__(NBPG)));

/*
 * Stub for building without COFF support.
 */
#ifndef COFF

#include <vm/vm.h>
#include <sys/vnode.h>
#include <sys/text.h>

int
exec_coff_binary(xp)
	struct text *xp;
{

	return (ENOEXEC);
}

int
exec_aout_shlib(xp)
	struct text *xp;
{

	return (ENOEXEC);
}

int
load_emulator(xp)
	struct text *xp;
{

	return (ENOEXEC);
}
#endif

/*
 * Stub for network interrupts in binary kernels.
 */
void
nullintr()
{
	panic("undef net intr");
}

#ifndef	INET6
	asm("	.globl	ip6intr;"
	    "	.set	ip6intr, nullintr;");
#endif

#ifndef	INET
	asm("	.globl	ipintr;"
	    "	.set	ipintr, nullintr;");
#if	NETHER == 0 && NFDDI == 0 && NTOKEN == 0
	asm("	.globl	arpintr;"
	    "	.set	arpintr, nullintr;");
#endif
#endif

#ifndef	NS
	asm("	.globl	nsintr;"
	    "	.set	nsintr, nullintr;");
#endif

#ifndef	ISO
	asm("	.globl	clnlintr;"
	    "	.set	clnlintr, nullintr;");
#endif

#ifndef	CCITT
	asm("	.globl	ccittintr;"
	    "	.set	ccittintr, nullintr;");
#endif
