/*	BSDI specialreg.h,v 2.2.16.1 2001/04/20 22:54:21 donn Exp	*/

/*-
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)specialreg.h	8.1 (Berkeley) 6/11/93
 */

/*
 * 386 Special registers
 */

/* bit definitions for CR0 */
#define	CR0_PE	0x00000001	/* Protected mode Enable */
#define	CR0_MP	0x00000002	/* "Math" Present (e.g. npx), wait for it */
#define	CR0_EM	0x00000004	/* EMulate NPX, e.g. trap, don't execute code */
#define	CR0_TS	0x00000008	/* Process has done Task Switch, do NPX save */
#define	CR0_ET	0x00000010	/* 32 bit (if set) vs 16 bit (387 vs 287) */
#define	CR0_NE	0x00000020	/* numeric exceptions via exc. 16 (486 only) */
#define	CR0_WP	0x00010000	/* write-protect in kernel mode (486 only) */
#define	CR0_AM	0x00040000	/* enable alignment checking (Pentium+) */
#define	CR0_NW	0x20000000	/* not-writethrough (Pentium+) */
#define	CR0_CD	0x40000000	/* Internal cache disable (Pentium+) */
#define	CR0_PG	0x80000000	/* Paging Enable */

#define	ENABLE_FPU()	__asm__ __volatile__ ("clts")
#define	DISABLE_FPU()	load_cr0(rcr0() | CR0_TS)
#define	FPU_ENABLED()	((rcr0() & CR0_TS) == 0)

/* bit definitions for CR4 (Pentium+) */
#define	CR4_VME	0x00000001	/* Virtual mode extensions */
#define	CR4_PVI	0x00000002	/* Protected mode virtual interrupts */
#define	CR4_TSD	0x00000004	/* Disable CPL0 access to TOD counter */
#define	CR4_DE	0x00000008	/* Debugging extensions */
#define	CR4_PSE	0x00000010	/* Page size extensions (4MB pages) */
#define	CR4_MCE	0x00000040	/* Machine check exception enable */
