/*
 * WILDBOAR $Wildboar: apm.h,v 1.4 1996/02/13 13:00:47 shigeya Exp $
 */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _MACHINE_APM_H_
#define _MACHINE_APM_H_

#define _PATH_DEVAPM	"/dev/apm"

#define	APM_INSTALLATION_CHECK	0x5300	/* device should be APM_DEV_BIOS */

/* Flags returned in CX */
#define		APMF_P16_SUPPORTED	0x01
#define		APMF_P32_SUPPORTED	0x02
#define		APMF_IDLE_REDUCES_CLK	0x04
#define		APMF_BIOS_PM_ENABLED	0x08

#define	APM_CONNECT_REAL	0x5301
#define	APM_CONNECT_P16		0x5302
#define	APM_CONNECT_P32		0x5303
#define	APM_DISCONNECT		0x5304
#define	APM_CPU_IDLE		0x5305
#define	APM_CPU_BUSY		0x5306
#define	APM_SET_POWER_STATE	0x5307

/* APM device IDs */
#define		APM_DEV_BIOS		0x0000
#define		APM_DEV_ALL		0x0001
#define		APM_DEV_DISP_BASE	0x0100
#define		APM_DEV_DISP_ALL	0x01ff
#define		APM_DEV_DISK_BASE	0x0200
#define		APM_DEV_DISK_ALL	0x02ff
#define		APM_DEV_PPORT_BASE	0x0300
#define		APM_DEV_PPORT_ALL	0x03ff
#define		APM_DEV_SPORT_BASE	0x0400
#define		APM_DEV_SPORT_ALL	0x04ff
#define		APM_DEV_NIC_BASE	0x0500
#define		APM_DEV_NIC_ALL		0x05ff
#define		APM_DEV_PCMCIA_BASE	0x0600
#define		APM_DEV_PCMCIA_ALL	0x06ff
#define		APM_DEV_ALL_V10		0xffff	/* APM V1.0 */

/* APM power states */
#define		APM_PSTAT_READY		0x0000
#define		APM_PSTAT_STANDBY	0x0001
#define		APM_PSTAT_SUSPEND	0x0002
#define		APM_PSTAT_OFF		0x0003

#define	APM_SYSTEM_STANDBY	APM_SET_POWER_STATE
#define	APM_SYSTEM_SUSPEND	APM_SET_POWER_STATE

#define	APM_PM_CONTROL		0x5308		/* device = 0xffff */

/* APM states */
#define		APM_DISABLE		0
#define		APM_ENABLE		1

#define	APM_RESTORE_DEFAULT	0x5309		/* device = 0xffff */
#define	APM_GET_POWER_STATUS	0x530a		/* device = ALL = 1 */

#define	APM_GET_PM_EVENT	0x530b

/*
 * APM event codes
 * Event codes 0x100 and above are synthetic and produced by the system.
 * Synthetic codes are non-standard.
 */
#define		APM_EVENT_STANDBY_REQ		0x01
#define		APM_EVENT_SUSPEND_REQ		0x02
#define		APM_EVENT_NORMAL_RESUME		0x03
#define		APM_EVENT_CRITICAL_RESUME	0x04
#define		APM_EVENT_LOW_BATTERY		0x05
#define		APM_EVENT_STATUS_CHANGE		0x06
#define		APM_EVENT_UPDATE_TIME		0x07
#define		APM_EVENT_CRITICAL_SUSPEND	0x08
#define		APM_EVENT_USER_STANDBY_REQ	0x09
#define		APM_EVENT_USER_SUSPEND_REQ	0x0a
#define		APM_EVENT_STANDBY_RESUME	0x0b
#define		APM_EVENT_BATTERY		0x100
#define		APM_EVENT_BATTERY_0		0x101
#define		APM_EVENT_BATTERY_1		0x102
#define		APM_EVENT_BATTERY_2		0x103
#define		APM_EVENT_BATTERY_3		0x104
#define		APM_EVENT_ERROR_RESUME		0x200
#define		APM_EVENT_CLOCK_CHANGE		0x201

#define	APM_GET_POWER_STATE	0x530c
#define	APM_ENABLE_DEVICE_POWER_MANAGEMENT	0x530d
#define	APM_DISABLE_DEVICE_POWER_MANAGEMENT	0x530d

#define	APM_GET_DRIVER_VERSION	0x530e
#define	APM_ENGAGE_PM		0x530f

#define	APM_GET_CAPABILITIES	0x5310
#define		APM_CAP_STANDBY			0x0001
#define		APM_CAP_SUSPEND			0x0002
#define		APM_CAP_RESUME_STANDBY		0x0004
#define		APM_CAP_RESUME_SUSPEND		0x0008
#define		APM_CAP_RESUME_INTRING_STANDBY	0x0010
#define		APM_CAP_RESUME_INTRING_SUSPEND	0x0020
#define		APM_CAP_RESUME_PCRING_STANDBY	0x0040
#define		APM_CAP_RESUME_PCRING_SUSPEND	0x0080
#define	APM_RESUME_TIMER	0x5311
#define		APM_RESUME_TIMER_DISABLE	0x00
#define		APM_RESUME_TIMER_GET		0x01
#define		APM_RESUME_TIMER_SET		0x02
#define	APM_RESUME_ON_RING	0x5312
#define		APM_RESUME_ON_RING_DISABLE	0x00
#define		APM_RESUME_ON_RING_GET		0x01
#define		APM_RESUME_ON_RING_SET		0x02
		/* return value in cx */
#define		APM_RESUME_ON_RING_DISABLED	0x00
#define		APM_RESUME_ON_RING_ENABLED	0x01

/* error codes */
#define	APME_PM_DISABLED		1
#define	APME_CONN_BUSY			2
#define	APME_NO_CONN			3
#define	APME_REAL_NO_CONN		4
#define	APME_P16_CONN_BUSY		5
#define	APME_P16_NOT_SUPPORTED		6
#define	APME_P32_CONN_BUSY		7
#define	APME_P32_NOT_SUPPORTED		8
#define	APME_BAD_DEV			9
#define	APME_INVAL			0xa
#define	APME_NOT_ENGAGED		0xb
#define	APME_OPNOTSUPP			0xc
#define	APME_RESUME_TIMER_DISABLED	0xd
#define	APME_CANT_ENTER			0x60
#define	APME_NO_EVENT			0x80
#define	APME_NOT_PRESENT		0x86

typedef struct {
	int		code;
	char		*string;
} apm_table_t;

#define	APM_ERROR_TAB \
	{ APME_PM_DISABLED,		"APM disabled", }, \
	{ APME_CONN_BUSY,		"APM connection busy", }, \
	{ APME_NO_CONN,			"APM no connection", }, \
	{ APME_REAL_NO_CONN,		"APM no connection in real mode", }, \
	{ APME_P16_CONN_BUSY,		"APM 16 bit connection busy", }, \
	{ APME_P16_NOT_SUPPORTED,	"APM 16 bit mode not supported", }, \
	{ APME_P32_CONN_BUSY,		"APM 32 bit connection busy", }, \
	{ APME_P32_NOT_SUPPORTED,	"APM 32 bit mode not supported", }, \
	{ APME_BAD_DEV,			"APM device invalid", }, \
	{ APME_INVAL,			"APM argument invalid", }, \
	{ APME_NOT_ENGAGED,		"APM not engaged", }, \
	{ APME_OPNOTSUPP,		"APM oppperation not supported", }, \
	{ APME_RESUME_TIMER_DISABLED,	"APM resume timer disabled", }, \
	{ APME_CANT_ENTER,		"APM cannot enter requested state", }, \
	{ APME_NO_EVENT,		"APM event not present", }, \
	{ APME_NOT_PRESENT,		"APM device not present", }, \
	{ 0, NULL, },

#define	APM_MAX_BATTERY			4	/* batteries we keep track of */
#endif /*_MACHINE_APM_H_*/
