/*	BSDI apmioctl.h,v 1.5 2000/06/18 03:36:19 prb Exp */
/* WILDBOAR $Wildboar: apmioctl.h,v 1.6 1996/03/17 08:06:52 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _MACHINE_APMIOCTL_H_
#define _MACHINE_APMIOCTL_H_

#include <sys/time.h>

struct apmreq {
	int	func ;
	int	dev ;
	int	arg ;
	int	err ;
	int	aret ;
	int	bret ;
	int	cret ;
} ;

struct apmreq2 {
	int	ax, bx, cx, dx, si, di;
	int	apmreq_err;
#define	apmreq_func	ax
#define	apmreq_dev	bx
#define	apmreq_arg	cx
} ;

struct apmlog {
	u_short	version ;
	u_short	length ;
	struct	timespec when ;
	int	event ;
	int	info ;
} ;

#define	PIOCAPMREQ		_IOWR('P', 1, struct apmreq)
#define	PIOCAPMSTART		_IOWR('P', 2, int)
#define	PIOCAPMSTOP		_IOWR('P', 3, int)
#define	PIOCWSUSPEND		_IO('P', 4)
#define	PIOCWRESUME		_IO('P', 5)
#define	PIOCLASTRESUME		_IOR('P', 6, struct timeval)
#define	PIOCAPMREQ2		_IOWR('P', 7, struct apmreq2)
#define	PIOCGAPMMODE		_IOR('P', 8, int)
#define	PIOCSAPMMODE		_IOW('P', 9, int)

#ifdef MAXTIME
/* Toshiba T3400 specific (MAXTIME configuration register r/w) */
#define	PIOCGMTCFG		_IOWR('P', 254, int)
#define	PIOCSMTCFG		_IOW('P', 255, int)
#endif

#endif /* !_MACHINE_APMIOCTL_H_ */
