/*-
 * Copyright (c) 1992, 1994, 1996 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI bootparam.h,v 2.10 2001/02/27 05:07:41 prb Exp
 *
 * WILDBOAR $Wildboar: bootparam.h,v 1.6 1996/02/13 13:01:21 shigeya Exp $
 * 
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 */

#ifndef _MACHINE_BOOTPARAM_H_
#define _MACHINE_BOOTPARAM_H_

/*
 * Structure for ISA/EISA disk parameters in BIOS.
 */
#ifndef LOCORE
struct biosgeom {
	u_short	ncylinders;		/* number of cylinders */
	u_char	ntracks;		/* number of heads */
	u_char	eflag;			/* EIDE: 0xA? for enhanced IDE */
	u_char	esectors;		/* EIDE: real number of sectors */
	u_char	wpcom[2];		/* start of write precompensation */
	u_char	res1;
	u_char	ctl;			/* "control" byte */
	u_char	ecyl[2];		/* EIDE: cylinders low/high */
	u_char	etracks;		/* EIDE: number of heads */
	u_char	lzone[2];		/* landing zone */
	u_char	nsectors;		/* number of sectors/track */
	u_char	flags;			/* EIDE: checksum / BSD flag word */
};
#else /* LOCORE */
#define	SZ_BIOSGEOM	16
#endif /* LOCORE */

#define	BIOSGEOM_PRESENT	0x01	/* Drive is present */
#define	BIOSGEOM_MAPPED		0x02	/* This is a mapped geometry */
#define	BIOSGEOM_EIDE		0x04	/* Passes EIDE check sum */

#ifndef LOCORE
/*
 * Various information from the bios to pass along for later.
 */
struct biosinfo {
	u_int	basemem;		/* base memory */
	u_int	extmem;			/* "extended" memory */
	u_char	kbflags;		/* keyboard status, including NUMLOCK */
	int	spare[3];		/* expansion space */
};

/*
 * Much-shrunken version of disklabel, to be passed from bootxx
 * on to kernel so that we don't have to try bios/default geometry
 * (which screws up on certain controllers).
 * This is implemented, but not normally compiled in,
 * as it is only a partial solution to the problem.
 */
struct bsdgeom {
	int	unit;			/* unit number this is for */
	u_long	ncylinders;		/* number of cylinders */
	u_long	ntracks;		/* number of heads */
	u_long	nsectors;		/* number of sectors/track */
	daddr_t	bsd_startsec;		/* sector number of BSD label */
};

struct bootcons {
	int	type;			/* type of console */
	int	unit;			/* device unit number */
	int	val0;			/* depends on type (port, etc.) */
	int	val1;			/* depends on type (port, etc.) */
};

/* values for bootcons type field: */
#define	BOOTCONS_KBDISP	0		/* vga/cga/mda + pccons kbd (default) */
					/* val0, val1 ignored */
#define	BOOTCONS_COM	1		/* com-style serial port */
					/* val0 is port, val1 is speed */

struct boot_pnpid {
	 char	pi_devname[16];		/* driver id from drivercf */
	 char	pi_id[8];		/* PnP device/compatable id */
};

#endif /* LOCORE */

/*
 * The initial interrupt table contains "far" pointers to disk parameters
 * for drives 0 and 1, if present and known to the BIOS.
 */
#define	BIOSGEOM0	(0x41*4)	/* INT 41 */
#define	BIOSGEOM1	(0x46*4)	/* INT 46 */

/*
 * Location of the BIOS keyboard status byte in BIOS low memory.
 * (This should probably be elsewhere.)
 */
#define	BIOSKBFLAGP	((u_char *) 0x417)

#define	BIOS_KB_NUMLOCK	0x20		/* bit for numlock active in kbflags */
#define	BIOS_KB_ALT	0x08		/* bit for alt down in kbflags */
#define	BIOS_KB_CTRL	0x04		/* bit for control down in kbflags */
#define	BIOS_KB_LSHIFT	0x02		/* bit for left shift down in kbflags */
#define	BIOS_KB_RSHIFT	0x01		/* bit for rt shift down in kbflags */

/*
 * Machine-dependent boot parameters
 */
#define	B_BIOSGEOM	B_MACHDEP(1)	/* biosgeom[2]: CMOS/BIOS disk params */
#define	B_BIOSINFO	B_MACHDEP(2)	/* biosinfo: sundry info */
#define	B_BSDGEOM	B_MACHDEP(3)	/* bsdgeom: distilled disklabel */
#define	B_CONSOLE	B_MACHDEP(4)	/* bootcons: console location */
#define	B_BIOSPM	B_MACHDEP(5)	/* PM-BIOS interface parameters */
#define	B_ISAPARAM	B_MACHDEP(6)	/* ISA interface parameters */
#define B_PNPID		B_MACHDEP(7)	/* Add addition PnP identifier */ 
#define	B_INTEL_MP	B_MACHDEP(8)	/* Intel MP structure */
#define	B_ACPI_SMAP	B_MACHDEP(9)	/* ACPI System Address Map */

#define BOOT_MAXPARAMS	8192

#endif /* !_MACHINE_BOOTPARAM_H_ */
