/*-
 * Copyright (c) 1992,1993,1994,1995,1998,2001 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI cpu.h,v 2.19.2.1 2001/05/03 18:23:14 prb Exp
 */

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)cpu.h	8.4 (Berkeley) 1/5/94
 */

#ifndef _MACHINE_CPU_H_
#define _MACHINE_CPU_H_

/*
 * Definitions unique to i386 cpu support.
 */
#ifndef LOCORE
#include <machine/frame.h>
#include <machine/segments.h>
#include <machine/psl.h>
#ifndef STANDALONE
#ifdef	KERNEL
#include <machine/inline.h>
#endif
#include <machine/pcpu.h>
#endif
#include <sys/entropy.h>

/*
 * definitions of cpu-dependent requirements
 * referenced in generic code
 */
#define	COPY_SIGCODE		/* copy sigcode above user stack in exec */

#define	cpu_exec(p)			/* nothing */
#define	cpu_swapin(p)			/* nothing */
#define cpu_setstack(p, ap)		(p)->p_md.md_regs[SP] = ap
#define cpu_set_init_frame(p, fp)	/* nothing; done in cpu_fork */
#define	cpu_kernproc(p)
#define	cpu_endkernproc(p)

extern u_int nonemask;

/*
 * We collect entropy on Pentiums and i386's
 */
#define	COLLECT_ENTROPY(x)	((*collect_entropy)(x))

void (*collect_entropy)(entropy_t);
void collect_entropy_pentium(entropy_t);
void collect_entropy_i386(entropy_t);

/*
 * Arguments to hardclock and statclock
 * encapsulate the previous machine state in an opaque
 * clockframe; for now, use generic intrframe.
 *
 * Currently, we can't tell if we were running at interrupt level,
 * and thus CLKF_INTR always evaluates to false.
 */
struct clockframe {
	struct intrframe	cf_if;
};

#define	CLKF_USERMODE(framep)	(((framep)->cf_if.if_eflags & PSL_VM) || \
				 (ISPL((framep)->cf_if.if_cs) == SEL_UPL))
#define	CLKF_BASEPRI(framep)	((framep)->cf_if.if_ppl == nonemask)
#define	CLKF_PC(framep)		((framep)->cf_if.if_eip)
#define	CLKF_INTR(framep)	0	/* wish for better */

#define	CYCLE_COUNTER(x) \
	do { if (cpu >= CPU_586) rdtsc(x); else (x) = 0; } while (0)
typedef u_quad_t		cyclecnt_t;

/*
 * Some processors have multiple clock rates.
 * As we discover them we add them to this array
 */
#define	CLK_RATES	8
typedef struct {
	cyclecnt_t	when;		/* When this entry was last used */
	int		clks_per_tick;
	int		clks_per_sec;
	int		clks_per_usec;
	int		clks_per_tick_delta;
	int		clks_per_tick_margin;
} clk_rate_t;
extern clk_rate_t clk_rates[CLK_RATES];

extern int clks_per_tick_margin;
extern int clks_per_tick_delta;
extern int clks_per_tick;
extern int clks_per_sec;
extern int clks_per_usec;

/*
 * When use_cycle_time is set then it is safe for hardclock to call
 * microtime to set the value of time.
 */
#define	USE_MICROTIME_IN_HARDCLOCK

/*
 * Preempt the current process if in interrupt from user mode,
 * or after the current trap/syscall if in system mode.
 */

#define RESCHED_SWITCH		1
#define RESCHED_NORMAL		2
#define RESCHED_ROUND_ROBIN	4
#define	need_resched(type) \
	do { SET_PCPU(want_resched, type); aston(); } while (0)

/*
 * Give a profiling tick to the current process when the user profiling
 * buffer pages are invalid.  On i386, request an ast to send us
 * through trap, marking the proc as needing a profiling tick.
 */
#define	need_proftick(p) \
	do { (p)->p_flag |= P_OWEUPC; aston(); } while (0)

/*
 * Notify the current process (p) that it needs to make
 * a trip through trap as soon as possible.
 */
#define aston()		INC_PCPU(astpending)
#define	setsoftclock()	schednetisr(NETISR_SCLK)
#define	setsoftnet()	lockd_or(ipending, IRQSOFT)


#endif /* LOCORE */

/* Processor Identification Signature definitions */
#define	CPUID_MASK_RESV		0xf0000000
#define	CPUID_MASK_XFAMILY	0x0ff00000	/* Extended family */
#define	CPUID_MASK_XMODEL	0x000f0000	/* Extended model */
#define	CPUID_MASK_TYPE		0x00003000	/* Type */
#define	CPUID_MASK_FAMILY	0x00000f00	/* Family */
#define	CPUID_MASK_MODEL	0x000000f0	/* Model */
#define	CPUID_MASK_STEPPING	0x0000000f	/* Stepping */

#define	CPUID_SHIFT_XFAMILY	16
#define	CPUID_SHIFT_XMODEL	12
#define	CPUID_SHIFT_MODEL	4
#define	CPUID_SHIFT_FAMILY	8
#define	CPUID_SHIFT_TYPE	12

#define	CPU_FAMILY_EXT		0xf	/* Use extended family field */
#define	CPU_MODEL_EXT		0xf	/* Use extended model field */

#define	CPUID_TYPE_OEM		0		/* Original OEM Processor */
#define	CPUID_TYPE_OVERDRIVE	1		/* OverDrive(tm) Processor */
#define	CPUID_TYPE_DUAL		2		/* Dual processor */

/* Macros to extract the above fields */
#define	CPUID_TYPE(id) (((id) & CPUID_MASK_TYPE) >> CPUID_SHIFT_TYPE)
#define	CPUID_FAMILY(id) ({ \
	int __family = ((id) & CPUID_MASK_FAMILY) >> CPUID_SHIFT_FAMILY; \
 \
	if (__family == CPU_FAMILY_EXT) \
		__family |= ((id) & CPUID_MASK_XFAMILY) >> CPUID_SHIFT_XFAMILY; \
	__family; \
})
#define	CPUID_MODEL(id) ({ \
	int __model = ((id) & CPUID_MASK_MODEL) >> CPUID_SHIFT_MODEL; \
 \
	if (__model == CPU_MODEL_EXT) \
		__model |= ((id) & CPUID_MASK_XMODEL) >> CPUID_SHIFT_XMODEL; \
	__model; \
})
#define	CPUID_STEPPING(id) ((id) & CPUID_MASK_STEPPING)

/*
 * Processor families, used in the global variable "cpu."
 * Values of 4 and higher are the same as the family returned
 * by the cpuid instruction (possibly including extended family value).
 */
#define	CPU_386SX	1
#define	CPU_386		2
#define	CPU_486SX	3
#define	CPU_486		4
#define	CPU_586		5	/* Pentium (tm) */
#define	CPU_686		6	/* Pentium Pro, Pentium II, Pentium III (tm) */
#define	CPU_P4		0x0f	/* Pentium 4 */

/* Feature Flags values */
#define	CPUID_FEAT_FPU		0x00000001	/* FPU Present */
#define	CPUID_FEAT_VME		0x00000002	/* Virtual Mode Extension */
#define	CPUID_FEAT_DE		0x00000004	/* Debugging extension */
#define	CPUID_FEAT_PSE		0x00000008	/* Page size extension */
#define	CPUID_FEAT_TSC		0x00000010	/* Time Stampe Counter */
#define	CPUID_FEAT_MSR		0x00000020	/* Model Specific Registers */
#define	CPUID_FEAT_PAE		0x00000040	/* Physical Address Extension */
#define	CPUID_FEAT_MCE		0x00000080	/* Machine Check Exception */
#define	CPUID_FEAT_CX8		0x00000100	/* CMPXCHG8 instruction supported */
#define	CPUID_FEAT_APIC		0x00000200	/* On-chip APIC Hardware supported */
#define	CPUID_FEAT_SEP		0x00000800	/* Fast System Call */
#define	CPUID_FEAT_MTRR		0x00001000	/* Memory Type Range Registers */
#define	CPUID_FEAT_PGE		0x00002000	/* Page Global Enable */
#define	CPUID_FEAT_MCA		0x00004000	/* Machine Check Architecture */
#define	CPUID_FEAT_CMOV		0x00008000	/* Conditional Move Instruction supported */
#define	CPUID_FEAT_PAT		0x00010000	/* Page Attribute Table */
#define	CPUID_FEAT_PSE36	0x00020000	/* 36-bit Page Size Extension */
#define	CPUID_FEAT_PSN		0x00040000	/* Proc Serial Number present & enabled */
#define	CPUID_FEAT_CLFLUSH	0x00080000	/* Cache Flush instructin supported */
#define	CPUID_FEAT_DTS		0x00200000	/* Debug Trace Store */
#define	CPUID_FEAT_ACPI		0x00400000	/* ACPI supported */
#define	CPUID_FEAT_MMX		0x00800000	/* MMX supported */
#define	CPUID_FEAT_FXSR		0x01000000	/* Fast floating point save and restore */
#define	CPUID_FEAT_SSE		0x02000000	/* Streaming SIMD Extensions */
#define	CPUID_FEAT_SSE2		0x04000000	/* Streaming SIMD Extensions 2 */
#define	CPUID_FEAT_SS		0x08000000	/* Self-Snoop */
#define	CPUID_FEAT_TM		0x02000000	/* Thermal Monitor supported */

#define	CPUID_BRAND_MAX		0x80000000	/* Max Brand supported */
#define	CPUID_BRAND_BITS	0x80000001	/* Extended Process Sig & Feature Bits */
#define	CPUID_BRAND_STR1	0x80000002	/* Brand String 1 */
#define	CPUID_BRAND_STR2	0x80000003	/* Brand String 2 */
#define	CPUID_BRAND_STR3	0x80000004	/* Brand String 3 */

#define	CPUID_MASK_BRAND	0x000000ff	/* In EBX from cpuid 1 */

#ifdef	BRAND_TABLE
/*
 * Include the Intel brand table here so it is not duplicated in the
 * kernel and the cpu command.
 */
struct brand_table {
	int	br_id;
	char 	*br_name;
};

static struct brand_table intel_brands[] = {
	{ 1,	"Celeron" },
	{ 2,	"Pentium III" },
	{ 3,	"Pentium III Xeon" },
	{ 8,	"Pentium 4" },
	{ 0,	NULL }
};
#endif

#ifndef LOCORE
#ifdef	KERNEL
extern int cpu;
extern int cpu_brand;
extern int cpu_feature_flags;
extern int cpu_id;
extern char cpu_vendor[];
#endif

/*
 * CTL_MACHDEP definitions.
 */
#define	CPU_CONSDEV		1	/* dev_t: console terminal device */
#define	CPU_BIOS		2	/* node: PC/AT BIOS information */
#define	CPU_CNTLALTDEL		3	/* int: recognize cntl-alt-del */
#define	CPU_CNTLALTDELCORE	4	/* int: recognize cntl-alt-del */
#define	CPU_PARITYERRORPANIC	5	/* int: panic on parity err */
#define	CPU_IPROF		6	/* node: intel Profiling */
#define	CPU_MAXID		7	/* number of valid machdep ids */

#define CTL_MACHDEP_NAMES { \
	{ 0, 0 }, \
	{ "console_device", CTLTYPE_STRUCT }, \
	{ "bios", CTLTYPE_NODE }, \
	{ "cntlaltdel", CTLTYPE_INT }, \
	{ "cntlaltdelcore", CTLTYPE_INT }, \
	{ "parityerrorpanic", CTLTYPE_INT }, \
	{ "iprof", CTLTYPE_NODE }, \
}

/*
 * CPU_BIOS definitions.
 */
#define	BIOS_DISKGEOM		1	/* biosgeom[4]: CMOS/BIOS disk geom */
#ifdef notyet
#define	BIOS_INFO		2	/* biosinfo: various BIOS info */
#endif
#define	BIOS_MAXID		2	/* number of valid BIOS ids */

#define CTL_BIOS_NAMES { \
	{ 0, 0 }, \
	{ "diskgeom", CTLTYPE_STRUCT }, \
}
#endif

#endif /* !_MACHINE_CPU_H_ */
