/*	BSDI elf.h,v 1.3.16.1 2001/03/20 15:58:14 donn Exp	*/

/* Set the ELF architecture to i386.  */
#define	EM_ARCH			EM_386

/* Set the endian-ness.  */
#define	ELFENDIAN		ELFDATA2LSB

/* The i386 ABI rev. 4.1 specifies a few i386 auxiliary entries.  */
#define	AT_LIBPATH		10	/* zero if secure path needed */
#define	AT_FPHW			11
#define		FPHW_NONE		0
#define		FPHW_EMUL		1
#define		FPHW_287		2	/* ! */
#define		FPHW_387		3
#define	AT_INTP_DEVICE		12	/* dynamic linker's device number */
#define	AT_INTP_INODE		13	/* dynamic linker's inode number */

/* Linux (in)compatibility.  */
#define	AT_PSSTRINGS		10
#define	AT_NOTELF		AT_PSSTRINGS
#define	AT_UID			11
#define	AT_EUID			12
#define	AT_GID			13
#define	AT_EGID			14

/* Overall value.  */
#define	MAX_AUX			15

/* From Fig. 3-24 of the i386 ABI Processor Supplement.  */
#define	ELF_DYNAMIC_BASE	0x80000000

/* From Fig. 3-25; this is a conventional address.  */
#define	ELF_TEXT_BASE		0x08048000

/* Relocation types, from Figure 4-4.  */
#define	R_386_NONE		0  /* none */
#define	R_386_32		1  /* symbol + addend */
#define	R_386_PC32		2  /* symbol + addend - EIP */
#define	R_386_GOT32		3  /* GOT + addend - EIP (special) */
#define	R_386_PLT32		4  /* PLT + addend - EIP */
#define	R_386_COPY		5  /* special copy relocation */
#define	R_386_GLOB_DAT		6  /* symbol for data in GOT */
#define	R_386_JMP_SLOT		7  /* symbol for stub in PLT */
#define	R_386_RELATIVE		8  /* relocate relative to shared lib base */
#define	R_386_GOTOFF		9  /* symbol + addend - GOT */
#define	R_386_GOTPC		10 /* GOT + addend - address */

#ifdef KERNEL

/*
 * The Linux pthreads implementation assumes that
 * program stacks reside above the heap (sigh).
 */
#define	X_LINUX			X_MACHDEP2
#define	ELF_STACK_BELOW_TEXT(xp) \
	((xp)->x_taddr >= (caddr_t)VM_MIN_ADDRESS + INITSSIZ && \
	    ((xp)->x_flags & X_LINUX) == 0)

#endif
