/*-
 * Copyright (c) 1996, 1998 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI intel_mps.h,v 2.2 1998/06/03 18:41:59 karels Exp
 */

/* 
 *  Intel MP Configuration tables
 *  from the 1.4 version of this document
 */

#ifndef _INTEL_MPS_H_
#define _INTEL_MPS_H_

#ifndef LOCORE

extern void mps_scan_fps __P((char *, int));
extern void mps_print_cfg __P((void));

/* Floating Pointer Structure */

struct fps {
	union {
		int32_t	fps_ui_sign;	/* signature */
		char	fps_uc_sign[4];	/* signature */
	} u;
#define fps_c_sign u.fps_uc_sign
#define fps_i_sign u.fps_ui_sign
	struct	mct *fps_cfg;		/* ptr to cfg-table */
	u_int8_t fps_len;		/* length of structure */
	u_int8_t fps_rev;		/* revision */
	u_int8_t fps_chks;		/* checksum */
	u_int8_t fps_cfgtype;		/* 1st feature byte */
	u_int8_t fps_feature[4];	/* feature bytes 2 .. 5 */
};

#define FPS_CHAR_SIGN "_MP_"

#define FPS_HAS_CFG_TABLE	0

#define FPS_IMCRP		0x80

struct mct {
	union {
		int32_t	mct_ui_sign;	/* signature */
		char	mct_uc_sign[4];	/* signature */
	} u;
#define mct_c_sign u.mct_uc_sign
#define mct_i_sign u.mct_ui_sign
	u_int16_t	 mct_base_len;		/* base table length */
	u_int8_t	 mct_rev;		/* revision */
	u_int8_t	 mct_chks;		/* checksum */
	char		 mct_oem_id[8];		/* OEM ID */
	char		 mct_prod_id[12];	/* Product ID */
	void		*mct_oem_table;		/* OEM table */
	u_int16_t	 mct_oem_table_size;	/* OEM table size */
	u_int16_t	 mct_entry_cnt;		/* entry count */
	caddr_t		 mct_local_apic;	/* local apic ptr */
	u_int16_t	 mct_ext_tab_len;	/* extended table length */
	u_int8_t	 mct_ext_tab_chks;	/* extended table checksum */
	u_int8_t	 mct_rsvr1;		/* reserved */
};
#define MCT_CHAR_SIGN "PCMP"

struct mp_cfg_entry {
	int8_t	mce_entry_type;
	int8_t	mce_id;
};
#define MCE_PROC	0	/* Processor */
#define MCE_BUS		1	/* Bus       */
#define MCE_IO_APIC	2	/* IO APIC   */
#define MCE_IO_INTR	3	/* IO interrupt assignment */
#define MCE_LC_INTR	4	/* Local interrupt assignment */
struct mce_proc {
	u_int8_t	mce_entry_type;
	u_int8_t	mce_proc_local_apic_id;
	u_int8_t	mce_proc_local_apic_vers;
	u_int8_t	mce_proc_cpu_flags;
	u_int32_t	mce_proc_cpu_signature;
	u_int32_t	mce_proc_cpu_feature;
	u_int32_t	mce_proc_reserved0;
	u_int32_t	mce_proc_reserved1;
};
#define MCE_PROC_FL_EN	0x1	/* processor enabled */
#define MCE_PROC_FL_BP	0x2	/* bootstrap processor */
#define MCE_PROC_LEN	20

struct mce_bus {
	u_int8_t	mce_entry_type;
	u_int8_t	mce_bus_id;
	char		mce_bus_type[6];
};
#define MCE_BUS_LEN	8
struct mce_io_apic {
	u_int8_t	 mce_entry_type;
	u_int8_t	 mce_io_apic_id;
	u_int8_t	 mce_io_apic_vers;
	u_int8_t	 mce_io_apic_flags;
	void		*mce_io_apic_addr;
};
#define MCE_IO_APIC_FL_EN	0x1	/* IO Apic enabled */
#define MCE_IO_APIC_LEN	8

struct mce_io_intr {
	u_int8_t	mce_entry_type;
	u_int8_t	mce_io_intr_type;
	u_int16_t	mce_io_intr_flags;
	u_int8_t	mce_io_intr_src_bus_id;
	u_int8_t	mce_io_intr_src_bus_irq;
	u_int8_t	mce_io_intr_dst_apic_id;
	u_int8_t	mce_io_intr_dst_apic_int;
};
#define MCE_IO_INTR_LEN	8

struct mce_lc_intr {
	u_int8_t	mce_entry_type;
	u_int8_t	mce_lc_intr_type;
	u_int16_t	mce_lc_intr_flags;
	u_int8_t	mce_lc_intr_src_bus_id;
	u_int8_t	mce_lc_intr_src_bus_irq;
	u_int8_t	mce_lc_intr_dst_apic_id;
	u_int8_t	mce_lc_intr_dst_apic_int;
};
#define MCE_LC_INTR_LEN	8

#define MCE_INTR_FL_PO		0x3
#define	MCE_PO_CONFORM		0x0
#define	MCE_PO_HIGH		0x1
#define	MCE_PO_LOW		0x3

#define MCE_INTR_FL_EL	    	0xc
#define	MCE_FL_CONFORM		0x0
#define	MCE_FL_EDGE		0x4
#define	MCE_FL_LEVEL		0xc

#define MCE_INTR_DST_APIC_ALL    0xff

#define MCE_INTR_TYPE_INT	0x0
#define MCE_INTR_TYPE_NMI	0x1
#define MCE_INTR_TYPE_SMI	0x2
#define MCE_INTR_TYPE_EXTINT	0x3
#endif	/* !LOCORE */

/* need these in locore */
#define MCT_INT_SIGN  0x504d4350	/* "PCMP" */
#define FPS_INT_SIGN  0x5f504d5f	/* "_MP_" */

#ifndef MAX_BUSSES
#define MAX_BUSSES 4
#endif
#ifndef MAX_IO_INT
#define MAX_IO_INT (16*MAX_BUSSES)
#endif

struct ece_map {
	u_int8_t	ece_entry_type;
	u_int8_t	ece_entry_len;
	u_int8_t	ece_bus_id;
	u_int8_t	ece_addr_type;
	u_int64_t	ece_addr_base;
	u_int64_t	ece_addr_len;
};
#define	ECE_MAP		128

struct ece_bus {
	u_int8_t	ece_entry_type;
	u_int8_t	ece_entry_len;
	u_int8_t	ece_bus_id;
	u_int8_t	ece_flags;
	u_int8_t	ece_parent;
};
#define	ECE_BUS		129

#define	ECE_SUBDEC	0x01		/* Bus is subtractive decode */

struct ece_compat {
	u_int8_t	ece_entry_type;
	u_int8_t	ece_entry_len;
	u_int8_t	ece_bus_id;
	u_int8_t	ece_flags;
	u_int32_t	ece_pdl;
};
#define	ECE_COMPAT	130

#define	ECE_PR		0x01		/* Subtract predefined addr ranges */

#endif /* !_INTEL_MPS_H_ */
