/*-
 * Copyright (c) 1997 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI ktr.h,v 2.6 2000/04/28 03:00:47 donn Exp
 */

#ifndef __I386_KTR_H
#define __I386_KTR_H

#include <machine/pcpu.h>

#ifndef KTR_OLDCPU
#ifdef LOCORE
/*
 * Assembly version of ktr trace macro (unconditional)
 *
 * After calling this write any aux info to:
 *	KTR_PARMx(%ebx), where x = 1-5.
 *
 * The 'seg' version is for use in interrupt handlers when %ds hasn't been
 * set up yet (the h/w sets up %ss points to kernel data space).
 *
 * Trashes eax, ebx, and edx.
 *
 * Notes:
 *	We could use a single trace buffer for all cpu's now that we're
 *	using 'xaddl' (it would have to be locked however, which slows
 *	things down a bit).
 *
 *	The rdtsc is after the xaddl to shave an extra clock off over putting
 *	it before the xaddl.
 */
#define	SEG_ATR(dscr,seg)						\
	movl	$KTR_ESIZE,%ebx;	/* How much to incr */		\
	xaddl	%ebx,%fs:PCPU_KTR_IDX;	/* get a slot */		\
	rdtsc;				/* time -> eax/edx */		\
	andl	seg ktr_size_mask,%ebx;	/* wrap buffer */		\
	addl	%fs:PCPU_KTR_BUF,%ebx;	/* Point to actual spot in buffer */ \
	movl	%eax,seg KTR_CLKV(%ebx);/* Time low */			\
	movl	%edx,seg KTR_CLKV+4(%ebx); /* Time high */		\
	.section ".rodata";						\
7:	.string	dscr;							\
	.section ".text";						\
	movl	$7b,seg KTR_DESC(%ebx); /* save */

/* Same as above, but desc string is provided by caller */
#define	SEG_ATR_DESC(dscr,seg)						\
	movl	$KTR_ESIZE,%ebx;	/* How much to incr */		\
	xaddl	%ebx,%fs:PCPU_KTR_IDX;	/* get a slot */		\
	rdtsc;				/* time -> eax/edx */		\
	andl	seg ktr_size_mask,%ebx;	/* wrap buffer */		\
	addl	%fs:PCPU_KTR_BUF,%ebx;	/* Point to actual spot in buffer */ \
	movl	%eax,seg KTR_CLKV(%ebx);/* Time low */			\
	movl	%edx,seg KTR_CLKV+4(%ebx); /* Time high */		\
	movl	dscr,%eax;		/* string pointer */		\
	movl	%eax,seg KTR_DESC(%ebx); /* save */
#else
#define	_TR(_desc) 						\
	volatile struct ktr_entry *_ktrptr;			\
	asm volatile(						\
		"movl	%3,%%ebx;"				\
		"xaddl	%%ebx,%%fs:%1;"				\
		"rdtsc;"					\
		"andl	ktr_size_mask,%%ebx;"			\
		"addl	%%fs:%2,%%ebx;"				\
		"movl	%%eax,0(%%ebx);"			\
		"movl	%%edx,4(%%ebx);"			\
		: "=b" (_ktrptr)				\
		: "m" (*(u_long *)(__pcpu_offsetof(pc_ktr_idx))), \
		  "m" (*(u_long *)(__pcpu_offsetof(pc_ktr_buf))), \
		  "i" (sizeof (struct ktr_entry))		\
		: "eax", "edx");				\
	_ktrptr->ktr_desc = (_desc);
#endif	/* LOCORE */
#else	/* KTR_OLDCPU */
/*
 * This is for pre-Pentium CPU's that do not have the xaddl or rdtsc instrs
 *
 * Note that w/o the atomic add this can be interrupted (which may lead to
 * a less than perfect trace in some situations).
 */
#ifdef LOCORE
#define	SEG_ATR(dscr,seg)						\
	movl	$KTR_ESIZE,%eax;	/* How much to incr */		\
	movl	%fs:PCPU_KTR_IDX,%ebx;	/* Current posn */		\
	addl	%ebx,%eax;		/* Next entry */		\
	movl	%eax,%fs:PCPU_KTR_IDX;	/* Save */			\
	andl	seg ktr_size_mask,%ebx;	/* wrap buffer */		\
	addl	%fs:PCPU_KTR_BUF,%ebx;	/* Point to actual spot in buffer */ \
	movl	time,%edx;						\
	movl	time+4,%eax;						\
	movl	%eax,seg KTR_CLKV(%ebx);/* Time low */			\
	movl	%edx,seg KTR_CLKV+4(%ebx); /* Time high */		\
	.section ".rodata";						\
7:	.string	dscr;							\
	.section ".text";						\
	movl	$7b,seg KTR_DESC(%ebx); /* save */

/* Same as above, but desc string is provided by caller */
#define	SEG_ATR_DESC(dscr,seg)						\
	movl	$KTR_ESIZE,%eax;	/* How much to incr */		\
	movl	%fs:PCPU_KTR_IDX,%ebx;	/* Current posn */		\
	addl	%ebx,%eax;		/* get next entry */		\
	movl	%eax,%fs:PCPU_KTR_IDX;	/* save */			\
	andl	seg ktr_size_mask,%ebx;	/* wrap buffer */		\
	addl	%fs:PCPU_KTR_BUF,%ebx;	/* Point to actual spot in buffer */ \
	movl	time,%edx;						\
	movl	time+4,%eax;						\
	movl	%eax,seg KTR_CLKV(%ebx);/* Time low */			\
	movl	%edx,seg KTR_CLKV+4(%ebx); /* Time high */		\
	movl	dscr,%eax;		/* string pointer */		\
	movl	%eax,seg KTR_DESC(%ebx); /* save */

#else
#define	_TR(_desc) 						\
	volatile struct ktr_entry *_ktrptr;			\
	asm volatile(						\
		"movl	%3,%%eax;"				\
		"movl	%%fs:%1,%%ebx;"				\
		"addl	%%ebx,%%eax;"				\
		"movl	%%eax,%%fs:%1;"				\
		"andl	ktr_size_mask,%%ebx;"			\
		"addl	%%fs:%2,%%ebx;"				\
		"movl	time,%%edx;"				\
		"movl	time+4,%%eax;"				\
		"movl	%%eax,0(%%ebx);"			\
		"movl	%%edx,4(%%ebx);"			\
		: "=b" (_ktrptr)				\
		: "m" (*(u_long *)(__pcpu_offsetof(pc_ktr_idx))), \
		  "m" (*(u_long *)(__pcpu_offsetof(pc_ktr_buf))), \
		  "i" (sizeof (struct ktr_entry))		\
		: "eax", "edx");				\
	_ktrptr->ktr_desc = (_desc);
#endif	/* LOCORE */
#endif	/* KTR_OLDCPU */

#ifdef LOCORE

#define	ATR(dscr)	SEG_ATR(dscr,)

#define	CATR(f,d,no)							\
	testl	$f,ktr_mask;						\
	jz	no;							\
	SEG_ATR(d,);

#define	CATRD(f,d,no)							\
	testl	$f,ktr_mask;						\
	jz	no;							\
	SEG_ATR_DESC(d,);

#endif	/* LOCORE */
#endif /* _I386_KTR_H */
