/*-
 * Copyright (c) 2001 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI pthread_var.h,v 1.1.2.1 2001/04/10 04:23:02 donn Exp
 */

/*
 * Machine-dependent definitions for our pthread implementation.
 * Currently this file contains only user-mode information.
 */

#ifndef _MACHINE_PTHREAD_VAR_H_
#define _MACHINE_PTHREAD_VAR_H_

#define	_THREAD_I386_PC		0
#define _THREAD_I386_EBX	1
#define	_THREAD_I386_ESP	2
#define	_THREAD_I386_EBP	3
#define	_THREAD_I386_ESI	4
#define	_THREAD_I386_EDI	5
#define	_THREAD_I386_NREGS	6

#define	_THREAD_I387_NBSZ	108

struct _thread_i386_state {
	unsigned int	regs[_THREAD_I386_NREGS];
	unsigned char	saved_fp[_THREAD_I387_NBSZ];
};

typedef struct _thread_i386_state thread_machdep_state;

#endif	/* _MACHINE_PTHREAD_VAR_H_ */
