/*	BSDI types.std32.h,v 2.4 1999/04/12 17:23:01 donn Exp	*/

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)types.h	8.3 (Berkeley) 1/5/94
 */

#ifndef	_TYPES_STD32_H_
#define	_TYPES_STD32_H_

typedef	unsigned long	vm_offset_t;
typedef	unsigned long	vm_size_t;

/*
 * Basic integral types of exactly the implied number of bits.  Omit the
 * typedef if not possible for a machine/compiler combination.
 */
typedef	__signed char		   int8_t;
typedef	unsigned char		 u_int8_t;
typedef	short			  int16_t;
typedef	unsigned short		u_int16_t;
typedef	int			  int32_t;
typedef	unsigned int		u_int32_t;

/*
 * Basic integral types of at least the implied number of bits.  Omit the
 * typedef if not possible for a machine/compiler combination.
 */
typedef	__signed char		   int8m_t;
typedef	unsigned char		 u_int8m_t;
typedef	short			  int16m_t;
typedef	unsigned short		u_int16m_t;
typedef	int			  int32m_t;
typedef	unsigned int		u_int32m_t;

/*
 * Deal with 64-bit types, which are not defined by ANSI C.
 */
#if __GNUC__ >= 2
/* This ugly hack prevents warnings from -pedantic. */
typedef	long			  int64_t __attribute__ ((__mode__(__DI__)));
typedef	unsigned long		u_int64_t __attribute__ ((__mode__(__DI__)));
typedef	long			  int64m_t __attribute__ ((__mode__(__DI__)));
typedef	unsigned long		u_int64m_t __attribute__ ((__mode__(__DI__)));
#else
/* The following are probably correct for most other compilers */
typedef	long long		  int64_t;
typedef	unsigned long long	u_int64_t;
typedef	long long		  int64m_t;
typedef	unsigned long long	u_int64m_t;
#endif

/* The longest/most efficient integer register type. */
typedef	int32_t	register_t;

#endif	/* !_TYPES_STD32_H_ */
