/*-
 * Copyright (c) 1995, 1999 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI aicreg.h,v 2.4 1999/12/11 00:43:57 cp Exp
 */


#define AIC_S_OR	0
#define AIC_S_AND	1
#define AIC_S_XOR	2
#define AIC_S_TST	13	/* and jnz add 2 to get jz  */
#define AIC_S_CMP	12	/* xor jnz add 2 to get jz  */
#define AIC_S_MV	6
#define AIC_S_JMP	8
#define AIC_S_JC	9
#define AIC_S_JNC	10
#define AIC_S_CALL	11
#define AIC_S_ADD	03
#define AIC_S_ADDC	04

#define AIC_S_JNZ	0	/* used as offset to AIC_S_{TST,CMP} */
#define AIC_S_JZ	2	/* used as offset to AIC_S_{TST,CMP} */

#define AIC_S_ROL	05

typedef struct aic_sg {		
	vm_offset_t	sg_addr;
	u_int		sg_count :24;
	u_int		sg_flags  :8;
} aic_sg_t;

typedef struct aic_edata {
	union {
	    struct {
		u_short		_ed_target[16]; /* per target info */
		u_short		_ed_bios;
		u_short		_ed_hac;	/* host adapter control 0 */
		u_short		_ed_hatid;	/* host adapter control 1 */
		u_short		_ed_targets;	/* how many targets */
		u_short		_ed_filler[11];
		u_short		_ed_checksum;
	    } s;
	    u_short _ed_shorts[1];
	}u;
} aic_edata_t;

#define ed_target	u.s._ed_target
#define ed_bios		u.s._ed_bios
#define ed_hac		u.s._ed_hac
#define ed_hatid	u.s._ed_hatid
#define ed_targets	u.s._ed_targets
#define ed_checksum	u.s._ed_checksum
#define ed_shorts	u._ed_shorts

#define CF_AUTOTERM	0x0001		/* auto magic termination */
#define CF_ULTRAEN	0x0002		/* Utras SCSI */
#define CF_284XSELTO	0x0003		/* 284x Selection timeout */
#define CF_284XFIFO	0x000C		/* 284x FIFO threshold */
#define CF_LOW_TERM	0x0004		/* Low byte termination enable */
#define CF_HI_TERM	0x0008		/* High byte termination enable */
#define CF_PARITY	0x0010		/* Parity check bus */
#define CF_284XTERM	0x0020		/* 284x low byte termination enable */
#define CF_RESET	0x0040		/* Reset SCSI bus at boot */
#define CF_BFIRST	0x0100		/* Probe B channel first */
#define CF_SEAUTOTERM	0x0400		/* 7890 SE auto magic termination */
#define CF_LVD_TERM	0x0800		/* Terminator for LVD on */

#define CF_TARGETS_M	0x00ff
