/*	BSDI cyreg.h,v 2.6 1999/04/11 22:08:07 geertj Exp	*/


/*--------------------------------------------------------------*/
/* Cyclom-Y Device Driver for BSDI BSD/OS 3.x and 4.x.		*/
/*								*/
/* Copyright (C) 1995 Cyclades Corporation. All rights reserved.*/
/*--------------------------------------------------------------*/

/*
 * Definitions for the Cyclades Cyclom-Y boards.
 */

/*
 * Address mapping between Cirrus Logic CD1400 chip internal registers
 * and ISA port addresses:
 *
 */

#define CY_ADDR(reg)	(reg)

/* Input Byte from CL CD1400 register */
#define rinb(base, reg)		(*((base)+CY_ADDR(reg)))

/* Output Byte to CL CD1400 register */
#define routb(base, reg, val)	(*((base)+CY_ADDR(reg))=val)

#define CY_NPORT	16	/* decoder recognizes 16 addresses... */

#define CD1400_MEMSIZE 		0x400
#define cy_RESET_16             0x1400                  /* cyclom-16y reset */
#define cy_CLEAR_INTR           0x1800                  /* intr ack address */
#define CYCLOM_CLOCK_25		25000000                /* baud rate clock */
#define CYCLOM_CLOCK_60		60000000                /* baud rate clock */
#define CD1400_CLOCK_25_1MS     0x31
#define CD1400_CLOCK_60_1MS     0x75
#define CD1400_NO_OF_CHANNELS   4
#define CD1400_MAX_FIFO_SIZE    12
#define MAX_CD1400_PER_BOARD	8

/* Bus Index */
#define	CY_ISA			0
#define	CY_PCI			1

/* PCI constants */
#define	CY_VENDOR_ID		0x120e
#define CYY_BELOW_1M		0x100
#define CYY_ABOVE_1M		0x101
#define CYY_DEVICE_ID_MASK	0x06
#define	YEP_WINDOW_SIZE		0x4000	/* 16 KB */
#define	PLX_ADDR_0		0x10	/* Memory mapped runtime reg. addr. */
#define	PLX_ADDR_1		0x14	/* I/O mapped runtime reg. addr. */
#define	PLX_ADDR_2		0x18	/* Memory Addr. */
#define	PLX_9050_INTR_CTRL	0x4c	/* PLX Interrupt Control Addr. */
#define	PLX_9060_INTR_CTRL	0x68	/* PLX Interrupt Control Addr. */

/* Board Custom Registers */

#define	PLX_VER			(0x3400)
#define	PLX_9050		0x0b
#define	PLX_9060		0x0c
#define	PLX_9080		0x0d
