/*	BSDI decether.h,v 2.4 1998/06/03 19:14:56 karels Exp	*/

/*-
 * Copyright (c) 1994, 1995 Matt Thomas (matt@lkg.dec.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software withough specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	BSDI decether.h,v 2.4 1998/06/03 19:14:56 karels Exp
 *
 * Id: decether.h,v 1.4 1995/07/13 15:14:59 thomas Exp
 *
 * Log: decether.h,v
 * Revision 1.4  1995/07/13  15:14:59  thomas
 * mcbits is int now
 *
 * Revision 1.3  1995/05/24  22:06:07  thomas
 * mcmask is now the number of bits
 *
 * Revision 1.2  1995/04/24  19:03:43  thomas
 * Fix EISA DE422 support.  Correct Copyright message.
 * Remove unused fields.
 *
 * Revision 1.1  1995/04/23  22:07:13  thomas
 * Initial revision
 */

#ifndef _ISA_DECETHER_H
#define _ISA_DECETHER_H

#define	DECETHER_CRC32_POLY  0xEDB88320UL /* CRC-32 Poly -- Little Endian */

#define	DECETHER_ADDREQUAL(a1, a2) \
	(((u_short *)a1)[0] == ((u_short *)a2)[0] \
	 && ((u_short *)a1)[1] == ((u_short *)a2)[1] \
	 && ((u_short *)a1)[2] == ((u_short *)a2)[2])
#define	DECETHER_ADDRBRDCST(a1) \
	(((u_short *)a1)[0] == 0xFFFFU \
	 && ((u_short *)a1)[1] == 0xFFFFU \
	 && ((u_short *)a1)[2] == 0xFFFFU)

extern void decether_input(struct arpcom *ac, caddr_t seg1, size_t total_len,
			   size_t len1, caddr_t seg2);

extern int decether_ifioctl(struct ifnet *ifp, u_long cmd, caddr_t data);

extern int decether_read_macaddr(unsigned char *hwaddr, int ioreg, int skippat);

extern int decether_multicast_filter(struct arpcom *ac,
				     const int mcbits,
				     unsigned short *mctbl);

#endif /* _ISA_DECETHER_H */
