/*-
 * Copyright (c) 1993, 1994, 1998 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI digiioctl.h,v 2.6 1998/06/03 19:14:56 karels Exp
 *
 * from Id: digiioctl.h,v 1.2 1993/11/16 00:03:23 nerd Exp nerd
 */

/*
 * board types
 */
typedef int digi_type_t;
#define PCXE		0x0001
#define PCXI		0x0002
#define PCXM		0x0004
#define PCXE8K		0x0008
#define PCXEM		0x0010
#define PCXR		0x0020
#define PC_UNKNOWN	0x0040
#define PCIXEM		0x0080
#define PCIXR		0x0100
#define PCIXR_PLX	0x0200

#define DIGI_ISAMIPS	(PCXEM | PCXR)			/* Mips on ISA/EISA */
#define DIGI_PCIMIPS	(PCIXEM | PCIXR | PCIXR_PLX)	/* Mips on PCI */
#define DIGI_MIPS	(DIGI_ISAMIPS | DIGI_PCIMIPS)

/*
 * All ioctls here are specific to the DigiBoard and can only be called by
 * root (they check)
 */
#define DIOCGNLINES	_IOR('D', 0, int)	/* get # of ports */
#define DIOCGALTPIN	_IOR('D', 6, int)	/* swap dcd & dsr */
#define DIOCSALTPIN	_IOW('D', 7, int)	/* swap dcd & dsr */
#define DIOCGOQSIZE	_IOR('D', 10, int)	/* get output queue length */
#define DIOCSOQSIZE	_IOW('D', 11, int)	/* set output queue length */
