/*	BSDI dpt_eata.h,v 2.4 1999/01/15 19:08:15 geertj Exp	*/

/*
 * Copyright (c) 1996-1999 Distributed Processing Technology Corporation
 * All rights reserved.
 *
 * Redistribution and use in source form, with or without modification, are
 * permitted provided that redistributions of source code must retain the
 * above copyright notice, this list of conditions and the following disclaimer.
 *
 * This software is provided `as is' by Distributed Processing Technology and
 * any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose,
 * are disclaimed. In no event shall Distributed Processing Technology be
 * liable for any direct, indirect, incidental, special, exemplary or
 * consequential damages (including, but not limited to, procurement of
 * substitute goods or services; loss of use, data, or profits; or business
 * interruptions) however caused and on any theory of liability, whether in
 * contract, strict liability, or tort (including negligence or otherwise)
 * arising in any way out of the use of this driver software, even if advised
 * of the possibility of such damage.
 */

#if (!defined(__DPT_EATA_H))
# define      __DPT_EATA_H

/*
 *      File -  DPT_EATA.H
 *
 *      Description:  This file contains basic EATA interface structures.
 *
 *      Copyright Distributed Processing Technology, Corp.
 *        140 Candace Dr.
 *        Maitland, Fl. 32751   USA
 *        Phone: (407) 830-5522  Fax: (407) 260-5366
 *        All Rights Reserved
 *
 *      Author: Mark Salyzyn
 *      Date:   Aug 29 1996
 */

/*
 *      Eata Register set definitions. We may need to undef them to remove
 * errors since these same symbols are repeated in the various drivers.
 */

#define HA_DATA         0x00
#define HA_ERROR        0x01
#define HA_DMA_BASE     0x02
#define HA_COMMAND      0x07
# define        CP_READ_CFG_PIO 0xF0    /* Read Configuration Data, PIO */
# define        CP_EATA_RESET   0xF9    /* Reset SCSI Bus               */
# define        CP_IMMEDIATE    0xFA    /* EATA Immediate command       */
# define        CP_DMA_CMD      0xFF    /* Send an EATA DMA command     */
#define HA_STATUS       0x07
# define        HA_ST_ERROR             0x01
# define        HA_ST_INDEX             0x02
# define        HA_ST_CORRCTD           0x04
# define        HA_ST_DRQ               0x08
# define        HA_ST_SEEK_COMPLETE     0x10
# define        HA_ST_WRT_FLT           0x20
# define        HA_ST_READY             0x40
# define        HA_ST_BUSY              0x80
# define        HA_ST_DATA_RDY (HA_ST_SEEK_COMPLETE | HA_ST_READY | HA_ST_DRQ)
#define HA_AUX_STATUS   0x08
# define        HA_AUX_BUSY     0x01
# define        HA_AUX_INTR     0x02

/*
 *      EATA Read Config. Data Structure...................
 */

/* Signature */
#define RDCFG_EATA_SIG (((long)'E')|(((long)'A')<<8L)|(((long)'T')<<16L)|(((long)'A')<<24L))
/* flag1 */
#define RDCFG_OVERLAP   0x01 /* Controller supports overlapped cmds     */
#define RDCFG_TGT_MODE  0x02 /* Controller supports SCSI target mode    */
#define RDCFG_DMA       0x10 /* Controller supports DMA                 */
#define RDCFG_DRQ_VALID 0x20 /* The DRQX value is valid                 */
#define RDCFG_ATA       0x40 /* ATA device (Head/Drive Register Req'd)  */
#define RDCFG_HBA_ADDR  0x80 /* Host Adapter Address Valid              */

/* flag2 */
#define RDCFG_IRQ_NUM   0x0f /* Controller interrupt request #          */
#define RDCFG_IRQ_TRIG  0x10 /* IRQ trigger (0=edge, 1=level)           */
#define RDCFG_PRIORITY  0x20 /* 0=Primary, 1=Secondary                  */
        /*
         * DRQ Index:   0 = DRQ #0
         *              1 = DRQ #7
         *              2 = DRQ #6
         *              3 = DRQ #5
         */
#define RDCFG_DRQ_NUM   0xc0

/* flag3 */
#define   RDCFG_NO_ISA     0x01 /* (1=A secondary EISA controller does  */
                                /* not also respond to ISA address)     */
#define   RDCFG_FORCE_ADDR 0x02 /* 1 = A PCI HBA is configured to       */
                                /* decode a fixed EISA address          */
#define   RDCFG_SG_64K     0x04 /* 1 = A 64KByte scatter-gather table   */
                                /* is supported                         */
#define   RDCFG_SG_UAE     0x08 /* 1 = Unaligned scatter-gather table   */
                                /* elements are supported               */

/* flag4 */
#define   RDCFG_EISA_BUS       0x80 /* 1=This is an EISA controller     */
#define   RDCFG_PCI_BUS        0x40 /* 1=This is a PCI controller       */
#define   RDCGF_VOODOO_RAIDNUM 0x20 /* 1=RAIDNUM returned is questionable */
#define   RDCFG_PCI_M1         0x10 /* 1=This ia a PCI board with an M1 */
                                    /* chip installed                   */
#define   RDCFG_AUTOTRM        0x08 /* 1=HBA supports AUTO termination  */
                                    /* on base channel only             */
#define   RDCFG_SCAM           0x04 /* 1=HBA supports SCAM on one or    */
                                    /* more channels                    */

#define eataRdConfig_size       38
typedef unsigned char   eataRdConfig_S[eataRdConfig_size];

/*-----------------
 * Access Functions
 *-----------------*/

#define eataRdConfig_getDevType(x)      getU1(x,0)
#define eataRdConfig_getPageCode(x)     getU1(x,1)
#define eataRdConfig_getLength(x)       getU1(x,3)
#define eataRdConfig_getSignature(x)    (*((unsigned long *)getUP1(x,4)))
#define eataRdConfig_getVersion(x)      getU1(x,8)
#define eataRdConfig_getFlag1(x)        getU1(x,9)
#define eataRdConfig_orFlag1(x,y)       orU1(x,9,y)
#define eataRdConfig_andFlag1(x,y)      andU1(x,9,y)
#define eataRdConfig_setFlag1(x,y)      setU1(x,9,y)
#define eataRdConfig_getPadLength(x)    getU2(x,10)
#define eataRdConfig_getScsiIDs(x)      getUP1(x,12)
#define eataRdConfig_getCpLength(x)     getU4(x,16)
#define eataRdConfig_setCpLength(x,y)   setU4(x,16,y)
#define eataRdConfig_getSpLength(x)     getU4(x,20)
#define eataRdConfig_getQueueSize(x)    getU2(x,24)
#define eataRdConfig_setQueueSize(x,y)  setU2(x,24,y)
#define eataRdConfig_getSgSize(x)       getU2(x,28)
#define eataRdConfig_setSgSize(x,y)     setU2(x,28,y)
#define eataRdConfig_getFlag2(x)        getU1(x,30)
#define eataRdConfig_orFlag2(x,y)       orU1(x,30,y)
#define eataRdConfig_andFlag2(x,y)      andU1(x,30,y)
#define eataRdConfig_setFlag2(x,y)      setU1(x,30,y)
#define eataRdConfig_getIRQ(x)          getU1(x,31)
#define eataRdConfig_getFlag3(x)        getU1(x,32)
#define eataRdConfig_orFlag3(x,y)       orU1(x,32,y)
#define eataRdConfig_andFlag3(x,y)      andU1(x,32,y)
#define eataRdConfig_setFlag3(x,y)      setU1(x,32,y)
#define eataRdConfig_getMaxChanID(x)    getU1(x,33)
#define eataRdConfig_orMaxChanID(x,y)   orU1(x,33,y)
#define eataRdConfig_andMaxChanID(x,y)  andU1(x,33,y)
#define eataRdConfig_setMaxChanID(x,y)  setU1(x,33,y)
#define eataRdConfig_getMaxLun(x)       getU1(x,34)
#define eataRdConfig_setMaxLun(x,y)     setU1(x,34,y)
#define eataRdConfig_getFlag4(x)        getU1(x,35)
#define eataRdConfig_orFlag4(x,y)       orU1(x,35,y)
#define eataRdConfig_andFlag4(x,y)      andU1(x,35,y)
#define eataRdConfig_setFlag4(x,y)      setU1(x,35,y)
#define eataRdConfig_getRaidNum(x)      getU1(x,36)
#define eataRdConfig_setRaidNum(x,y)    setU1(x,36,y)
#define eataRdConfig_getReserved2(x)    getU1(x,37)

/*---------------------------
 * Required Support Functions
 *---------------------------*/

#define eataRdConfig_clear(x)   osdBzero(x,eataRdConfig_size)

/*
 *      EATA CP (Command Packet) Structure.............
 */
/*******************************************************************************
** EATA Command Packet Control Bits Structure Definition - This Controls The  **
**      Data Direction, CDB Interpret, And Other Misc Controll Bits.          **
*******************************************************************************/

/* flags */
#define CP_SCSI_RESET   0x01 /* Issue SCSI bus reset                    */
#define CP_INIT         0x02 /* Controller should re-initialize         */
#define CP_REQ_SENSE    0x04 /* DMA only - Target should automatically  */
                             /* transfer request sense data             */
#define CP_SG_ADDR      0x08 /* DMA only - Data address is used for     */
                             /* Scatter Gather                          */
#define CP_QUICK        0x10 /* PIO only - Quick mode (CP uses PIO,     */
                             /* Data uses DMA)                          */
#define CP_INTERPRET    0x20 /* The controller should interpret the cmd */
                             /* directly                                */
#define CP_DATA_OUT     0x40 /* Data Output (Write, Host to Target)     */
#define CP_DATA_IN      0x80 /* Data Input (Read, Target to Host)       */

/* message bits */
#define CP_DISCONNECT   0x80
#define CP_IDENTIFY     0x40

#define eataCP_size             44
typedef unsigned char   eataCP_S[eataCP_size];

/*-----------------
 * Access Functions
 *-----------------*/

#define eataCP_getFlags(x)              getU1(x,0)
#define eataCP_setFlags(x,y)            setU1(x,0,y)
#define eataCP_orFlags(x,y)             orU1(x,0,y)
#define eataCP_andFlags(x,y)            andU1(x,0,y)

#define eataCP_getReqSenseLen(x)        getU1(x,1)
#define eataCP_setReqSenseLen(x,y)      setU1(x,1,y)

#define eataCP_getNestedFW(x)           getU1(x,5)
#define eataCP_setNestedFW(x,y)         setU1(x,5,y)
#define eataCP_orNestedFW(x,y)          orU1(x,5,y)
#define eataCP_andNestedFW(x,y)         andU1(x,5,y)

#define eataCP_getPhysical(x)           getU1(x,6)
#define eataCP_setPhysical(x,y)         setU1(x,6,y)
#define eataCP_orPhysical(x,y)          orU1(x,6,y)
#define eataCP_andPhysical(x,y)         andU1(x,6,y)

#define eataCP_getDevAddr(x)            getU1(x,7)
#define eataCP_setDevAddr(x,y)          setU1(x,7,y)
#define eataCP_orDevAddr(x,y)           orU1(x,7,y)
#define eataCP_andDevAddr(x,y)          andU1(x,7,y)
#define eataCP_getBus(x)                (eataCP_getDevAddr(x)>>5)
#define eataCP_setBus(x,y)              (eataCP_andDevAddr(x,31),       \
                                         eataCP_orDevAddr(x,(y)<<5))
#define eataCP_getTarget(x)             (eataCP_getDevAddr(x)&31)
#define eataCP_setTarget(x,y)           (eataCP_andDevAddr(x,225),      \
                                         eataCP_orDevAddr(x,(y)&31))

#define eataCP_getMessage(x)            getU1(x,8)
#define eataCP_setMessage(x,y)          setU1(x,8,y)
#define eataCP_orMessage(x,y)           orU1(x,8,y)
#define eataCP_andMessage(x,y)          andU1(x,8,y)
#define eataCP_getLun(x)                (eataCP_getMessage(x)&7)
#define eataCP_setLun(x,y)              (eataCP_andMessage(x,248),      \
                                         eataCP_orMessage(x,(y)&7))

#define eataCP_getCDB(x)                getUP1(x,12)

#if (!defined(eataCP_getDataLength))
# define eataCP_getDataLength(x)        getU4(x,24)
#endif
#if (!defined(eataCP_setDataLength))
# define eataCP_setDataLength(x,y)      setU4(x,24,(unsigned long)(y))
#endif
#define eataCP_getDataLengthPtr(x)      getUP4(x,24)
#if (!defined(eataCP_getSgLength))
# define eataCP_getSgLength(x)          eataCP_getDataLength(x)
#endif
#if (!defined(eataCP_setSgLength))
# define eataCP_setSgLength(x,y)        eataCP_setDataLength(x,y)
#endif
#define eataCP_getSgLengthPtr(x)        eataCP_getDataLengthPtr(x)

#define eataCP_getVCPaddr(x)            (*((unsigned long *)getUP1(x,28)))
#define eataCP_setVCPaddr(x,y)          (*((unsigned long *)getUP1(x,28)) \
                                                = (unsigned long)(y))

#if (!defined(eataCP_getDataAddr))
# if (defined(osdVirt))
#  define eataCP_getDataAddr(x)         osdVirt(getU4(x,32))
# else
#  define eataCP_getDataAddr(x)         getU4(x,32)
# endif
#endif
#if (!defined(eataCP_setDataAddr))
# if (defined(osdPhys))
#  define eataCP_setDataAddr(x,y)       setU4(x,32,osdPhys((unsigned long)(y)))
# else
#  define eataCP_setDataAddr(x,y)       setU4(x,32,(unsigned long)(y))
# endif
#endif
#if (!defined(eataCP_setDataAddrPtr))
# define eataCP_getDataAddrPtr(x)       getUP4(x,32)
#endif
#if (!defined(eataCP_getSgAddr))
# if ((defined(osdPhys) && defined(osdVirt)) || (!defined(osdPhys) && !defined(osdVirt)))
#  define eataCP_getSgAddr(x)           ((eataSG_S *)eataCP_getDataAddr(x))
# endif
#endif
#if (!defined(eataCP_setSgAddr))
# define eataCP_setSgAddr(x,y)          eataCP_setDataAddr(x,y)
#endif
#define eataCP_getSgAddrPtr(x)          eataCP_getDataAddrPtr(x)

#if (!defined(eataCP_getSpAddr))
# if (defined(osdVirt))
#  define eataCP_getSpAddr(x)           (eataSP_S *)osdVirt(getU4(x,36))
# else
#  define eataCP_getSpAddr(x)           (eataSP_S *)getU4(x,36)
# endif
#endif
#if (!defined(eataCP_setSpAddr))
# if (defined(osdPhys))
#  define eataCP_setSpAddr(x,y)         setU4(x,36,osdPhys((unsigned long)(y)))
# else
#  define eataCP_setSpAddr(x,y)         setU4(x,36,(unsigned long)(y))
# endif
#endif
#define eataCP_getSpAddrPtr(x)          getUP4(x,36)

#if (!defined(eataCP_getReqSenseAddr))
# if (defined(osdVirt))
#  define eataCP_getReqSenseAddr(x)     ((sdRequestSense_S *)osdVirt(getU4(x,40)))
# else
#  define eataCP_getReqSenseAddr(x)     ((sdRequestSense_S *)getU4(x,40))
# endif
#endif
#if (!defined(eataCP_setReqSenseAddr))
# if (defined(osdPhys))
#  define eataCP_setReqSenseAddr(x,y)   setU4(x,40,osdPhys((unsigned long)(y)))
# else
#  define eataCP_setReqSenseAddr(x,y)   setU4(x,40,(unsigned long)(y))
# endif
#endif
#define eataCP_getReqSenseAddrPtr(x)    getUP4(x,40)

#define eataCP_clear(x)         osdBzero(x,eataCP_size)

/* EATA SP (Status Packet) Structure.................. */
/******************************************************************************
** Status Packet Data Structure - This Structure Is Returned By Controller   **
**   Upon Command Completion.   It Contains Status, Message Info And Pointer **
**   To The Initiating Command CCB (virtual).                                **
*******************************************************************************/

/* flags */
#define SP_STATUS       0x7f /* Controller status mask - see Status's above */
#define SP_EOC          0x80 /* End of command                          */

/* Controller status values */
#define   HERR_NO_ERROR        0x00    /* No Error on command          */
#define   HERR_SEL_TIMEOUT     0x01    /* Device Selection Time Out    */
#define   HERR_CMD_TIMEOUT     0x02    /* Device Command Time Out      */
#define   HERR_SCSI_RESET      0x03    /* SCSI Bus was RESET !         */
#define   HERR_HBA_POST        0x04    /* Initial Controller Power Up  */
#define   HERR_BUS_PHASE       0x05    /* Unexpected BUS Phase         */
#define   HERR_BUS_FREE        0x06    /* Unexpected BUS Free          */
#define   HERR_BUS_PARITY      0x07    /* SCSI Bus Parity Error        */
#define   HERR_BUS_HUNG        0x08    /* SCSI Bus Hung                */
#define   HERR_MSG_REJECT      0x09    /* Unexpected Message Reject    */
#define   HERR_BUS_RESET_STUCK 0x0a    /* SCSI Bus Reset Stuck         */
#define   HERR_AUTO_SENSE      0x0b    /* Auto-Request Sense Failed    */
#define   HERR_RAM_PARITY      0x0c    /* HBA Memory Parity error      */
#define   HERR_ABORT_NA        0x0d    /* CP aborted - NOT on Bus      */
#define   HERR_ABORTED         0x0e    /* CP aborted - WAS on Bus      */
#define   HERR_RESET_NA        0x0f    /* CP was reset - NOT on Bus    */
#define   HERR_RESET           0x10    /* CP was reset - WAS on Bus    */
#define   HERR_ECC             0x11    /* HBA Memory ECC Error         */
#define   HERR_PCI_PARITY      0x12    /* PCI Parity Error             */
#define   HERR_PCI_MASTER      0x13    /* PCI Master Abort             */
#define   HERR_PCI_TARGET      0x14    /* PCI Target Abort             */
#define   HERR_PCI_SIGNAL_TARGET 0x15  /* PCI Signalled Target Abort   */

/* SCSI status values */
#define   SERR_GOOD            0x00
#define   SERR_CHECK_CONDITION 0x02
#define   SERR_CONDITION_MET   0x04
#define   SERR_BUSY            0x08
#define   SERR_INTERMEDIATE    0x10
#define   SERR_INTM_CM         0x14
#define   SERR_RESV_CONFLICT   0x18
#define   SERR_CMD_TERMINATED  0x22
#define   SERR_QUEUE_FULL      0x28

#define eataSP_size             24
typedef unsigned char   eataSP_S[eataSP_size];

#if (!defined(eataSP_getCtlrStatus))
# define eataSP_getCtlrStatus(x)        getU1(x,0)
#endif
#if (!defined(eataSP_setCtlrStatus))
# define eataSP_setCtlrStatus(x,y)      setU1(x,0,y)
#endif
#if (!defined(eataSP_orCtlrStatus))
# define eataSP_orCtlrStatus(x,y)       orU1(x,0,y)
#endif
#if (!defined(eataSP_andCtlrStatus))
# define eataSP_andCtlrStatus(x,y)      andU1(x,0,y)
#endif

#if (!defined(eataSP_getScsiStatus))
# define eataSP_getScsiStatus(x)        getU1(x,1)
#endif
#if (!defined(eataSP_setScsiStatus))
# define eataSP_setScsiStatus(x,y)      setU1(x,1,y)
#endif

#if (!defined(eataSP_getResidue))
# define eataSP_getResidue(x)           getU4(x,4)
#endif
#if (!defined(eataSP_setResidue))
# define eataSP_setResidue(x,y)         setU4(x,4,(unsigned long)(y))
#endif

#if (!defined(eataSP_getVCPaddr))
# define eataSP_getVCPaddr(x)           (*((unsigned long *)getUP1(x,8)))
#endif
#if (!defined(eataSP_setVCPaddr))
# define eataSP_setVCPaddr(x,y)         ((*((unsigned long *)getUP1(x,8))) = y)
#endif

#if (!defined(eataSP_getMessage))
# define eataSP_getMessage(x)           getUP1(x,12)
#endif

#if (!defined(eataSP_clear))
# define eataSP_clear(x)         osdBzero(x,eataSP_size)
#endif

/* EATA SG (Scatter Gather) Structure.................. */

#define eataSG_size             8
typedef unsigned char   eataSG_S[eataSG_size];

#if (!defined(eataSG_getAddr))
# if (defined(osdVirt))
#  define eataSG_getAddr(x)             osdVirt(getU4(x,0))
# else
#  define eataSG_getAddr(x)             getU4(x,0)
# endif
#endif
#if (!defined(eataSG_setAddr))
# if (defined(osdPhys))
#  define eataSG_setAddr(x,y)           setU4(x,0,osdPhys((unsigned long)(y)))
# else
#  define eataSG_setAddr(x,y)           setU4(x,0,(unsigned long)(y))
# endif
#endif
#define eataSG_getAddrPtr(x)            getUP4(x,0)

#define eataSG_getLength(x)             getU4(x,4)
#define eataSG_setLength(x,y)           setU4(x,4,(unsigned long)(y))
#define eataSG_getLengthPtr(x)          getUP4(x,4)

/*
 *      Log Sense page that provides a list of the LSUs installed into the
 *      specified HBA. This log page is an interpreted 0x36.
 */

#define eataLSU_size            512
typedef unsigned char   eataLSU_S[eataLSU_size];

#define eataLSU_getPageCode(x)          getU1(x,0)
#define eataLSU_getReserved1(x)         getU1(x,1)
#define eataLSU_getPageLength(x)        getU2(x,2)
#define eataLSU_getParmCode(x)          getU2(x,4)
#define eataLSU_getReserved2(x)         getU1(x,6)
#define eataLSU_getSize(x)              getU1(x,7)
#define eataLSU_getEataDevAddr(x)       ((eataLSUList_S *)getUP1(x,8))

/*
 *      The LSU data list contained at eataLSU_getEataDevAddr
 */
#define eataLSUList_size        2
typedef unsigned char   eataLSUList_S[eataLSUList_size];

#define eataLSUList_getBus(x)           (getU1(x,0) & 7)
#define eataLSUList_getHba(x)           (getU1(x,0) >> 3)
#define eataLSUList_getLun(x)           (getU1(x,1) & 15)
#define eataLSUList_getTarget(x)        (getU1(x,1) >> 4)

/*
 *      A Mode Sense(10) page 0x2A gets you ...
 */
#define PHYS_CHANGE     0x80

#define eataPhysDesc_size       250
typedef unsigned char   eataPhysDesc_S[eataPhysDesc_size];

/* The Mode Page header */
#define eataPhysDesc_getDataLength(x)       getU2(x,0)
#define eataPhysDesc_setDataLength(x,y)     setU2(x,0,y)
#define eataPhysDesc_getMediumType(x)       getU1(x,2)
#define eataPhysDesc_getDevice(x)           getU1(x,3)
#define eataPhysDesc_getReserved1(x)        getU2(x,4)
#define eataPhysDesc_getBlockLength(x)      getU2(x,6)
/* The actual Mode Page */
#define eataPhysDesc_getModePage(x)         getU1(x,8)
#define eataPhysDesc_getLength(x)           getU1(x,9)
/* A status array, [targets][Bus] [16][15] */
#define eataPhysDesc_getStatus(x)           getUP1(x,10)

/*
 *      Then, a Mode sense(10) page 0x3B gets you ...
 */

#define             LAP_CMD_ADD                 0x80
#define             LAP_CMD_DELETE              0x81
#define             LAP_CMD_MODIFY              0x82
#define             LAP_CMD_REPLACE             0x83
#define             LAP_CMD_ABORT               0x84
#define             LAP_CMD_BUILD               0x88
#define             LAP_CMD_REBUILD             0x89
#define             LAP_CMD_VERIFY              0x8a
#define             LAP_CMD_VERIFY_FIX          0x8b
#define             LAP_CMD_VERIFY_ABORT        0x8c

#define eataLSUDesc_size        512
typedef unsigned char   eataLSUDesc_S[eataLSUDesc_size];

/* The Mode Page header */
#define eataLSUDesc_getDataLength(x)        getU2(x,0)
#define eataLSUDesc_setDataLength(x,y)      setU2(x,0,y)
#define eataLSUDesc_getMediumType(x)        getU1(x,2)
#define eataLSUDesc_getDevice(x)            getU1(x,3)
#define eataLSUDesc_getReserved1(x)         getU2(x,4)
#define eataLSUDesc_getBlockLength(x)       getU2(x,6)
/* The actual Mode Page */
#define eataLSUDesc_getModePage(x)          getU1(x,8)
#define eataLSUDesc_getLength(x)            getU1(x,9)
#define eataLSUDesc_getActionStatus(x)      getU1(x,10)
#define eataLSUDesc_setActionStatus(x,y)    setU1(x,10,y)
#define eataLSUDesc_getRAIDLevel(x)         getU1(x,11)
#define eataLSUDesc_getLsuType(x)           getU1(x,12)
#define eataLSUDesc_getLsuBytesPerBlock(x)  getU4(x,13)
#define eataLSUDesc_getCompBytesPerBlock(x) getU2(x,17)
#define eataLSUDesc_getLsuCapacity(x)       getU4(x,19)
#define eataLSUDesc_getStartOffset(x)       getU4(x,23) /* Verify Error Block */
#define eataLSUDesc_getReserved2(x)         getUP1(x,27)
#define eataLSUDesc_getLsuStripeSize(x)     getU1(x,31)
#define eataLSUDesc_getCopyDir(x)           getU1(x,32)
#define eataLSUDesc_getFlags(x)             getU1(x,33)
#define eataLSUDesc_getReconBlock(x)        getU4(x,34)
#define eataLSUDesc_getReconFrequency(x)    getU1(x,38)
#define eataLSUDesc_getReconAmount(x)       getU2(x,39)
#define eataLSUDesc_getLunNumber(x)         getU1(x,41)
#define eataLSUDesc_getHbaIndex(x)          getU1(x,42)
#define eataLSUDesc_getSpinDown(x)          getU1(x,43)
#define eataLSUDesc_getCompList(x)          ((eataLSUCompList_S*)(getUP1(x,44)))
/*
 *      And the component list looks like:
 */

#define eataLSUCompList_size    6
typedef unsigned char   eataLSUCompList_S[eataLSUCompList_size];

#define eataLSUCompList_getBus(x)       eataLSUList_getBus(x)
#define eataLSUCompList_getHba(x)       eataLSUList_getHba(x)
#define eataLSUCompList_getLun(x)       eataLSUList_getLun(x)
#define eataLSUCompList_getTarget(x)    eataLSUList_getTarget(x)
#define eataLSUCompList_getStripe(x)    getU4(x,2)

#endif  /* __DPT_EATA_H */
