/*	BSDI dpt_scsi.h,v 2.4 1999/01/15 19:08:17 geertj Exp	*/

/*
 * Copyright (c) 1996-1999 Distributed Processing Technology Corporation
 * All rights reserved.
 *
 * Redistribution and use in source form, with or without modification, are
 * permitted provided that redistributions of source code must retain the
 * above copyright notice, x list of conditions and the following disclaimer.
 *
 * This software is provided `as is' by Distributed Processing Technology and
 * any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose,
 * are disclaimed. In no event shall Distributed Processing Technology be
 * liable for any direct, indirect, incidental, special, exemplary or
 * consequential damages (including, but not limited to, procurement of
 * substitute goods or services; loss of use, data, or profits; or business
 * interruptions) however caused and on any theory of liability, whether in
 * contract, strict liability, or tort (including negligence or otherwise)
 * arising in any way out of the use of x driver software, even if advised
 * of the possibility of such damage.
 *
 * DPT SCSI Description File
 *
 */
#if (!defined(__DPT_SCSI_H))
#define       __DPT_SCSI_H

/*
 *      File -  DPT_SCSI.H
 *
 *      Description:  This file contains basic SCSI definitions.
 *
 *      Copyright Distributed Processing Technology, Corp.
 *        140 Candace Dr.
 *        Maitland, Fl. 32751   USA
 *        Phone: (407) 830-5522  Fax: (407) 260-5366
 *        All Rights Reserved
 *
 *      Author: Mark Salyzyn
 *      Date:   Aug 29 1996
 */

/*
 * SCSI CDB Opcodes............................................
 *
 *   SCSI Opcode:
 *
 *   Group 0: 0x00 - 0x1f -> 6 Byte CDBs  - 21 bit LBAs
 *   Group 1: 0x20 - 0x3f -> 10 Byte CDBs - 32 bit LBAs
 *   Group 2: 0x40 - 0x5f -> 10 Byte CDBs - 32 bit LBAs
 *   Group 3: 0x60 - 0x7f -> reserved
 *   Group 4: 0x80 - 0x9f -> reserved
 *   Group 5: 0xa0 - 0xbf -> 12 Byte CDBs - 32 bit LBAs
 *   Group 6: 0xc0 - 0xdf -> vendor unique
 *   Group 7: 0xe0 - 0xff -> vendor unique
 *
 * Note: "SC" stands for "SCSI Command"
 *
 * All SCSI Devices...........
 *   Group 0 - Mandatory Support
 */
#define SC_TEST_READY     0x00  /* Test Unit Ready              */
#define SC_REQ_SENSE      0x03  /* Request Sense                */
#define SC_INQUIRY        0x12  /* Inquiry command              */
#define SC_SEND_DIAG      0x1d  /* Send diagnostics             */
/*   Group 0 - Optional Support */
#define SC_COPY           0x18  /* Copy                         */
#define SC_RCVE_DIAG      0x1c  /* Recieve diagnostics results  */
/*   Group 1 - Mandatory Support */
/*   Group 1 - Optional Support */
#define SC_COMPARE        0x39  /* Compare                      */
#define SC_COPY_VERIFY    0x3a  /* Copy & Verify                */
#define SC_WRITE_BUFFER   0x3b  /* Write Buffer                 */
#define SC_READ_BUFFER    0x3c  /* Read Buffer                  */
/*   Group 2 */
#define SC_LOG_SENSE      0x4d  /* Log Sense                    */
#define SC_LOG_SELECT     0x4c  /* Log Select                   */
#define SC_MODE_SELECT    0x55  /* Mode Select                  */
#define SC_MODE_SENSE     0x5a  /* Mode Sense                   */
#define SC_READ_LOG       0x5f  /* Read Log                     */

/*
 * Direct Access Devices......
 *   Group 0 - Mandatory Support
 */
#define SC_FORMAT         0x04  /* Format Unit                  */
#define SC_READ6          0x08  /* Read                         */
#define SC_WRITE6         0x0a  /* Write                        */
#define SC_RESERVE6       0x16  /* Reserve                      */
#define SC_RELEASE6       0x17  /* Release                      */
/*   Group 0 - Optional Support */
#define SC_REZERO         0x01  /* Rezero Unit                  */
#define SC_REASSIGN       0x07  /* Reassign blocks              */
#define SC_SEEK6          0x0b  /* Seek                         */
#define SC_MODE_SELECT6   0x15  /* Mode Select                  */
#define SC_MODE_SENSE6    0x1a  /* Mode Sense                   */
#define SC_START_STOP     0x1b  /* Start/Stop Unit              */
#define SC_MEDIA          0x1e  /* Prevent/Allow media removal  */
/*   Group 1 - Mandatory Support */
#define SC_READ_CAPACITY  0x25  /* Read Capacity                */
#define SC_READ           0x28  /* Read                         */
#define SC_WRITE          0x2a  /* Write                        */
/*   Group 1 - Optional Support */
#define SC_SEEK           0x2b  /* Seek                         */
#define SC_WRITE_VERIFY   0x2e  /* Write & Verify               */
#define SC_VERIFY         0x2f  /* Verify                       */
#define SC_SEARCH_HIGH    0x30  /* Search Data High             */
#define SC_SEARCH_EQUAL   0x31  /* Search Data Equal            */
#define SC_SEARCH_LOW     0x32  /* Search Data Low              */
#define SC_SET_LIMITS     0x33  /* Set limits                   */
#define SC_PREFETCH       0x34  /* Pre-fetch                    */
#define SC_FLUSH_CACHE    0x35  /* Flush Cache                  */
#define SC_LOCK_CACHE     0x36  /* Lock/Unlock cache            */
#define SC_READ_DEFECT    0x37  /* Read defect data             */
#define SC_READ_LONG      0x3e  /* Read long                    */
#define SC_WRITE_LONG     0x3f  /* Write long                   */
/*   Group 5 - Optional Support */
#define SC_READ_EXTENDED  0xA8  /* Read extended                */
#define SC_WRITE_EXTENDED 0xAA  /* Write extended               */
#define SC_VERIFY_EXTENDED 0xAF /* Verify extended              */
#define SC_WRITE_VERIFY_EXT 0xAE/* Write & Verify extended      */

/* DPT Unique Commands */
#define SC_RUN        0xcf  /* Request Unit Notification (DPT unique)   */
#define SC_DPT_MFC    0x0e  /* DPT multi-function command               */

  /* Function codes for the DPT mult-function command */
#define MFC_ALARM_OFF           0x01 /* Turn HBA Alarm Off              */
#define MFC_READ_RAID_TBL       0x02 /* Cmd HBA to re-read RAID table   */
#define MFC_UNCRASH             0x03 /* Un-crash drive                  */
#define MFC_QUIET               0x04 /* Quiet SCSI bus                  */
#define MFC_UNQUIET             0x05 /* Un-quiet SCSI bus               */
#define MFC_ALARM_ON            0x06 /* Turn HBA alarm on               */
#define MFC_DIAG_SCHEDULE       0x0f /* Schedule a F/W diagnostic       */
#define MFC_DIAG_STOP           0x10 /* Stop an active F/W diagnostic   */
#define MFC_DIAG_STATUS         0x11 /* Get the F/W diagnostic status   */
                                     /* for a device (blocks complete...) */
#define MFC_DIAG_EXCLUSION      0x12 /* Set the background task         */
                                     /* exclusion period                */
#define MFC_DIAG_QUERY_SCHEDULE 0x13 /* Query the diagnostic schedule   */
                                     /* for a device                    */
#define MFC_DIAG_UNSCHEDULE     0x14 /* Unschedule a scheduled diagnostic */
#define MFC_SMART_EMUL_ON       0x15 /* Enable SMART emulation          */
#define MFC_SMART_EMUL_OFF      0x16 /* Disable SMART emulation         */
#define MFC_SMART_STATUS        0x19 /* Get the SMART status            */

/*
 *      SCSI Command Definitions............................
 * Note: "sc" stands for SCSI command
 */

/*
 *      Some standard access functions.
 */
#define getOpCode(x)            getU1(x,0)
#define setOpCode(x,y)          setU1(x,0,y)

#define getLun(x)               getU1(x,1)
#define setLun(x,y)             setU1(x,1,y)
#define orLun(x,y)              orU1(x,1,y)
#define andLun(x,y)             andU1(x,1,y)

#define getPageCode(x)          getU1(x,2)
#define setPageCode(x,y)        setU1(x,2,y)

#define getReserved1(x)         getU1(x,3)
#define setReserved1(x,y)       setU1(x,3,y)

#define getReserved2(x)         getU1(x,4)
#define setReserved2(x,y)       setU1(x,4,y)

#define getReserved3(x)         getU1(x,5)
#define setReserved3(x,y)       setU1(x,5,y)

#define getReserved4(x)         getU1(x,6)
#define setReserved4(x,y)       setU1(x,6,y)

#define getAllocLength(x)       getU2(x,7)
#define setAllocLength(x,y)     setU2(x,7,y)

#define getControl(x)           getU1(x,9)
#define setControl(x,y)         setU1(x,9,y)

/*
 *      Name: scInquiry_S
 *      Description: This structure defines a SCSI Inquiry Command.
 */

/* lun */
#define FLG_SCSI_EVPD     0x01  /* Enable vital product data    */
#define FLG_SCSI_LUN      0xe0  /* SCSI LUN                     */

#define scInquiry_size          6
typedef unsigned char   scInquiry_S[scInquiry_size];

/*-----------------
 * Access Functions
 *-----------------*/

#define scInquiry_getOpCode(x)          getOpCode(x)
#define scInquiry_setOpCode(x,y)        setOpCode(x,y)

#define scInquiry_getLun(x)             getLun(x)
#define scInquiry_setLun(x,y)           setLun(x,y)
#define scInquiry_orLun(x,y)            orLun(x,y)
#define scInquiry_andLun(x,y)           andLun(x,y)

#define scInquiry_getPageCode(x)        getPageCode(x)
#define scInquiry_setPageCode(x,y)      setPageCode(x,y)

#define scInquiry_getReserved1(x)       getReserved1(x)
#define scInquiry_setReserved1(x,y)     setReserved1(x,y)

#define scInquiry_getAllocLength(x)     getU1(x,4)
#define scInquiry_setAllocLength(x,y)   setU1(x,4,y)

#define scInquiry_getControl(x)         getU1(x,5)
#define scInquiry_setControl(x,y)       setU1(x,5,y)

/*---------------------------
 * Required Support Functions
 *---------------------------*/

#define scInquiry_clear(x)      osdBzero(x,scInquiry_size)

/*
 *      Name: scRdCapacity_S
 *      Description: This structure defines a SCSI read capacity command.
 */

/* lun */
#define FLG_RDCAP_REL_ADDR    0x01      /* Relative addressing  */

/* byte8 */
#define FLG_RDCAP_PMI         0x01      /* Partial medium indicator     */

#define scRdCapacity_size       10
typedef unsigned char   scRdCapacity_S[scRdCapacity_size];

/*-----------------
 * Access Functions
 *-----------------*/

#define scRdCapacity_getOpCode(x)       getOpCode(x)
#define scRdCapacity_setOpCode(x,y)     setOpCode(x,y)

#define scRdCapacity_getLun(x)          getLun(x)
#define scRdCapacity_setLun(x,y)        setU1(x,1,y)
#define scRdCapacity_orLun(x,y)         orLun(x,y)
#define scRdCapacity_andLun(x,y)        andU1(x,1,y)

#define scRdCapacity_getAddress(x)      getU4(x,2)
#define scRdCapacity_setAddress(x,y)    setU4(x,2,y)

#define scRdCapacity_getReserved1(x)    getReserved4(x)
#define scRdCapacity_setReserved1(x,y)  setReserved4(x,y)

#define scRdCapacity_getReserved2(x)    getU1(x,7)
#define scRdCapacity_setReserved2(x,y)  setU1(x,7,y)

#define scRdCapacity_getPmi(x)          getU1(x,8)
#define scRdCapacity_setPmi(x,y)        setU1(x,8,y)

#define scRdCapacity_getControl(x)      getControl(x)
#define scRdCapacity_setControl(x,y)    setControl(x,y)

/*---------------------------
 * Required Support Functions
 *---------------------------*/

#define scRdCapacity_clear(x)   osdBzero(x,scRdCapacity_size)

/*
 *      Name: scReadWrite6_S
 *      Description: This structure defines a SCSI read and write commands.
 */

#define scReadWrite6_size       6
typedef unsigned char   scReadWrite6_S[scReadWrite6_size];

   /*-----------------
    * Access Functions
    *-----------------*/

#define scReadWrite6_getOpCode(x)       getOpCode(x)
#define scReadWrite6_setOpCode(x,y)     setOpCode(x,y)

#define scReadWrite6_getLun(x)          getLun(x)
#define scReadWrite6_setLun(x,y)        setLun(x,y)
#define scReadWrite6_orLun(x,y)         orLun(x,y)
#define scReadWrite6_andLun(x,y)        andLun(x,y)

#define scReadWrite6_getLba(x)          (getU3(x,1)&0x1FFFFFL)
/* The side effects of *this* macro are scary ... */
#define scReadWrite6_setLba(x,y)        setU3(x,1,((unsigned long)(y) \
                                         &0x1FFFFFL) | ((unsigned long) \
                                         (getLun(x)&0xE0)<<16L))
#define scReadWrite6_getLength(x)       getU1(x,4)
#define scReadWrite6_setLength(x,y)     setU1(x,4,y)

#define scReadWrite6_getControl(x)      getU1(x,5)
#define scReadWrite6_setControl(x,y)    setU1(x,5,y)

   /*---------------------------
    * Required Support Functions
    *---------------------------*/

#define scReadWrite6_clear(x)   osdBzero(x,scReadWrite6_size)

/*
 *      Name: scReadWrite_S
 *      Description: This structure defines a SCSI read, write and synchronize
 *      cache commands.
 */

#define scReadWrite_size        10
typedef unsigned char   scReadWrite_S[scReadWrite_size];

   /*-----------------
    * Access Functions
    *-----------------*/

#define scReadWrite_getOpCode(x)        getOpCode(x)
#define scReadWrite_setOpCode(x,y)      setOpCode(x,y)

#define scReadWrite_getLun(x)           getLun(x)
#define scReadWrite_setLun(x,y)         setLun(x,y)
#define scReadWrite_orLun(x,y)          orLun(x,y)
#define scReadWrite_andLun(x,y)         andLun(x,y)

#define scReadWrite_getLba(x)           getU4(x,2)
#define scReadWrite_setLba(x,y)         setU4(x,2,y)

#define scReadWrite_getReserved(x)      getU1(x,6)
#define scReadWrite_setReserved(x,y)    setU1(x,6,y)

#define scReadWrite_getLength(x)        getU2(x,7)
#define scReadWrite_setLength(x,y)      setU2(x,7,y)

#define scReadWrite_getControl(x)       getU1(x,9)
#define scReadWrite_setControl(x, y)    setU1(x,9,y)

   /*---------------------------
    * Required Support Functions
    *---------------------------*/

#define scReadWrite_clear(x)    osdBzero(x,scReadWrite_size)

/*
 *      Name: scReadWrite12_S
 *      Description: This structure defines a SCSI read and write commands.
 */

#define scReadWrite12_size      12
typedef unsigned char   scReadWrite12_S[scReadWrite12_size];

   /*-----------------
    * Access Functions
    *-----------------*/

#define scReadWrite12_getOpCode(x)      getOpCode(x)
#define scReadWrite12_setOpCode(x,y)    setOpCode(x,y)

#define scReadWrite12_getLun(x)         getLun(x)
#define scReadWrite12_setLun(x,y)       setLun(x,y)
#define scReadWrite12_orLun(x,y)        orLun(x,y)
#define scReadWrite12_andLun(x,y)       andLun(x,y)

#define scReadWrite12_getLba(x)         getU4(x,2)
#define scReadWrite12_setLba(x,y)       setU4(x,2,y)

#define scReadWrite12_getLength(x)      getU4(x,6)
#define scReadWrite12_setLength(x,y)    setU4(x,6,y)

#define scReadWrite12_getReserved(x)    getU1(x,10)
#define scReadWrite12_setReserved(x,y)  setU1(x,10,y)

#define scReadWrite12_getControl(x)     getU1(x,11)
#define scReadWrite12_setControl(x, y)  setU1(x,11,y)

   /*---------------------------
    * Required Support Functions
    *---------------------------*/

#define scReadWrite12_clear(x)  osdBzero(x,scReadWrite12_size)

/*
 *      Name: scModeSense_S
 *      Description: This structure defines the SCSI mode sense command
 */

/*      FLG_MDS_PAGECODE        */
#define FLG_MDS_CURRENT       0x00
#define FLG_MDS_CHANGEABLE    0x40
#define FLG_MDS_DEFAULT       0x80
#define FLG_MDS_SAVED         0xc0

/*      lun                     */
#define FLG_MDS_DBD   0x08              /* Disable block descriptors    */

/*      pageCode                */
#define FLG_MDS_PAGECODE      0x3f      /* Page Code                    */
#define FLG_MDS_CONTROL       0xc0      /* Page control                 */

#define scModeSense_size        10
typedef unsigned char   scModeSense_S[scModeSense_size];

/*-----------------
 * Access Functions
 *-----------------*/

#define scModeSense_getOpCode(x)        getOpCode(x)
#define scModeSense_setOpCode(x,y)      setOpCode(x,y)

#define scModeSense_getLun(x)           getLun(x)
#define scModeSense_setLun(x,y)         setLun(x,y)
#define scModeSense_orLun(x,y)          orLun(x,y)
#define scModeSense_andLun(x,y)         andLun(x,y)

#define scModeSense_getPageCode(x)      getPageCode(x)
#define scModeSense_setPageCode(x,y)    setPageCode(x,y)

#define scModeSense_getReserved1(x)     getReserved1(x)
#define scModeSense_setReserved1(x,y)   setReserved1(x,y)

#define scModeSense_getReserved2(x)     getReserved2(x)
#define scModeSense_setReserved2(x,y)   setReserved2(x,y)

#define scModeSense_getReserved3(x)     getReserved3(x)
#define scModeSense_setReserved3(x,y)   setReserved3(x,y)

#define scModeSense_getReserved4(x)     getReserved4(x)
#define scModeSense_setReserved4(x,y)   setReserved4(x,y)

#define scModeSense_getAllocLength(x)   getAllocLength(x)
#define scModeSense_setAllocLength(x,y) setAllocLength(x,y)
#define scModeSense_swapAllocLength(x)  swapAllocLength(x)

#define scModeSense_getControl(x)       getControl(x)
#define scModeSense_setControl(x,y)     setControl(x,y)

/*---------------------------
 * Required Support Functions
 *---------------------------*/

#define scModeSense_clear(x)    osdBzero(x,scModeSense_size)

/*
 *      Name: scLogSense_S
 *      Description: This structure defines the SCSI log sense command
 */

/* lun  */
#define FLG_LGS_SP    0x01              /* Save parameters              */
#define FLG_LGS_PPC   0x02              /* Parameter page control       */

/* FLG_LGS_PAGECODE */
#define FLG_LGS_CURRENT       0x00
#define FLG_LGS_CHANGEABLE    0x40
#define FLG_LGS_DEFAULT       0x80
#define FLG_LGS_SAVED         0xc0

/* lun */
#define FLG_LGS_DBD   0x08              /* Disable block descriptors    */

/* pageCode */
#define FLG_LGS_PAGECODE      0x3f      /* Page Code                    */
#define FLG_LGS_CONTROL       0xc0      /* Page control                 */

#define scLogSense_size         10
typedef unsigned char   scLogSense_S[scLogSense_size];

/*-----------------
 * Access Functions
 *-----------------*/

#define scLogSense_getOpCode(x)         getOpCode(x)
#define scLogSense_setOpCode(x,y)       setOpCode(x,y)

#define scLogSense_getLun(x)            getLun(x)
#define scLogSense_setLun(x,y)          setLun(x,y)
#define scLogSense_orLun(x,y)           orLun(x,y)
#define scLogSense_andLun(x,y)          andLun(x,y)

#define scLogSense_getPageCode(x)       getPageCode(x)
#define scLogSense_setPageCode(x,y)     setPageCode(x,y)

#define scLogSense_getReserved1(x)      getReserved1(x)
#define scLogSense_setReserved1(x,y)    setReserved1(x,y)

#define scLogSense_getReserved2(x)      getReserved2(x)
#define scLogSense_setReserved2(x,y)    setReserved2(x,y)

#define scLogSense_getParamPtr(x)       getU2(x,5)
#define scLogSense_setParamPtr(x,y)     setU2(x,5,y)

#define scLogSense_getAllocLength(x)    getAllocLength(x)
#define scLogSense_setAllocLength(x,y)  setAllocLength(x,y)
#define scLogSense_swapAllocLength(x)   swapAllocLength(x)

#define scLogSense_getControl(x)        getControl(x)
#define scLogSense_setControl(x,y)      setControl(x,y)

/*---------------------------
 * Required Support Functions
 *---------------------------*/

#define scLogSense_clear(x)     osdBzero(x,scLogSense_size)

/*
 *      SCSI data buffer definitions........................
 *      Note: "sd" stands for "SCSI data"
 */

/*
 *      Name: sdRequestSense_S
 *      Description: This structure defines the SCSI Request Sense return data.
 */

/* error */
#define ERROR_VALID     0x80    /* Error is valid */
#define ERROR_CLASS     0x70    /* Error Class    */
#define ERROR_CODE      0x00    /* Error Code     */

/* Extended Key */
#define KEY_FILEMARK    0x80    /* Only for sequential devices  */
#define KEY_EOM         0x40    /* End of sequential media      */
#define KEY_ILI         0x20    /* Incorrect length indicator   */
#define KEY_SENSE       0x0f    /* Sense Key:                   */
#define SENSE_NONE      0x00    /*      No specific sense info  */
#define SENSE_RECOVERED 0x01    /*      Error recovered         */
#define SENSE_NOT_READY 0x02    /*      Device not ready        */
#define SENSE_MEDIUM    0x03    /*      Flaw in Media           */
#define SENSE_HARDWARE  0x04    /*      Self test failure       */
#define SENSE_ILLEGAL   0x05    /*      Illegal SCSI request    */
#define SENSE_ATTENTION 0x06    /*      Media changed           */
#define SENSE_PROTECTED 0x07    /*      Data protected, no access */
#define SENSE_BLANK     0x08    /*      WORM detected blank     */
#define SENSE_COPY_ABORTED 0x0A /*      Copy aborted            */
#define SENSE_ABORTED   0x0B    /*      Aborted command (retry) */
#define SENSE_EQUAL     0x0C    /*      Data is equal           */
#define SENSE_OVERFLOW  0x0D    /*      Data in buffer not written */
#define SENSE_MISCOMPARE 0x0E   /*      Data is not equal       */

#if (!defined(sdRequestSense_size))
# define sdRequestSense_size            8
#endif
typedef unsigned char   sdRequestSense_S[sdRequestSense_size];

/*-----------------
 * Access Functions
 *-----------------*/

#define sdRequestSense_getError(x)      getU1(x,0)
#define sdRequestSense_setError(x,y)      setU1(x,0,y)

#define sdRequestSense_getSegment(x)    getU1(x,1)
#define sdRequestSense_getLba(x)        (getU3(x,1)&0x1FFFFFL)
#define sdRequestSense_setSegment(x,y)  setU1(x,1,y)
#define sdRequestSense_setLba(x,y)      ( andU1(x,1,0xE0),              \
                                          orU1(x,1,((y)>>16)&0x1F),     \
                                          setU2(x,2,y))

#define sdRequestSense_getKey(x)        getU1(x,2)
#define sdRequestSense_setKey(x,y)      setU1(x,2,y)

#define sdRequestSense_getInfo(x)       getU4(x,3)
#define sdRequestSense_setInfo(x,y)     setU4(x,3)

#define sdRequestSense_getLength(x)     getU1(x,7)
#define sdRequestSense_setLength(x,y)   setU1(x,7,y)

#define sdRequestSense_getAdditiona(x)  getUP1(x,8)

/*---------------------------
 * Required Support Functions
 *---------------------------*/

#define sdRequestSense_clear(x) osdBzero(x,sdRequestSense_size)

/*
 *      Name: sdInquiry_S
 *      Description: This structure defines the SCSI inquiry return data.
 */

/* peripheral - bits */
#define PERIPH_TYPE      0x1f /* Peripheral device type         */
#define PERIPH_QUAL      0xe0 /* Peripheral qualifier           */

/* devType - bits */
#define DEVTYPE_MODIFIER 0x7f /* Device type modifier           */
#define DEVTYPE_RMB      0x80 /* Removable media flag           */

/* version - bits */
#define VER_ANSI         0x07 /* ANSI version supported         */
#define VER_ECMA         0x38 /* European Computer Manufacturers Association */
#define VER_ISO          0xc0 /* International Organization Standardization */

/* miscFlag1 - bits */
#define MISC_RESPONSE    0x0f /* Response data format (1=SCSI-1,2=SCSI-2) */
#define MISC_TRMIO       0x40 /* Terminate I/O supported        */
#define MISC_AEN         0x80 /* Asynchronous event notification supported */

/* miscFlag2 - bits */
#define MISC_SOFT_RESET   0x01 /* Soft reset supported          */
#define MISC_CMD_QUEUE    0x02 /* Command queueing supported    */
#define MISC_LINK_CLGS    0x08 /* Linked commands supported     */
#define MISC_SYNC_XFR     0x10 /* Synchronous transfers supported */
#define MISC_BUS_WIDTH_16 0x20 /* 16 bit wide transfers supported */
#define MISC_BUS_WIDTH_32 0x40 /* 32 bit wide transfers supported */
#define MISC_REL_ADDR     0x80 /* Relative addressing supported */

#define sdInquiry_size          56
typedef unsigned char   sdInquiry_S[sdInquiry_size];

/*-----------------
 * Access Functions
 *-----------------*/

#define sdInquiry_getPeripheral(x)      getU1(x,0)
#define sdInquiry_setPeripheral(x,y)    setU1(x,0,y)

#define sdInquiry_getDevType(x)         getU1(x,1)
#define sdInquiry_setDevType(x,y)       setU1(x,1,y)

#define sdInquiry_getVersion(x)         getU1(x,2)
#define sdInquiry_setVersion(x,y)       setU1(x,2,y)

#define sdInquiry_getMiscFlag1(x)       getU1(x,3)
#define sdInquiry_setMiscFlag1(x,y)     setU1(x,3,y)

#define sdInquiry_getLength(x)          getU1(x,4)
#define sdInquiry_setLength(x,y)        setU1(x,4,y)

#define sdInquiry_getReserved1(x)       getU1(x,5)
#define sdInquiry_setReserved1(x,y)     setU1(x,5,y)

#define sdInquiry_getReserved2(x)       getU1(x,6)
#define sdInquiry_setReserved2(x,y)     setU1(x,6,y)

#define sdInquiry_getMiscFlag2(x)       getU1(x,7)
#define sdInquiry_setMiscFlag2(x,y)     setU1(x,7,y)

#define sdInquiry_getVendorID(x)        getUP1(x,8)
#define sdInquiry_getProductID(x)       getUP1(x,16)
#define sdInquiry_getRevision(x)        getUP1(x,32)
#define sdInquiry_getVendorExtra(x)     getUP1(x,36)
#define sdInquiry_getReserved3(x)       getUP1(x,56)

/*---------------------------
 * Required Support Functions
 *---------------------------*/

#define sdInquiry_clear(x)      osdBzero(x,sdInquiry_size)

/*
 *      Name: sdRdCapacity_S
 *      Description: This structure defines the SCSI read capacity return data.
 */

#define sdRdCapacity_size       8
typedef unsigned char   sdRdCapacity_S[sdRdCapacity_size];

/*-----------------
 * Access Functions
 *-----------------*/

#define sdRdCapacity_getMaxLba(x)       getU4(x,0)
#define sdRdCapacity_setMaxLba(x,y)     setU4(x,0,y)

#define sdRdCapacity_getBlockSize(x)    getU4(x,4)
#define sdRdCapacity_setBlockSize(x,y)  setU4(x,4,y)

/*---------------------------
 * Required Support Functions
 *---------------------------*/

#define sdRdCapacity_clear(x)   osdBzero(x,sdRdCapacity_size)

#endif /* __DPT_SCSI_H */
