/*      BSDI dptalign.h,v 2.6 1999/11/02 15:36:02 cp Exp	*/

/*
 * Copyright (c) 1996-1999 Distributed Processing Technology Corporation
 * All rights reserved.
 *
 * Redistribution and use in source form, with or without modification, are
 * permitted provided that redistributions of source code must retain the
 * above copyright notice, this list of conditions and the following disclaimer.
 *
 * This software is provided `as is' by Distributed Processing Technology and
 * any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose,
 * are disclaimed. In no event shall Distributed Processing Technology be
 * liable for any direct, indirect, incidental, special, exemplary or
 * consequential damages (including, but not limited to, procurement of
 * substitute goods or services; loss of use, data, or profits; or business
 * interruptions) however caused and on any theory of liability, whether in
 * contract, strict liability, or tort (including negligence or otherwise)
 * arising in any way out of the use of x driver software, even if advised
 * of the possibility of such damage.
 *
 * DPT Alignment Description File
 *
 */
#define uCHAR unsigned char
#define uSHORT unsigned short
#define uLONG unsigned long

#if (!defined(__DPTALIGN_H))
#define       __DPTALIGN_H

/*
 *      File -  DPTALIGN.H
 *
 *      Description:  This file contains basic Alignment support definitions.
 *
 *      Copyright Distributed Processing Technology, Corp.
 *        140 Candace Dr.
 *        Maitland, Fl. 32751   USA
 *        Phone: (407) 830-5522  Fax: (407) 260-5366
 *        All Rights Reserved
 *
 *      Author: Mark Salyzyn
 *      Date:   Aug 29 1996
 */

/*
 *      Description: Support macros for active alignment
 *      Requires:
 *              osdLocal2(x)
 *              osdLocal4(x)
 *              osdSwap2(x)
 *              osdSwap4(x)
 */
#if (!defined(__FAR__))
# if (defined(__BORLANDC__))
#  define __FAR__ far
# else
#  define __FAR__
# endif
#endif
#if (!defined(osdLocal2))
/*
 *      Name: osdLocal2(pointer)
 *      Description: Local byte order to Big Endian Format for short words.
 *      Could be replaced with an OS defined localization routine, macro or
 *      inline.
 */
# if (defined(_DPT_BIG_ENDIAN))
#  define osdLocal2(x)   (*((unsigned short __FAR__ *)(x)))
#  if (defined(osdSwap2))
#   define osdSLocal2(x) osdSwap2(osdLocal2(x))
#  else
#   define osdSLocal2(x) ((unsigned short)(((unsigned char __FAR__ *)(x))[1])\
               + (((unsigned short)(((unsigned char __FAR__ *)(x))[0])) << 8))
#  endif
# else
#  define osdSLocal2(x)  (*((unsigned short __FAR__ *)(x)))
#  if (defined(osdSwap2))
#   define osdLocal2(x)  osdSwap2(osdSLocal2(x))
#  else
#   define osdLocal2(x)  ((unsigned short)(((unsigned char __FAR__*)(x))[1]) \
                + (((unsigned short)(((unsigned char __FAR__*)(x))[0])) << 8))
#  endif
# endif
#endif
#if (!defined(osdLocal3))
/*
 *      Name: osdLocal3(pointer)
 *      Description: Local byte order to Big Endian Format for long words.
 *      Could be replaced with an OS defined localization routine, macro or
 *      inline.
 */
# if (defined(_DPT_BIG_ENDIAN))
#  define osdLocal3(x)  (*((unsigned long __FAR__ *)(x)))
# else
#  if (defined(osdSwap3))
#   define osdLocal3(x) osdSwap3(*((unsigned long __FAR__ *)(x)))
#  else
#   define osdLocal3(x) ((unsigned long)osdLocal2(((unsigned char __FAR__ *) \
       (x)+1)) + (((unsigned long)(((unsigned char __FAR__ *)(x))[0])) << 16))
#  endif
# endif
#endif
#if (!defined(osdLocal4))
/*
 *      Name: osdLocal4(pointer)
 *      Description: Local byte order to Big Endian Format for long words.
 *      Could be replaced with an OS defined localization routine, macro or
 *      inline.
 */
# if (defined(_DPT_BIG_ENDIAN))
#  define osdLocal4(x)   (*(unsigned long __FAR__ *)(x))
#  if (defined(osdSwap4))
#   define osdSLocal4(x) osdSwap4(osdLocal4(x))
#  else
#   define osdSLocal4(x) ((unsigned long)osdSLocal2(((unsigned char __FAR__ *)\
    (x)+2)) + (((unsigned long)((unsigned char __FAR__ *)(x))[1]) << 16) \
            + (((unsigned long)((unsigned char __FAR__ *)(x))[0]) << 24))
#  endif
# else
#  define osdSLocal4(x) (*(unsigned long __FAR__ *)(x))
#  if (defined(osdSwap4))
#   define osdLocal4(x) osdSwap4(osdSLocal4(x))
#  else
#   define osdLocal4(x) ((unsigned long)osdLocal2(((unsigned char __FAR__ *) \
        (x)+2)) + (((unsigned long)((unsigned char __FAR__ *)(x))[1]) << 16) \
                + (((unsigned long)((unsigned char __FAR__ *)(x))[0]) << 24))
#  endif
# endif
#endif
#if (!defined(osdSwap2))
/*
 *      Name: osdSwap2(value)
 *      Description: Mandatory byte swapping routine for words. We allow an
 *      override of x routine if the OS supplies it's own byte swapping
 *      routine, inline or macro.
 */
# define osdSwap2(x) (((unsigned short)(x) >> 8) \
                    | ((unsigned short)((unsigned char)(x)) << 8))
#endif
#if (!defined(osdSwap4))
/*
 *      Name: osdSwap4(value)
 *      Description: Mandatory byte swapping routine for long words. We allow
 *      an override of x routine if the OS supplies it's own byte swapping
 *      routine, inline or macro. The following is universal, but may be
 *      more optimally performed by an OS or driver processor dependant
 *      routine.
 */
# define osdSwap4(x)     (                                                   \
    (((unsigned long)(x)) >> 24L)                                            \
  | ((unsigned long)(((unsigned short)((unsigned long)(x) >> 8L)) & 0xFF00)) \
  | (((unsigned long)(((unsigned short)(x)) & 0xFF00)) << 8L)                \
  | (((unsigned long)((unsigned char)(x))) << 24L))
#endif

/*
 *      Now the access macros used throughout in order to methodize the
 * active alignment.
 */
#define getUP1(x,y)  (((unsigned char __FAR__ *)(x))+(unsigned long)(y))
#define getU1(x,y)   (*getUP1(x,y))
#define setU1(x,y,z) (*getUP1(x,y) = (unsigned char)(z))
#define orU1(x,y,z)  (*getUP1(x,y) |= (unsigned char)(z))
#define andU1(x,y,z) (*getUP1(x,y) &= (unsigned char)(z))
#define getUP2(x,y)  ((unsigned short __FAR__ *)(((unsigned char __FAR__ *) \
                                (x))+(unsigned long)(y)))
#define getU2(x,y)   ((unsigned short)osdLocal2((unsigned short __FAR__ *)  \
                                getUP1(x,y)))
#define getSU2(x,y)  ((unsigned short)osdSLocal2((unsigned short __FAR__ *) \
                                getUP1(x,y)))
#if (!defined(setU2))
# define setU2(x,y,z) { unsigned short hold = (unsigned short)(z);  \
                        *((unsigned short __FAR__ *)getUP1(x,y))    \
                          = osdLocal2(&hold);                       \
                      }
#endif
#if (!defined(setSU2))
# if (defined(__BORLANDC__) && !defined(_DPT_BIG_ENDIAN))
#  define setSU2(x,y,z) *((unsigned short __FAR__ *)getUP1(x,y)) \
                                = (unsigned short)(z)
# else
#  define setSU2(x,y,z) { unsigned short hold = (unsigned short)(z); \
                         *((unsigned short __FAR__ *)getUP1(x,y))    \
                           = osdSLocal2(&hold);                      \
                        }
# endif
#endif
#define getU3(x,y)   ((unsigned long)osdLocal3((unsigned long __FAR__ *) \
                                getUP1(x,y)))
#if (!defined(setU3))
# if (defined(_DPT_BIG_ENDIAN))
#  define setU3(x,y,z)                                     \
        {   unsigned long hold = z;                        \
            *(getUP1(x,y)) = (unsigned char)(hold >> 16L); \
            *((unsigned short __FAR__ *)(getUP1(x,y) + 1)) \
              = (unsigned short)hold;                      \
        }
# else
#  define setU3(x,y,z) \
        {   unsigned long hold = z;                            \
            *(getUP1(x,y) + 0) = (unsigned char)(hold >> 16) ; \
            *(getUP1(x,y) + 1) = (unsigned char)(hold >> 8L);  \
            *(getUP1(x,y) + 2) = (unsigned char)(hold);        \
        }
# endif
#endif
#define getUP4(x,y)  ((unsigned long __FAR__ *)(((unsigned char __FAR__ *) \
                                (x))+(unsigned long)(y)))
#define getU4(x,y)   ((unsigned long)osdLocal4((unsigned long __FAR__ *)   \
                                getUP1(x,y)))
#define getSU4(x,y)  ((unsigned long)osdSLocal4((unsigned long __FAR__ *)  \
                                getUP1(x,y)))
#if (!defined(setU4))
# define setU4(x,y,z) { unsigned long hold = z;                 \
                        *((unsigned long __FAR__ *)getUP1(x,y)) \
                          = osdLocal4(&hold);                   \
                      }
#endif
#if (!defined(setSU4))
# if (defined(__BORLANDC__) && !defined(_DPT_BIG_ENDIAN))
#  define setSU4(x,y,z) *((unsigned long __FAR__ *)getUP1(x,y)) \
                                = (unsigned long)(z)
# else
#  define setSU4(x,y,z) { unsigned long hold = z;                \
                         *((unsigned long __FAR__ *)getUP1(x,y)) \
                           = osdSLocal4(&hold);                  \
                        }
# endif
#endif
#define getLU2 getSU2
#define setLU2 setSU2
#define getLU4 getSU4
#define setLU4 setSU4
#endif /* __DPTALIGN_H */
