/*	BSDI dptioctl.h,v 1.9 1999/01/15 19:08:18 geertj Exp	*/

/*
 * Copyright (c) 1996-1999 Distributed Processing Technology Corporation
 * All rights reserved.
 *
 * Redistribution and use in source form, with or without modification, are
 * permitted provided that redistributions of source code must retain the
 * above copyright notice, this list of conditions and the following disclaimer.
 *
 * This software is provided `as is' by Distributed Processing Technology and
 * any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose,
 * are disclaimed. In no event shall Distributed Processing Technology be
 * liable for any direct, indirect, incidental, special, exemplary or
 * consequential damages (including, but not limited to, procurement of
 * substitute goods or services; loss of use, data, or profits; or business
 * interruptions) however caused and on any theory of liability, whether in
 * contract, strict liability, or tort (including negligence or otherwise)
 * arising in any way out of the use of this driver software, even if advised
 * of the possibility of such damage.
 *
 * DPT SCSI host adapter pass through handler.
 *
 *      dpt V3.07 1997/08/19 salyzyn@dpt.com
 *              Completed modifications to support dpt_scsi.h and dpt_eata.h
 *              processor independant structure files.
 *
 *      bsdi 1996/06/03 pjd@bsdi.com
 *              file name changes only
 *
 *      BSDI  05/31/96  pjd@bsdi.com
 *      changed call parameters to dptioctl() to conform.
 *
 *      dpt V1.00 1996/03/07 salyzyn@dpt.com
 *
 */

/*
 *      Meant to be included at the bottom of dpt_eata.c
 */

#include        <sys/ioctl.h>
#include        <sys/types.h>
#include        <i386/isa/dpt_sys_info.h>
/*
 *      Included here as hard coded. Done because other necessary include
 *      files utilize C++ comment structures which make them a nuisance to
 *      included here just to pick up these three typedefs.
 */
typedef unsigned long   DPT_TAG_T;
typedef unsigned long   DPT_MSG_T;
typedef unsigned long   DPT_RTN_T;

#include        <i386/isa/dpt_osd_unix.h>
#if (!defined(DPT_DEBUG_FLAGS) && !(DPT_DEBUG_FLAGS))
# undef DPT_DEBUG
#endif

#define dptunit(dev)     dv_unit(dev)

STATIC DptHa_t *
dpt_get_sc (dev_t dev)
{       int             unit = dptunit(dev);
        DptHa_t *       sc;

        if ((dptcd.cd_devs == (void **)NULL)
	 || ((sc = (DptHa_t *)(dptcd.cd_devs[0])) == (DptHa_t *)NULL)) {
                sc = DptHa;
	}
        for (; (unit > 0) && (sc); --unit)
                sc = sc->ha_next_parent;
        return (sc);
}

STATIC int
dptopen(dev_t dev, int flags, int ifmt, struct proc *p)
{
#       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_CALL))
                printf("dptopen(%x(%x), %x, %x, %x)",
                    dev, dpt_get_sc(dev), flags, ifmt, p);
#       endif

        if (dpt_get_sc (dev)) {
#               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_CALL))
                        printf (" = 0\n");
#               endif
                return (0);
        }
#       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_CALL))
                printf (" = ENXIO\n");
#       endif
        return (ENXIO);
}

/*----------------------------------------------------------------------*/
/*                          Function dptioctl                           */
/*----------------------------------------------------------------------*/
/* The parameters passed to this function are :                         */
/*     dev  : Device number.                                            */
/*     cmd  : Ioctl Command                                             */
/*     data : User Argument Passed In.                                  */
/*     flag : Mode Parameter                                            */
/*     proc : Process Parameter                                         */
/*                                                                      */
/* This function is the user interface into this adapter driver         */
/*                                                                      */
/* Return : zero if OK, error code if not                               */
/*----------------------------------------------------------------------*/

STATIC int
dptioctl(dev, cmd, data, flag, p)
        dev_t                   dev;
        u_long                  cmd;
        caddr_t                 data;
        int                     flag;
        struct proc *           p;
{       int                     i, j, error = 0;
        DptHa_t *               sc = dpt_get_sc (dev);
        u_char                  c;
        DptCcb_t *              ccb;

#       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_CALL))
                printf("dptioctl(%x(%x), %x, %x, %x, %x)\n",
                    dev, sc, cmd, data, flag, p);
#       endif

#       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
            if (sc)
#       endif
        switch(cmd) {
#ifdef DPT_DEBUG
            case DPT_DEBUG & 0x0000FFFF:
            case DPT_DEBUG:
                sc->ha_debug = (int)data;
                return (0);
#endif
            case DPT_STATINFO:
                printf ("\nI/O Pending :%d\n", sc->ha_Total_IO_Pending);
                return (0);

            case DPT_CLRSTAT:
                return (0);

            case EATAUSRCMD & 0x0000FFFF:
            case EATAUSRCMD: {
                caddr_t         addr;
                caddr_t         dataDMA;
                int             len;
                eataCP_S        EataCp;
                u_int           aphys;
                scp_t *         scp;
                extern scp_t *  spi_create_unattached_scp (scp_t *      scp,
                                                           spi_hba_t *  hba,
                                                           targ_t *     targ,
                                                           int          tid,
                                                           int          lun,
                                                           size_t       hpsize,
                                                           int          flags);
                extern void     spi_destroy_scp (scp_t * scp);

                if (error = suser(p->p_ucred, &p->p_acflag)) {
#                       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
                                if (sc->ha_debug) {
                                        printf ("EATAUSRCMD !suser\n");
                                }
#                       endif
                        return (error);
                }

                /*
                 *      Get Incoming EataCp
                 */
                if (cmd & 0xFFFF0000) {
                        (void)bcopy (data, &EataCp, eataCP_size);
                } else if (error = copyin(data, &EataCp, eataCP_size)) {
#                       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
                                if (sc->ha_debug) {
                                        printf ("EATAUSRCMD !copyin EataCP\n");
                                }
#                       endif
                        return (error);
                }

                scp = spi_create_unattached_scp ((scp_t *)NULL, &(sc->ha_hba),
                    (targ_t *)NULL, -2, 0, 0, 0);

                /*
                 *      Initialize the CCB with it's real parameters.
                 */
                len = *eataCP_getDataLengthPtr(&EataCp);
                addr = 0;
                if (len
                    && (eataCP_getFlags(&EataCp) & (CP_DATA_OUT|CP_DATA_IN))) {
                        if (!(addr = malloc (len, M_TEMP, M_WAITOK))) {
                                spi_destroy_scp (scp);
#                               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
                                        if (sc->ha_debug) {
                                                printf ("EATAUSRCMD !malloc buffer\n");
                                        }
#                               endif
                                return (ENOMEM);
                        }
                        if ((eataCP_getFlags(&EataCp) & CP_DATA_OUT)
                         && (error = copyin (
                            (caddr_t)*eataCP_getDataAddrPtr(&EataCp),
                            addr, len))) {
                                free (addr, M_TEMP);
                                spi_destroy_scp (scp);
#                               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
                                        if (sc->ha_debug) {
                                                printf ("EATAUSRCMD copyin data\n");
                                        }
#                               endif
                                return (error);
                        }
                        aphys = osdPhys(addr);
                        if (is_isa(&(sc->ha_Config)) && (aphys >= ISA_ADDR)) {
                                aphys = dpt_bounce (sc, ccb, addr, len,
                                         (eataCP_getFlags(&EataCp) & CP_DATA_IN)
                                        ? B_READ : 0);
                        }
                        dataDMA = (caddr_t)*eataCP_getDataAddrPtr(&EataCp);
                        *eataCP_getDataAddrPtr(&EataCp) = osdSwap4(aphys);
                        eataCP_setDataLength(&EataCp, len);
                } else {
                        eataCP_andFlags (&EataCp, ~(CP_DATA_IN|CP_DATA_OUT));
                }
                /*
                 *      Send the command out
                 */
                scp->scp_data = (void *)&EataCp;
                if (eataCP_getFlags(&EataCp) & CP_DATA_IN) {
                        scp->scp_flags |= SCP_READ;
                }
                scp->scp_flags |= SCP_NOBP|SCP_WAITIO;
                scsi_start_with_wait(scp);
                /*
                 *      Cleanup
                 */
                if (addr) {
                        if (eataCP_getFlags(&EataCp) & CP_DATA_IN) {
                                error = copyout (addr, dataDMA, len);
                        }
                        free (addr, M_TEMP);
                        if (error) {
                                spi_destroy_scp (scp);
#                               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_VERBOSE))
                                        if (sc->ha_debug) {
                                                printf ("EATAUSRCMD copyout\n");
                                        }
#                               endif
                                return (error);
                        }
                }
                /*
                 *      This is purely optional behavior, none of our
                 * other drivers support this (but non of our apps use it
                 * yet as well).
                 */
                if (*eataCP_getReqSenseAddrPtr(&EataCp)
                 && (len = eataCP_getReqSenseLen(&EataCp))
                 && (eataCP_getFlags(&EataCp) & CP_REQ_SENSE)) {
                        if (len > sizeof(scp->scp_sn))
                                len = sizeof(scp->scp_sn);
                        error = copyout (&(scp->scp_sn),
                            (caddr_t)*(eataCP_getReqSenseAddrPtr(&EataCp)),
                            len);
                }
                /*
                 *      Copy our Status Packet information into the user's
                 *      version.
                 */
                if (cmd & 0xFFFF0000) {
                        ((EATA_CP *)data)->TargetStatus = 0;
                        ((EATA_CP *)data)->HostStatus = 0;
                        if (scp->scp_status & HBA_STATUS) {
                                ((EATA_CP *)data)->HostStatus = scp->scp_status;
                        } else {
                                ((EATA_CP *)data)->TargetStatus=scp->scp_status;
                        }
                } else {c = 0;
                        if ((scp->scp_status & HBA_STATUS) == 0) {
                                c = scp->scp_status;
                        }
                        error = copyout(&c,
                            &((EATA_CP *)(*((int **)data)))->TargetStatus,
                            sizeof(char));
                        c = 0;
                        if (scp->scp_status & HBA_STATUS) {
                                c = scp->scp_status;
                        }
                        error = copyout(&c,
                            &((EATA_CP *)(*((int **)data)))->HostStatus,
                            sizeof(char));
                }
                spi_destroy_scp (scp);
                return (error); }

            case DPT_SIGNATURE:
                if (cmd & 0xFFFF0000) {
                        (void)bcopy ((caddr_t)(&dpt_sig), data,
                            sizeof(dpt_sig_S));
                        return (0);
                }
            case DPT_SIGNATURE & 0x0000FFFF:
                return (copyout ((caddr_t)(&dpt_sig), *((int **)data),
                    sizeof(dpt_sig_S)));

            case DPT_NUMCTRLS & 0x0000FFFF:
            case DPT_NUMCTRLS: {
                DptHa_t *       ha_p;

                i = 0;
                ha_p = sc->ha_parent;
                do {
                        ++i;
                } while (ha_p = ha_p->ha_next_parent);
                *((int *)data) = i;
                if ((cmd & 0xFFFF0000) == 0) {
                        error = copyout (&i, *((int **)data), sizeof(int));
                }
                return (error); }

            case DPT_CTRLINFO & 0x0000FFFF:
            case DPT_CTRLINFO: {
                HbaInfo         CtlrInfo;
                DptHa_t *       ha_p = sc->ha_parent;

                bzero (&CtlrInfo, sizeof(CtlrInfo));
                CtlrInfo.id[0] = eataRdConfig_getScsiIDs(&(ha_p->ha_Config))[3];
                CtlrInfo.id[1] = eataRdConfig_getScsiIDs(&(ha_p->ha_Config))[2];
                CtlrInfo.id[2] = eataRdConfig_getScsiIDs(&(ha_p->ha_Config))[1];
                CtlrInfo.id[3] = eataRdConfig_getScsiIDs(&(ha_p->ha_Config))[0];
                CtlrInfo.vect = (eataRdConfig_getFlag2(&(ha_p->ha_Config))
                    & RDCFG_IRQ_NUM)
                        ? (eataRdConfig_getFlag2(&(ha_p->ha_Config)))
                        : (eataRdConfig_getIRQ(&(ha_p->ha_Config)));
                CtlrInfo.base = ha_p->ha_Base;
                CtlrInfo.qdepth = eataRdConfig_getQueueSize(&(ha_p->ha_Config));
                CtlrInfo.SGsize = eataRdConfig_getSgSize(&(ha_p->ha_Config));
                CtlrInfo.eataVersion
                    = eataRdConfig_getVersion(&(ha_p->ha_Config));
                CtlrInfo.cpLength
                    = eataRdConfig_getCpLength(&(ha_p->ha_Config));
                CtlrInfo.spLength
                    = eataRdConfig_getSpLength(&(ha_p->ha_Config));
                CtlrInfo.drqNum = (eataRdConfig_getFlag1(&(ha_p->ha_Config))
                    & RDCFG_DRQ_VALID)
                        ? "\0\7\6\5"[eataRdConfig_getFlag2(&(ha_p->ha_Config)) >> 6]
                        : -1;
                CtlrInfo.eataflag1 = eataRdConfig_getFlag1(&(ha_p->ha_Config));
                CtlrInfo.eataflag2 = eataRdConfig_getFlag2(&(ha_p->ha_Config));
                CtlrInfo.maxChannel
                    = (eataRdConfig_getMaxChanID(&(ha_p->ha_Config)) >> 5);
                CtlrInfo.maxID
                    = (eataRdConfig_getMaxChanID(&(ha_p->ha_Config)) & 0x1F);
                CtlrInfo.maxLUN = eataRdConfig_getMaxLun(&(ha_p->ha_Config));
                CtlrInfo.HbaBusType = is_isa(&(ha_p->ha_Config))
                    ? 0 : (is_eisa(&(ha_p->ha_Config)) ? 1 : 2);
                CtlrInfo.RaidNum = eataRdConfig_getRaidNum(&(ha_p->ha_Config));
                i = 0;
                do {
                    for (ccb = ha_p->ha_CCB; ccb && ccb->ccb_Device;
                        ccb=ccb->ccb_next)
                            ++i;
                } while (ha_p = ha_p->ha_next);
                CtlrInfo.njobs = i;
                if (cmd & 0xFFFF0000) {
                        bcopy (&CtlrInfo, data, sizeof(CtlrInfo));
                } else {
                        error = copyout (&CtlrInfo, data, sizeof(CtlrInfo));
                }
                return (error); }

            case DPT_SYSINFO & 0x0000FFFF:
            case DPT_SYSINFO: {
                sysInfo_S       Info;
                caddr_t         c_addr;
                /* Kernel Specific ptok `hack' */
                extern int      basemem;
#               define          ptok(a) (((a) >= basemem) \
                                ? ISA_HOLE_VADDR(a) : ((char *)(a) + KERNBASE))

                bzero (&Info, sizeof(Info));

                outb (0x70, 0x12);
                i = inb(0x71);
                j = i >> 4;
                if (i == 0x0f) {
                        outb (0x70, 0x19);
                        j = inb (0x71);
                }
                Info.drive0CMOS = j;

                j = i & 0x0f;
                if (i == 0x0f) {
                        outb (0x70, 0x1a);
                        j = inb (0x71);
                }
                Info.drive1CMOS = j;

                Info.numDrives = *((char *)ptok(0x475));

                Info.processorFamily = dpt_sig.dsProcessorFamily;
                switch (cpu) {
                case CPU_386SX: case CPU_386:
                        Info.processorType = PROC_386; break;
                case CPU_486SX: case CPU_486:
                        Info.processorType = PROC_486; break;
                case CPU_586:
                        Info.processorType = PROC_PENTIUM; break;
                case CPU_686:
                        Info.processorType = PROC_SEXIUM; break;
                }
                Info.osType = OS_BSDI_UNIX;
                Info.osMajorVersion = osrelease[0] - '0';
                Info.osMinorVersion = osrelease[2] - '0';
                /* Info.osRevision = 0; */
                /* Info.osSubRevision = 0; */
                Info.busType = is_isa(&(sc->ha_Config)) ? SI_ISA_BUS
                           : (is_eisa(&(sc->ha_Config)) ? SI_EISA_BUS
                                                        : SI_PCI_BUS);
                Info.flags = SI_CMOS_Valid | SI_NumDrivesValid
                        | SI_OSversionValid |SI_BusTypeValid;

                /* Go Out And Look For SmartROM */
                for(i = 0; i < 3; ++i) {
                        int     k;

                        if (i == 0) {
                                j = 0xC8000;
                        } else if (i == 1) {
                                j = 0xD8000;
                        } else {
                                j = 0xDC000;
                        }
                        c_addr = ptok(j);
                        if (*((unsigned short *)c_addr) != 0xAA55) {
                                continue;
                        }
                        if (*((unsigned long *)(c_addr + 6)) != 0x202053) {
                                continue;
                        }
                        if (*((unsigned long *)(c_addr + 10)) != 0x545044) {
                                continue;
                        }
                        c_addr += 0x24;
                        for (k = 0; k < 64; ++k) {
                                if ((*((unsigned char *)(c_addr++)) == ' ')
                                 && (*((unsigned char *)(c_addr)) == 'v')) {
                                        break;
                                }
                        }
                        if (k < 64) {
                                Info.smartROMMajorVersion
                                    = *((unsigned char *)(c_addr += 3)) - '0';
                                Info.smartROMMinorVersion
                                    = *((unsigned char *)(c_addr += 2));
                                Info.smartROMRevision
                                    = *((unsigned char *)(++c_addr));
                                Info.flags |= SI_SmartROMverValid;
                                break;
                        }
                }
                if (i >= 3) {
                        Info.flags |= SI_NO_SmartROM;
                }
                /* Get The Conventional Memory Size From CMOS */
                outb (0x70, 0x16);
                j = inb (0x71);
                j <<= 8;
                outb (0x70, 0x15);
                j |= inb(0x71);
                Info.conventionalMemSize = j;

                /* Get The Extended Memory Found At Power On From CMOS */
                outb (0x70, 0x31);
                j = inb (0x71);
                j <<= 8;
                outb (0x70, 0x30);
                j |= inb(0x71);
                Info.extendedMemSize = j;
                Info.flags |= SI_MemorySizeValid;

#               if (defined(THIS_IS_BROKEN))
                /* If There Is 1 or 2 Drives Found, Set Up Drive Parameters */
                if (Info.numDrives > 0) {
                        /*
                         *      Get The Pointer From Int 41 For The First
                         *      Drive Parameters
                         */
                        j = ((unsigned)(*((unsigned short *)ptok(0x104+2))) << 4)
                           + (unsigned)(*((unsigned short *)ptok(0x104+0)));
                        /*
                         * It appears that SmartROM's Int41/Int46 pointers
                         * use memory that gets stepped on by the kernel
                         * loading. We no longer have access to this
                         * geometry information but try anyways (!?)
                         */
                        Info.drives[0].cylinders = *((unsigned char *)ptok(j));
                        ++j;
                        Info.drives[0].cylinders += ((int)*((unsigned char *)
                            ptok(j))) << 8;
                        ++j;
                        Info.drives[0].heads = *((unsigned char *)ptok(j));
                        j += 12;
                        Info.drives[0].sectors = *((unsigned char *)ptok(j));
                        Info.flags |= SI_DriveParamsValid;
                        if ((Info.drives[0].cylinders == 0)
                         || (Info.drives[0].heads == 0)
                         || (Info.drives[0].sectors == 0)) {
                                Info.flags &= ~SI_DriveParamsValid;
                        }
                        if (Info.numDrives > 1) {
                                /*
                                 *      Get The Pointer From Int 46 For The
                                 *      Second Drive Parameters
                                 */
                                j = ((unsigned)(*((unsigned short *)ptok(0x118+2))) << 4)
                                   + (unsigned)(*((unsigned short *)ptok(0x118+0)));
                                Info.drives[1].cylinders = *((unsigned char *)
                                    ptok(j));
                                ++j;
                                Info.drives[1].cylinders += ((int)
                                    *((unsigned char *)ptok(j))) << 8;
                                ++j;
                                Info.drives[1].heads = *((unsigned char *)
                                    ptok(j));
                                j += 12;
                                Info.drives[1].sectors = *((unsigned char *)
                                    ptok(j));
                                if ((Info.drives[1].cylinders == 0)
                                 || (Info.drives[1].heads == 0)
                                 || (Info.drives[1].sectors == 0)) {
                                        Info.flags &= ~SI_DriveParamsValid;
                                }
                        }
                }
#               endif
                /* Copy Out The Info Structure To The User */
                if (cmd & 0xFFFF0000) {
                        bcopy (&Info, data, sizeof(Info));
                } else {
                        error = copyout (&Info, data, sizeof(Info));
                }
                return (error); }

                /* Set The Timeout Flag */
            case DPT_TIMEOUT:
                return (0);

                /* Get The BlinkLED State */
            case DPT_BLINKLED:
                j = splbio();
                /*
                 * This Function Checks For The BLINK LED State For An Adapter
                 * Found At the port
                 * Return : Blink State If In Blink LED State, 0 Otherwise
                 */
                {       int     Attempts = 10;
                        long    BlinkIndicator = 0x42445054, State = 0x12345678;
                        long    OldState = 0;

                        i = 0;
                        while ((Attempts--) && (State != OldState)) {
                                OldState = State;
                                State = inl (sc->ha_Base + HA_ERROR);
                        }

                        if ((State == OldState) && (State == BlinkIndicator)) {
                                i = inb (sc->ha_Base + HA_DMA_BASE + 3);
                        }
                }
                splx(j);
                if (cmd & 0xFFFF0000) {
                        bcopy ((caddr_t)(&i), data, sizeof(i));
                } else {
                        error = copyout (&i, data, sizeof(i));
                }
                break;
        }
        return (EINVAL);
#undef sc
}
