/*	BSDI bt812.h,v 1.2 1996/07/25 22:09:53 prb Exp */
/* WILDBOAR $Wildboar: bt812.h,v 1.5 1996/02/13 13:01:56 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * Brooktree Bt812 NTSC/PAL to RGB/YCrCb Decoder
 */

#define	BT812_ADDR	0
#define	BT812_DATA	2
#define	PX0072_DATA	8
#define	PX0072_ADDR	9

#define	BT812_CR0	0

#define		BT812_CR0_VID0_Y	(0 << 5)
#define		BT812_CR0_VID1_Y	(1 << 5)
#define		BT812_CR0_VID2_Y	(2 << 5)
#define		BT812_CR0_VID3_Y	(3 << 5)
#define		BT812_CR0_VID0_C	(0 << 3)
#define		BT812_CR0_VID1_C	(1 << 3)
#define		BT812_CR0_VID2_C	(2 << 3)
#define		BT812_CR0_VID3_C	(3 << 3)

#define	BT812_CR2	2
#define		BT812_CR2_VIDEO_PRESENT	(1 << 7)
#define		BT812_CR2_VIDEO_STABLE	(1 << 6)
#define		BT812_CR2_Y_OVERFLOW	(1 << 5)
#define		BT812_CR2_C_OVERFLOW	(1 << 4)
#define		BT812_CR2_VALID_COLOR	(1 << 3)

#define	BT812_CR3	3
#define		BT812_CR3_OFMT_RGB_24	(0 << 5)
#define		BT812_CR3_OFMT_RGB_16	(2 << 5)
#define		BT812_CR3_OFMT_RGB_15	(3 << 5)
#define		BT812_CR3_OFMT_YC_24	(5 << 5)
#define		BT812_CR3_OFMT_YC_16	(6 << 5)
#define		BT812_CR3_GAMMA_RM_NONE	(0 << 3)
#define		BT812_CR3_GAMMA_RM_2_2	(1 << 3)
#define		BT812_CR3_GAMMA_RM_2_8	(2 << 3)

#define	BT812_CR4	4
#define		BT812_CR4_POWER_DOWN	(1 << 7)
#define		BT812_CR4_MODE_COLBAR	(1 << 6)
#define		BT812_CR4_AGC_DISABLE	(1 << 5)
#define		BT812_CR4_CHAGC_DISABLE	(1 << 4)
#define		BT812_CR4_LOW_COLOR_RM	(1 << 3)

#define	BT812_CR5	5
#define		BT812_CR5_IFMT_NTSC	0x00
#define		BT812_CR5_IFMT_PAL	0x74
#define		BT812_CR5_CABLE_YC	(1 << 7)
#define		BT812_CR5_MONO		(1 << 1)

#define	BT812_CR6	6
#define		BT812_CR6_XTAL1		(0 << 6)
#define		BT812_CR6_XTAL2		(1 << 6)

#define	BT812_CR7	7
#define		BT812_CR7_FIELD_STROBE	(1 << 7)
#define		BT812_CR7_FRAME_STROBE	(1 << 6)
#define		BT812_CR7_CAPTURE_STAT	(1 << 4)
#define		BT812_CR7_PIXEL_OENABLE	(1 << 3)
#define		BT812_CR7_CTRL_OENABLE	(1 << 2)

#define	BT812_CR8	8
#define	BT812_CR9	9
#define	BT812_CRA	0xa
#define	BT812_CRB	0xb

#define	BT812_HCLOCK_L	0xc
#define	BT812_HCLOCK_H	0xd
#define	BT812_HDELAY_L	0xe
#define	BT812_HDELAY_H	0xf
#define	BT812_APIXEL_L	0x10
#define	BT812_APIXEL_H	0x11
#define	BT812_VDELAY_L	0x12
#define	BT812_VDELAY_H	0x13
#define	BT812_ALINES_L	0x14
#define	BT812_ALINES_H	0x15
#define	BT812_SC_L	0x16
#define	BT812_SC_M	0x17
#define	BT812_SC_H	0x18
#define	BT812_AGC_DELAY	0x19
#define	BT812_BURST_DELAY	0x1a
#define	BT812_SRC_L	0x1b
#define	BT812_SRC_H	0x1c
#define	BT812_CR1D	0x1d
#define	BT812_RESET	0xff

/*
 * bt812.h,v
 * Revision 1.2  1996/07/25 22:09:53  prb
 * Add BSDI rcs lines
 *
 * Revision 1.1  1996/07/25 18:44:27  prb
 * i386 specic pcmcia code from wildboar
 *
 * Revision 1.5  1996/02/13  13:01:56  shigeya
 * WB960213
 *
 * Revision 1.4  1996/02/11  07:29:30  shigeya
 * WB960211
 *
 * Revision 1.3  1996/02/11  07:03:44  shigeya
 * WB960211pre
 *
 * Revision 1.1  1995/07/31  10:22:01  shigeya
 * WB950727A
 *
 * Revision 1.1  1995/07/31  08:31:39  shigeya
 * Wildboar 950727A
 *
 * Revision 1.2  1995/07/26  01:41:33  shigeya
 * Wildboar 950726
 *
 * Revision 1.3  1995/05/26  09:15:29  shigeya
 * First version, with COPYRIGHT tags
 *
 * Revision 1.2  1995/05/26  07:16:32  shigeya
 * Wildboar @950526
 *
 * Revision 1.1  1995/04/28  09:45:38  shigeya
 * Wildboar 950424 new files
 */
