/*	BSDI db86082.h,v 1.2 1996/07/25 22:09:53 prb Exp */
/* WILDBOAR $Wildboar: db86082.h,v 1.5 1996/02/13 13:01:57 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * Databook DB86082(TCIC-2)/DB86082A(TCIC-2/N)
 */

/*
 * Primary registers
 */
#define	TCIC_DATA	0
#define	TCIC_ADDR	2
#define	TCIC_SCTRL	6
#define	TCIC_SSTAT	7
#define	TCIC_MODE	8
#define	TCIC_PWR	9
#define	TCIC_EDC	0xa
#define	TCIC_ICSR	0xc
#define	TCIC_IENA	0xd
#define	TCIC_AUX	0xe

/*
 * Indirect registers
 *
 *	R R 
 *	0 0 Z Z Z Z S Z T Z	Socket Control, T = SCF1/SCF2, S = socket #
 *	0 1 Z Z W W W T T Z	Memory Window, TT = type, WWW = window #
 *	1 0 Z Z Z Z W W T Z	I/O Window, T = type, WW = window #
 */

#define	TCIC_SCF_ID		(0 << 8)
#define	TCIC_MEM_ID		(1 << 8)
#define	TCIC_IO_ID		(2 << 8)

#define	TCIC_SCF1(sock)		(TCIC_SCF_ID | ((sock) << 3) | (0 << 1))
#define	TCIC_SCF2(sock)		(TCIC_SCF_ID | ((sock) << 3) | (1 << 1))

#define	TCIC_MEXT(w)		(TCIC_MEM_ID | ((w) << 3) | (0 << 1)) 
#define	TCIC_MBASE(w)		(TCIC_MEM_ID | ((w) << 3) | (1 << 1)) 
#define	TCIC_MMAP(w)		(TCIC_MEM_ID | ((w) << 3) | (2 << 1)) 
#define	TCIC_MCTL(w)		(TCIC_MEM_ID | ((w) << 3) | (3 << 1)) 

#define	TCIC_IOBASE(w)		(TCIC_IO_ID | ((w) << 2) | (0 << 1))
#define	TCIC_IOCTL(w)		(TCIC_IO_ID | ((w) << 2) | (1 << 1))

/*
 * Auxiliary registers
 */
#define	TCIC_TCTL	0
#define	TCIC_PCTL	1
#define	TCIC_WCTL	2
#define	TCIC_EXTERN	3
#define	TCIC_PDATA	4
#define	TCIC_SYSCFG	5
#define	TCIC_ILOCK	6
#define	TCIC_TEST	7

#define	ADDR_REG	0x80000000
#define	ADDR_SS_MASK	0x70000000
#define	ADDR_SS_SHIFT	28
#define	ADDR_INDREG	0x08000000
#define	ADDR_IO		0x04000000
#define	ADDR_CA_MASK	0x03ffffff
#define	ADDR_IA_MASK	0x000003ff

/*
 * For byte access to part of TCIC_ADDR containing socket selection bits.
 */
#define	TCIC_SSEL	5

#define		SSEL_SS_SHIFT	4
#define		SSEL_SS_MASK	(7 << SSEL_SS_SHIFT)

#define	SCTRL_RESET	0x80
#define	SCTRL_EDC	0x40
#define		SCTRL_EDC_SDLC		0x00
#define		SCTRL_EDC_CKSUM		0x40
#define	SCTRL_INCMODE	0x30
#define		SCTRL_INCMODE_BHOLD	0x00
#define		SCTRL_INCMODE_WHOLD	0x10
#define		SCTRL_INCMODE_WINC	0x20
#define		SCTRL_INCMODE_NATURAL	0x30
#define	SCTRL_ENA	0x01

#define	SSTAT_CD	(1 << 7)
#define	SSTAT_WP	(1 << 6)
#define	SSTAT_RDY	(1 << 5)
#define	SSTAT_LBAT2	(1 << 4)
#define	SSTAT_LBAT1	(1 << 3)
#define	SSTAT_PROGTIME	(1 << 2)
#define	SSTAT_10US	(1 << 1)
#define	SSTAT_6US	(1 << 0)

#define	MODE_AUXSEL_MASK	0xe0
#define	MODE_PGMWORD		0x10
#define	MODE_PGMDBW		0x08
#define	MODE_PGMCE		0x04
#define	MODE_PGMRD		0x02
#define	MODE_PGMWR		0x01
#define	MODE_NORMAL		0x00

#define	PWR_CLIMSTAT		0x80
#define	PWR_CLIMENA		0x40
#define	PWR_VPP1		0x10
#define	PWR_VPP0		0x08
#define	PWR_VCC1		0x02
#define	PWR_VCC0		0x01

#define	ICSR_IOCHK		0x80
#define	ICSR_CDCHG		0x40
#define	ICSR_ERR		0x20
#define	ICSR_PROGTIME		0x10
#define	ICSR_ILOCK		0x08
#define	ICSR_SET		0x02
#define	ICSR_CLEAR		0x01
#define ICSR_WRSEL_NOP		0x00
#define ICSR_WRSEL_SELCLR(bits)	((bits)|ICSR_CLEAR)
#define ICSR_WRSEL_SELSET(bits)	((bits)|ICSR_SET)
#define ICSR_WRSEL_WALL(bits)	((bits)|ICSR_CLEAR|ICSR_SET)

#define	IENA_CDCHG		0x40
#define	IENA_ERR		0x20
#define	IENA_PROGTIME		0x10
#define	IENA_ILOCK		0x08
#define	IENA_CFG_MASK		0x03
#define		IENA_CFG_HI_Z		0x00
#define		IENA_CFG_OD		0x01
#define		IENA_CFG_ACT_LOW	0x02
#define		IENA_CFG_ACT_HIGH	0x03

#define	TCTL_10US_MASK		0xff00
#define	TCTL_6US_MASK		0x00ff

#define	WCTL_LCD		0x8000
#define	WCTL_LWP		0x4000
#define	WCTL_LRDY		0x2000
#define	WCTL_LLBAT2		0x1000
#define	WCTL_LLBAT1		0x0800
#define	WCTL_CE			0x0400
#define	WCTL_RD			0x0200
#define	WCTL_WR			0x0100

#define	WCTL_SRC		0x0080
#define	WCTL_SENSE		0x0040
#define	WCTL_ASYNC		0x0020
#define	WCTL_COUNT_MASK		0x001f

#define	SYSCFG_ACC		0x8000
#define	SYSCFG_AUTOBUSY		0x4000
#define	SYSCFG_MPSENS		0x2000
#define	SYSCFG_MPSEL_MASK	0x0e00
#define	SYSCFG_NOPDN		0x0100
#define	SYSCFG_ICSXB		0x0080
#define	SYSCFG_MCSXB		0x0040
#define	SYSCFG_IO1723		0x0020
#define	SYSCFG_MCSFULL		0x0010
#define	SYSCFG_ISEL_MASK	0x000f

/*
 * Possible level selection for SYSCFG register in vector format.
 * Note that they may be, but not necessarily correspond one to one to
 * the h/w interrupt levels.
 *
 * Possible values are SKTIRQ(1), IRQ3, IRQ4, IRQ5, IRQ6, IRQ7, IRQ10, IRQ14,
 * which convert into:
 *
 *	F E D C|B A 9 8|7 6 5 4|3 2 1 0
 *      0 1 0 0|0 1 0 0|1 1 1 1|1 0 1 0 = 0x44fa
 *
 * in bit vector format.
 */
#define	TCIC_ISELVEC		0x44fa

#define	ILOCK_CHIPID_MASK	0xff00
#define	ILOCK_HOLD_MASK		0x00c0
#define		ILOCK_HOLD_MIN		0x0000
#define		ILOCK_HOLD_CCLK		0x00c0
#define	ILOCK_CWAITSNS		0x0020
#define	ILOCK_CWAIT		0x0010
#define	ILOCK_CRESENA		0x0008
#define	ILOCK_CRESET		0x0004
#define	ILOCK_SENSE		0x0002
#define	ILOCK_OUT		0x0001

#define	TEST_DIAG		0x8000
#define	TEST_CSTP		0x4000
#define	TEST_BSTP		0x2000
#define	TEST_ISTP		0x1000
#define	TEST_DRIVECDB		0x0800
#define	TEST_EXTA		0x0400
#define	TEST_VCTL		0x0200
#define	TEST_WAIT		0x0080
#define	TEST_OUT1		0x0020
#define	TEST_ENA		0x0008
#define	TEST_CEN		0x0002
#define	TEST_AEN		0x0001

#define	MBASE_4K		0x4000
#define	MBASE_ADDR_MASK		0x0fff

#define	MMAP_REG		0x8000
#define	MMAP_OFF_MASK		0x3fff

#define	MCTL_ENA		0x8000
#define	MCTL_SS_MASK		0x7000
#define	MCTL_SS_SHIFT		12
#define	MCTL_B8			0x0800
#define	MCTL_EDC		0x0400
#define	MCTL_KE			0x0200
#define	MCTL_ACC		0x0100
#define	MCTL_WP			0x0080
#define	MCTL_QUIET		0x0040
#define	MCTL_WSCNT_MASK		0x001f

#define	IOCTL_ENA		0x8000
#define	IOCTL_SS_MASK		0x7000
#define	IOCTL_SS_SHIFT		12
#define	IOCTL_B8		0x0800
#define	IOCTL_B16		0x0400
#define	IOCTL_TINY		0x0200
#define	IOCTL_ACC		0x0100
#define	IOCTL_1K		0x0080
#define	IOCTL_QUIET		0x0040
#define	IOCTL_PASS16		0x0020
#define	IOCTL_WSCNT_MASK	0x001f

#define	SCF1_HD7IDE		0x8000
#define	SCF1_DELWR		0x4000
#define	SCF1_INPACK		0x2000
#define	SCF1_SPKR		0x1000
#define	SCF1_IOSTS		0x0800
#define	SCF1_DMA		0x0200
#define	SCF1_ATA		0x0080
#define	SCF1_IRDY		0x0040
#define	SCF1_PCVT		0x0020
#define	SCF1_IRQOCG		0x0010
#define	SCF1_ISEL_MASK		0x000f

#define	SCF2_MCD		SSTAT_CD
#define	SCF2_MWP		SSTAT_WP
#define	SCF2_MRDY		SSTAT_RDY
#define	SCF2_MLBAT2		SSTAT_LBAT2
#define	SCF2_MLBAT1		SSTAT_LBAT1
#define	SCF2_MDBR		0x0004
#define	SCF2_IDBR		0x0002
#define	SCF2_RI			0x0001
#define	SCF2_MALL		(SCF2_MCD|SCF2_MWP|SCF2_MRDY|SCF2_MLBAT2|SCF2_MLBAT1)

#define	SCF2_BR_DEFAULT		0
#define	SCF2_BR_ALL_8		SCF2_MDBR
#define	SCF2_BR_ALL_PCMCIA	SCF2_IDBR
#define	SCF2_BR_ALL_16		(SCF2_IDBR|SCF2_MDBR)

/*
 * db86082.h,v
 * Revision 1.2  1996/07/25 22:09:53  prb
 * Add BSDI rcs lines
 *
 * Revision 1.1  1996/07/25 18:44:27  prb
 * i386 specic pcmcia code from wildboar
 *
 * Revision 1.5  1996/02/13  13:01:57  shigeya
 * WB960213
 *
 * Revision 1.4  1996/02/11  07:29:30  shigeya
 * WB960211
 *
 * Revision 1.3  1996/02/11  07:03:45  shigeya
 * WB960211pre
 *
 * Revision 1.1  1995/07/31  10:22:02  shigeya
 * WB950727A
 *
 * Revision 1.1  1995/07/31  08:31:39  shigeya
 * Wildboar 950727A
 *
 * Revision 1.2  1995/07/26  01:41:34  shigeya
 * Wildboar 950726
 *
 * Revision 1.3  1995/05/26  09:15:30  shigeya
 * First version, with COPYRIGHT tags
 *
 * Revision 1.2  1995/05/26  07:16:33  shigeya
 * Wildboar @950526
 *
 * Revision 1.1  1995/04/28  09:45:38  shigeya
 * Wildboar 950424 new files
 */
