/*	BSDI i82365sl.h,v 1.3 1999/08/26 22:11:11 prb Exp */
/* WILDBOAR $Wildboar: i82365sl.h,v 1.6 1996/03/01 06:02:50 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/* Intel 82365SL PCIC Controller */

#define	PCIC_NPORTS	2	/* I/O port size */

#define	PCIC_PGSZ	(1 << 12)

#define	PCIC_IRR	0	/* Identification and revision */
#define	PCIC_IDREV	0	/* Identification and revision */
#define	PCIC_ISR	1	/* Interface status */
#define		ST_VPPVALID	0x80
#define		ST_POWERED	0x40
#define		ST_READY	0x20
#define		ST_WPROT	0x10
#define		ST_OCUP1	0x08
#define		ST_OCUP0	0x04
#define		ST_BVD2		0x02
#define		ST_BVD1		0x01
#define		ST_STSRI	0x01
#define		ST_OCCUPIED	(ST_OCUP1|ST_OCUP0)
#define	PCIC_PWRCTL	2	/* Power control */
#define		PC_OENABLE	0x80	/* Output enable */
#define		PC_DISRSTDRV	0x40	/* Disable RESETDRV */
#define		PC_AUTOSW	0x20	/* Automatic power switching */
#define		PC_CENABLE	0x10	/* Card enable */
#define		PC_VCC_5V	PC_CENABLE
#define		PC_VCC_3V	0x18	/* for i82365sl DF */
#define		PC_VPPALL_MASK	0x0f	/* Entire VPP field */
#define		PC_VPP2_MASK	0x0c
#define		PC_VPP1_MASK	0x03
#define		PC_VPP2_SHIFT	2
/* First, bit positions */
#define		PC_VPP2_1	0x08
#define		PC_VPP2_0	0x04
#define		PC_VPP1_1	0x02
#define		PC_VPP1_0	0x01
/* Talk about combination of bits */
#define		PC_VPP2_NC	0x00
#define		PC_VPP2_5V	0x04
#define		PC_VPP2_12V	0x08
#define		PC_VPP1_NC	0x00
#define		PC_VPP1_5V	0x01
#define		PC_VPP1_12V	0x02
/* Same thing in canonical form (lsb aligned) */
#define		PC_VPP_MASK	0x03
#define		PC_VPP_NC	0x00
#define		PC_VPP_5V	0x01
#define		PC_VPP_12V	0x02

#define	PCIC_IGC	3	/* Interrupt and General Control */
#define		IGC_NOTRESET	0x40	/* Reset if not set */
#define		IGC_IOCARD	0x20	/* I/O (card vs memory) */
#define		IGC_ENBCINT	0x10	/* Enable change intr on INTR/SMI */
#define		IGC_IRQMASK	0x0f
#define	PCIC_CSC	4	/* Card Status Change */
#define		CSC_CCHANGE	0x08	/* Card changed */
#define		CSC_READY	0x04	/* Ready */
#define		CSC_CBATWARN	0x02	/* Card battery warning */
#define		CSC_CBATDEAD	0x01	/* Card battery dead */
#define		CSC_ALL		0x0f
#define	PCIC_CSCIC	5	/* Card Status Change Interrupt Config */
#define		CSCIC_IRQMASK	0xf0
#define	PCIC_AWE	6	/* Address window enable */
#define		AWE_IOW1	0x80	/* Enable I/O window 1 */
#define		AWE_IOW0	0x40	/* Enable I/O window 0 */
#define		AWE_MEMCS16	0x20	/* Use A23-A12 to decode address */
#define		AWE_MEM3	0x08	/* Enable memory window 3 */
#define		AWE_MEM2	0x04	/* Enable memory window 2 */
#define		AWE_MEM1	0x02	/* Enable memory window 1 */
#define		AWE_MEM0	0x01	/* Enable memory window 0 */
#define	PCIC_IOC	7	/* I/O Control */
#define		IOC_IOW1WS	0x80	/* I/O window 1 1 wait */
#define		IOC_IOW1ZW	0x40	/* I/O window 1 Zero wait */
#define		IOC_IOW1IOCS16	0x20	/* I/O window 1 IOCS16 source */
#define		IOC_IOW1DS16	0x10	/* I/O window 1 data size */
#define		IOC_IOW1DS8	0
#define		IOC_IOW0WS	0x08	/* I/O window 0 1 wait */
#define		IOC_IOW0ZW	0x04	/* I/O window 0 Zero wait */
#define		IOC_IOW0IOCS16	0x02	/* I/O window 0 IOCS16 source */
#define		IOC_IOW0DS16	0x01	/* I/O window 0 data size */
#define		IOC_IOW0DS8	0
#define	PCIC_IOA_0	8	/* I/O Address 0 start low byte */
#define	PCIC_IOA_1	0xc	/* I/O Address 1 start low byte */
#define		IOA_START	0
#define		IOA_START_LOW	0
#define		IOA_START_HIGH	1
#define		IOA_STOP	2
#define		IOA_STOP_LOW	2
#define		IOA_STOP_HIGH	3
#define	PCIC_MMAP_0	0x10
#define	PCIC_MMAP_1	0x18
#define	PCIC_MMAP_2	0x20
#define	PCIC_MMAP_3	0x28
#define	PCIC_MMAP_4	0x30
#define		SMEM_START	0
#define			MMAP_W_ZW		0x4000
#define			MMAP_W_DS16		0x8000
#define			MMAP_W_ADDRMASK		0x0fff
#define		SMEM_START_LOW	0
#define		SMEM_START_HIGH	1
#define			MMAP_ZW			0x40
#define			MMAP_DS16		0x80
#define		SMEM_STOP	2
#define			MMAP_W_W0		0x0000
#define			MMAP_W_W1		0x4000
#define			MMAP_W_W2		0x8000
#define			MMAP_W_W3		0xc000
#define			MMAP_W_WSMASK		0xc000
#define		SMEM_STOP_LOW	2
#define		SMEM_STOP_HIGH	3
#define			MMAP_A1W		0x40
#define			MMAP_A2W		0x80
#define			MMAP_A3W		0xc0
#define		CMEM_OFF	4
#define			MMAP_W_REGACTIVE	0x4000
#define			MMAP_W_WPROT		0x8000
#define			MMAP_W_OFFMASK		0x3fff
#define		CMEM_OFF_LOW	4
#define		CMEM_OFF_HIGH	5
#define			MMAP_REGACTIVE		0x40
#define			MMAP_WPROT		0x80

#define	PCIC_IOMAPREG(mapno, regoff)	(PCIC_IOA_0 + (mapno) * 4 + (regoff))
#define	PCIC_MMAPREG(mapno, regoff)	(PCIC_MMAP_0 + (mapno) * 8 + (regoff))

#define	PCIC_CARD_IOA_0	0x36	/* I/O Address 0 start low byte */
#define	PCIC_CARD_IOA_1	0x38	/* I/O Address 1 start low byte */

#define	PCIC_SETUP_TIMING_0	0x3a
#define	PCIC_SETUP_TIMING_1	0x3d

#define	PCIC_CMD_TIMING_0	0x3b
#define	PCIC_CMD_TIMING_1	0x3e

#define	PCIC_RECOVERY_TIMING_0	0x3c
#define	PCIC_RECOVERY_TIMING_1	0x3f

#define	    TIMING_PRES_1	(0 << 6)
#define	    TIMING_PRES_16	(1 << 6)
#define	    TIMING_PRES_256	(2 << 6)
#define	    TIMING_PRES_4096	(3 << 6)
#define	    TIMING_MULT_MASK	0x3f

#define	TIMING_TO_INT(x) (((x & 0xc0) == TIMING_PRES_1 ? 1 : \
			   (x & 0xc0) == TIMING_PRES_16 ? 16 : \
			   (x & 0xc0) == TIMING_PRES_256 ? 256 : 4096) * \
			  (x & TIMING_MULT_MASK) + 1)
#define	INT_TO_TIMING(x) (\
	(x <= 1 * 31 + 1) ? (TIMING_PRES_1 | (x - 1)) : \
	(x <= 16 * 31 + 1) ? (TIMING_PRES_16 | ((x - 1) / 16)) : \
	(x <= 256 * 31 + 1) ? (TIMING_PRES_256 | ((x - 1) / 256)) : \
	(x <= 4096 * 31 + 1) ? (TIMING_PRES_4096 | ((x - 1) / 4096)) : 0xff)

/*
 * i82365sl.h,v
 * Revision 1.3  1999/08/26 22:11:11  prb
 * Get rid of the magic timing stuff and specify timings in nanoseconds
 * Add a function to convert nanoseconds into device peculiar time format.
 * Information gathered from the intel datasheets
 *
 * Revision 1.2  1996/07/25 22:09:53  prb
 * Add BSDI rcs lines
 *
 * Revision 1.1  1996/07/25 18:44:27  prb
 * i386 specic pcmcia code from wildboar
 *
 * Revision 1.6  1996/03/01  06:02:50  shigeya
 * W960301
 *
 * Revision 1.5  1996/02/13  13:01:58  shigeya
 * WB960213
 *
 * Revision 1.4  1996/02/11  07:29:31  shigeya
 * WB960211
 *
 * Revision 1.3  1996/02/11  07:03:45  shigeya
 * WB960211pre
 *
 * Revision 1.1  1995/07/31  10:22:02  shigeya
 * WB950727A
 *
 * Revision 1.1  1995/07/31  08:31:40  shigeya
 * Wildboar 950727A
 *
 * Revision 1.2  1995/07/26  01:41:34  shigeya
 * Wildboar 950726
 *
 * Revision 1.3  1995/05/26  09:15:32  shigeya
 * First version, with COPYRIGHT tags
 *
 * Revision 1.2  1995/05/26  07:16:35  shigeya
 * Wildboar @950526
 *
 * Revision 1.1  1995/04/28  09:45:38  shigeya
 * Wildboar 950424 new files
 */
