/*	BSDI mb86960.h,v 1.2 1996/07/25 22:09:54 prb Exp */
/* WILDBOAR $Wildboar: mb86960.h,v 1.5 1996/02/13 13:01:59 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * Fujitsu MB86960A/MB86965A
 *
 * Registers and their functions
 *
 */

#define	MB86960_IOSIZE	16

/*
 * Bits in DLCR0 (Transmit status register)
 *
 * Writing bits 0x80, 0x08, 0x04, 0x02 and 0x01 clears
 * corresponding status bits.
 */

#define	DLCR0	0
#define	DLCR0_TMTOK	0x80	/* 0: Transmitter busy 1: ready to accept next*/
#define	DLCR0_NETBSY	0x40	/* 0: No carrier 1: Carrier detected */
#define	DLCR0_TMTREC	0x20	/* 0: Self receive NG 1: OK */
#define	DLCR0_SRTPKT	0x10	/* 0: No short packet error */
#define	DLCR0_JABBER	0x08	/* 0: No jabber 1: Jabber on */
#define	DLCR0_COL	0x04	/* 0: No collision 1: Collision */
#define	DLCR0_16COL	0x02	/* 1: 16 consequtive collisions */
#define	DLCR0_BUSWERR	0x01	/* 1: Transmit buffer full */

#define	DLCR0_STDBITS	(DLCR0_TMTOK|DLCR0_TMTREC|DLCR0_JABBER \
				|DLCR0_16COL|DLCR0_BUSWERR)

/*
 * Bits in DLCR1 (Receive status register)
 *
 */
#define	DLCR1	1
#define	DLCR1_PKTRDY	0x80
#define	DLCR1_BUSRERR	0x40
#define	DLCR1_DMAEOP	0x20
#define	DLCR1_RMTRST	0x10
#define	DLCR1_RXSRTERR	0x08
#define	DLCR1_RXALGERR	0x04
#define	DLCR1_CRCERR	0x02
#define	DLCR1_OVERFLOW	0x01

#define	DLCR1_STDBITS	(DLCR1_PKTRDY|DLCR1_RXALGERR \
				|DLCR1_CRCERR|DLCR1_OVERFLOW)

/*
 * Bits in DLCR2 (Transmit interrupt control)
 */
#define	DLCR2	2
#define	DLCR2_TMTOK	0x80
#define	DLCR2_JABBER	0x08
#define	DLCR2_COL	0x04
#define	DLCR2_16COL	0x02
#define	DLCR2_BUSWERR	0x01

#define	DLCR2_INTBITS	DLCR0_STDBITS

/*
 * Bits in DLCR3 (Receive interrupt control)
 */
#define	DLCR3	3
#define	DLCR3_PKTRDY	0x80
#define	DLCR3_BUSRERR	0x40
#define	DLCR3_DMAEOP	0x20
#define	DLCR3_RMTRST	0x10
#define	DLCR3_RXSRTERR	0x08
#define	DLCR3_RXALGERR	0x04
#define	DLCR3_CRCERR	0x02
#define	DLCR3_OVERFLOW	0x01

#define	DLCR3_INTBITS	DLCR1_STDBITS

/*
 * Bits in DLCR4 (Transmit mode register)
 */
#define	DLCR4	4
#define	DLCR4_COL3	0x80	/* (RO) */
#define	DLCR4_COL2	0x40	/* (RO) */
#define	DLCR4_COL1	0x20	/* (RO) */
#define	DLCR4_COL0	0x10	/* (RO) */
#define	DLCR4_TST1	0x08	/* (R, W=0) */
#define	DLCR4_CNTRL	0x04
#define	DLCR4_LBC	0x02
#define	DLCR4_DSC	0x01

/*
 * Bits in DLCR5 (Receive mode register)
 */
#define	DLCR5	5
#define	DLCR5_TST2	0x80	/* (R)  Don't write 1 during normal operation */
#define	DLCR5_BUFEMP	0x40	/* (R) */
#define	DLCR5_ACPTBAD	0x20
#define	DLCR5_ADDRSIZE	0x10
#define	DLCR5_SRTPKT	0x08
#define	DLCR5_RMTRST	0x04
#define	DLCR5_AM1	0x02
#define	DLCR5_AM0	0x01

#define	DLCR5_BASEBITS	0

/*
 * AM1 AM0 LBC SLFRX    phys pkt   bc pkt   mc pkt
 *                      id = id!=          low  adrflt
 *  0   0   X   X         X   X      X      X     X
 *  0   1   0   X         X   X      X      X     X
 *  0   1   1   X         O   X      O      O     X	own + low match mc
 *  1   0   0   X         X   X      X      X     X
 *  1   0   1   X         O   X      O      X     O	own + addr filter mc
 *  1   1   0   X         X   X      X      X     X
 *  1   1   1   X         O   O      O      O     O	promisc
 *
 */
#define	DLCR5_LOWMC	1
#define	DLCR5_CRCMC	2
#define	DLCR5_PROMISC	3

/*
 * Bits in DLCR6 (Control register 1)
 */
#define	DLCR6	6
#define	DLCR6_ENADLC	0	/* 0: Enable datalic controller  1: Reset */
#define	DLCR6_RSTDLC	0x80	/* 0: Enable datalic controller  1: Reset */
#define	DLCR6_MEMCYC100	0x40	/* 0: 150ns 1: 100ns */
#define	DLCR6_MEMCYC150	0
#define	DLCR6_SB8	0x20	/* System bus width 0:16 1:8 */
#define	DLCR6_SB16	0
#define	DLCR6_BB8	0x10	/* Buffer bus width 0:16 1:8 (inh SB=1,BB=0) */
#define	DLCR6_BB16	0
#define	DLCR6_TXBSIZ1	0x08	/* TX Buf size: (SIZ1,SIZ0) 00:2KB x 1, */
#define	DLCR6_TXBSIZ0	0x04	/* 01:2KB x 2, 10:4KB x 2, 11:8KB x 2 */ 
#define	DLCR6_MEMSIZ1	0x02	/* Memory size: 00:8KB, 01:16KB, */
#define	DLCR6_MEMSIZ0	0x01	/*    10:32KB, 11:64KB */

#define	DLCR6_TXB_2x1	0x00
#define	DLCR6_TXB_2x2	0x04
#define	DLCR6_TXB_4x2	0x08
#define	DLCR6_TXB_8x2	0x0c

#define	DLCR_MEM8K	0x00
#define	DLCR_MEM16K	0x01
#define	DLCR_MEM32K	0x02
#define	DLCR_MEM64K	0x03

/*
 * Bits in DLCR7 (Control register 2)
 */
#define	DLCR7	7
#define	DLCR7_IDENT1	0x80	/* IDENT1,IDENT0: 00 = MB86960A, 11 = MB86965A*/
#define	DLCR7_IDENT0	0x40
#define	DLCR7_NSTBY	0x20	/* 0:Stand by , 1: Non stand by */
#define	DLCR7_RDYPOL	0x10	/* Value of RDYPNSEL pin */
#define	DLCR7_RBS1	0x08	/* Register bank selection */
#define	DLCR7_RBS0	0x04	/* Register bank selection */
#define	DLCR7_EOP	0x02	/* 0:Sets EOP pin active low. 1: active high */
#define	DLCR7_BSWAP	0x01	/* 0: No byte swap access to BMPR18 1: Swap */

#define	DLCR7_OP	DLCR7_NSTBY
#define	RBANK0		(DLCR7_OP)
#define	RBANK1		(DLCR7_OP|DLCR7_RBS0)
#define	RBANK2		(DLCR7_OP|DLCR7_RBS1)

/* Registers in Bank 0 */ 


#define	DLCR8	8
#define	DLCR9	9
#define	DLCR10	0xa
#define	DLCR11	0xb
#define	DLCR12	0xc
#define	DLCR13	0xd
#define	DLCR14	0xd
#define	DLCR15	0xd

#define	NAR0	DLCR8
#define	NAR1	DLCR9
#define	NAR2	DLCR10
#define	NAR3	DLCR11
#define	NAR4	DLCR12
#define	NAR5	DLCR13

#define	TDRL	DLCR14
#define	TDRH	DLCR15

/* Registers in Bank 1 */

#define	MAR0	8
#define	MAR1	9
#define	MAR2	0xa
#define	MAR3	0xb
#define	MAR4	0xc
#define	MAR5	0xd
#define	MAR6	0xe
#define	MAR7	0xf

/* Registers in Bank 2 */

/* Data I/O port */
#define	BMPR8	8

/* Transmit packet count/start transmission */
#define	BMPR10	0xa
#define	BMPR10_TMST	0x80	/* Start transmission on write */
#define	BMPR10_PCNTMSK	0x7f	/* Low 7 bits are packet count */

/* Controls behavior when 16 consequtive collision was detected */
#define	BMPR11	0xb
#define	BMPR11_CNTL2
#define	BMPR11_CNTL1
#define	BMPR11_CNTL0

/* DMA enable register */
#define	BMPR12	0xc
#define	BMPR12_MBZMASK	~0xfc
#define	BMPR12_DMARENA	0x02
#define	BMPR12_DMATENA	0x01

/* DMA burst/transceiver mode control */
#define	BMPR13	0xd
#define	BMPR13_IOBASUNL	0x80
#define	BMPR13_LOWSQL	0x40
#define	BMPR13_LNKTST	0x20	/* 0: Link test enable 1: disable */
#define	BMPR13_AUI	0x10	/* 0: TP 1: AUI */
#define	BMPR13_AUTOPORT	0x08
#define	BMPR13_STP	0x04	/* 0: UTP 1: STP */
#define	BMPR13_DMABRST1	0x02
#define	BMPR13_DMABRST0	0x01

/* Receive control / transceiver interrupt */
#define	BMPR14	0xe
#define	BMPR14_MBZMASK	~0x18
#define	BMPR14_RLDINT	0x80	/* 1: Enable remote link down interrupt */
#define	BMPR14_LLDINT	0x40	/* 1: Enable local link down interrupt */
#define	BMPR14_RJABINT	0x20	/* 1: Enable remote jabber interrupt */
#define	BMPR14_SKPRXPKT	0x04	/* W0: no effect, W1: skip to next packet */
				/* R0: skip complete, R1: skip in progress */
#define	BMPR14_SQEINT	0x02	/* 1: Enable SQE interrupt */
#define	BMPR14_FLTSELF	0x01	/* 1: dont' receive self tx packet, 0: do it */

/* Transceiver status register */
#define	BMPR15	0xf
#define	BMPR15_MBZMASK	~0xfa
#define	BMPR15_RLD	0x80	/* 1: Remote link down */
#define	BMPR15_LLD	0x40	/* 1: Local link down */
#define	BMPR15_RJAB	0x20	/* 1: Remote jabber */
#define	BMPR15_RMTPORT	0x10	/* 1: MB86950A/6 link pulse detected */
#define	BMPR15_POLREV	0x08	/* 1: Reverse polarity */
#define	BMPR15_SQE	0x02	/* 1: SQE error */

