/*	BSDI pd67xx.h,v 1.3 1999/08/26 22:11:11 prb Exp */
/* WILDBOAR $Wildboar: pd67xx.h,v 1.6 1996/02/25 08:04:55 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * Registers and functions specific to Cirrus Logic CL-PD6710/6720/6722. 
 */

/*
 * Timing generator set selection.
 *
 * These go instead of MMAP_W_W{0,1,2,3}.
 */
#define	MMAP_W_PD67WSSEL0	0x0000
#define	MMAP_W_PD67WSSEL1	0x4000

#define PD67_MISC_CTL_1		0x16	/* Misc. control 1 (per socket) */

#	define	MC1_5V_DET		0x01
#	define 	MC1_VCC_3V		0x02
#	define 	MC1_PULSE_MGMT		0x04
#	define 	MC1_PULSE_IRQ		0x08
#	define 	MC1_SPKR_ENA		0x10
#	define 	MC1_INPACK_ENA		0x80

#define	PD67_FIFO_CTRL	0x17	/* Fifo control (per socket) */

#define	PD67_MISC_CTL_2	0x1e	/* Misc. control 2 (per chip) */

#define	PD67_CHIP_INFO	0x1f	/* Chip information (per chip) */

#	define	CINFO_IDMASK	0xc0
#	define	CINFO_DUAL	0x20
#	define	CINFO_REVMASK	0x1c

#define	PD67_ATA_CTRL	0x26	/* ATA control (per socket) */
#define	PD67_SCRATCHPAD	0x27	/* Scratchpad (per socket) */

#define	PD67_EXTX	0x2e	/* Extended index (per socket) */
#define	PD67_EXTD	0x2f	/* Extended index (per socket) */

#define	PD67_TC_SETUP(n)	(0x3a + (n) * 3)
#define	PD67_TC_CMD(n)		(0x3b + (n) * 3)
#define	PD67_TC_RECOV(n)	(0x3c + (n) * 3)

#	define	TC_PRESCALE_1	(0 << 6)
#	define	TC_PRESCALE_16	(1 << 6)
#	define	TC_PRESCALE_256	(2 << 6)
#	define	TC_PRESCALE_4096 (3 << 6)

/* for PD6729 */
#define PCI_VENDOR_ID_CIRRUS            0x1013
#define PCI_DEVICE_ID_CIRRUS_6729       0x1100
