/*	BSDI px0072.h,v 1.2 1996/07/25 22:09:55 prb Exp */
/* WILDBOAR $Wildboar: px0072.h,v 1.5 1996/02/13 13:02:01 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

 
/*
 * Pixel Semiconductor (Cirrus Logic) CL-PX0072
 *	Video Window Generator (VWG)
 */

/*
 * Visible register locations (offsets).
 * May vary from actual h/w design to design.
 */
#define	VWG_DATA	0
#define	VWG_ADDR	1

/*
 * Control register addresses.
 * These are the values written to VWG_ADDR port.
 */
#define	VWG_MCR		0x00	/* Master control register */
#define	VWG_IOC		0x01	/* I/O control register */

#define	VWG_XBHI	0x10	/* X Begin  High Integer */
#define	VWG_XBLI	0x11	/*          Low  Integer */
#define	VWG_XBHF	0x12	/*	    High Fraction */
#define	VWG_XBLF	0x13	/*          Low  Fraction */

#define	VWG_XEHI	0x14	/* X End    High Integer */
#define	VWG_XELI	0x15	/*          Low  Integer */
#define	VWG_XEHF	0x16	/*	    High Fraction */
#define	VWG_XELF	0x17	/*          Low  Fraction */

#define	VWG_XSHI	0x18	/* X Shrink High Integer */
#define	VWG_XSLI	0x19	/*          Low  Integer */
#define	VWG_XSHF	0x1a	/*	    High Fraction */
#define	VWG_XSLF	0x1b	/*          Low  Fraction */

#define	VWG_YBHI	0x20	/* X Begin  High Integer */
#define	VWG_YBLI	0x21	/*          Low  Integer */
#define	VWG_YBHF	0x22	/*	    High Fraction */
#define	VWG_YBLF	0x23	/*          Low  Fraction */

#define	VWG_YEHI	0x24	/* X End    High Integer */
#define	VWG_YELI	0x25	/*          Low  Integer */
#define	VWG_YEHF	0x26	/*	    High Fraction */
#define	VWG_YELF	0x27	/*          Low  Fraction */

#define	VWG_YSHI	0x28	/* X Shrink High Integer */
#define	VWG_YSLI	0x29	/*          Low  Integer */
#define	VWG_YSHF	0x2a	/*	    High Fraction */
#define	VWG_YSLF	0x2b	/*          Low  Fraction */

/*
 * Bit functions in MCR
 */
#define	VWG_MCR_FPS_NORMAL	(0 << 7)
#define	VWG_MCR_FPS_INVERT	(1 << 7)
#define	VWG_MCR_PPM_NONE	(0 << 4)
#define	VWG_MCR_PPM_16BIT	(1 << 4)
#define	VWG_MCR_PPM_8BIT	(2 << 4)
#define	VWG_MCR_PPM_8BITPAIR	(3 << 4)
#define	VWG_MCR_IF_411		(0 << 2)
#define	VWG_MCR_IF_422		(1 << 2)
#define	VWG_MCR_IF_444		(2 << 2)
#define	VWG_MCR_CSCE		(1 << 1)
#define	VWG_MCR_GCE		(1 << 0)

/*
 * Bit functions in IOC
 */
#define	VWG_IOC_FOV		(1 << 7)
#define	VWG_IOC_FUN		(1 << 6)
#define	VWG_IOC_WLE		(1 << 5)
#define	VWG_IOC_OF_RGB888	(0 << 2)
#define	VWG_IOC_OF_RGB777	(1 << 2)
#define	VWG_IOC_OF_RGB666	(2 << 2)
#define	VWG_IOC_OF_RGB565	(3 << 2)
#define	VWG_IOC_OF_RGB555	(4 << 2)
#define	VWG_IOC_OF_RGB444	(5 << 2)
#define	VWG_IOC_OF_RGB333	(6 << 2)
#define	VWG_IOC_OF_RGB332	(7 << 2)
#define	VWG_IOC_IC_CLK		(0 << 1)
#define	VWG_IOC_IC_PHASE	(1 << 1)
#define	VWG_IOC_IM		(1 << 0)
