/*
 * Copyright (c) 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI smc83C584.h,v 2.4 1996/03/08 20:11:59 ewv Exp
 */

/*
 * SMC 83C584 ISA bus interface
 */

/*
 * EEPROM address blocks
 */
/* initialization blocks mirror register set below */
#define SME_INIT0	0x00		/* !INIT2/!INIT1/!INIT0: 111 */
#define SME_INIT1	0x08		/* 110 */
#define SME_INIT2	0x10		/* 101 */
#define SME_INIT3	0x18		/* 100 */
#define SME_INIT4	0x20		/* 011 */
#define SME_INIT5	0x28		/* 010 */
#define SME_INIT6	0x30		/* 001 - initial condition */
#define SME_INIT7	0x38		/* 000 */

#define SME_ADDR	0x40		/* MAC address */

/*
 * I/O register offsets
 */
#define	SMIO_MSR	0x00		/* Memory select register */
#define SMIO_ICR	0x01		/* Interface config register */
#define SMIO_IAR	0x02		/* I/O address register */
#define SMIO_BIO	0x03		/* BIOS rom address register */
#define SMIO_EAR	0x03		/* EEROM address register (alt) */
#define SMIO_IRR	0x04		/* Interrupt request register */
#define SMIO_LAAR	0x05		/* LA address register */
#define SMIO_DIGIN	0x06		/* Initialization jumpers/inputs */
#define SMIO_GP2	0x07		/* General purpose */
#define SMIO_LADDR	0x08		/* LAN address block (08-0D) */
#define SMIO_ID		0x0e		/* LAN ID byte */
#define SMIO_CKSUM	0x0f		/* checksum of LAN addr and LAN ID */

/* SMIO_MSR bits */
#define SMMSR_ADDRMASK	0x3f		/* Shared RAM address mask (A13-A18) */
#define SMMSR_MENB	0x40		/* Shared RAM enable */
#define SMMSR_RST	0x80		/* Assert hardware reset to LAN ctlr */

/* SMIO_ICR bits */
#define SMICR_BIT16	0x01		/* 16 bit bus */
#define SMICR_ORA	0x02		/* Select BIO/EAR */
#define SMICR_IR2	0x04		/* IRQ select 2 */
#define SMICR_MSZ	0x08		/* Shared mem size (8/16 or 32/64) */
#define SMICR_RLA	0x10		/* Recall LAN address */
#define SMICR_RX7	0x20		/* Recall ALL but I/O and LAN address */
#define SMICR_RIO	0x40		/* Recall I/O address from EEROM */
#define SMICR_STO	0x80		/* Store addr block to EEROM */

/* SMIO_BIO bits */
#define SMBIO_INT	0x01		/* Raise an interrupt */
#define SMBIO_BA_MASK	0x3e		/* BIOS ROM A14-A18 */
#define SMBIO_BA_SHIFT	1
#define SMBIO_RSMASK	0xc0		/* ROM size */
#define SMBIO_RS_OFF	0x00		/* ROM disabled */
#define SMBIO_RS_16K	0x40		/* 16K ROM */
#define SMBIO_RS_32K	0x80		/* 32K ROM */
#define SMBIO_RS_64K	0xc0		/* 64K ROM */

/* SMIO_EAR bits */
#define SMEAR_ROMP_MASK	0x03		/* ROM page mask */
#define SMEAR_ROMPE	0x04		/* ROM paging enable */
#define SMEAR_RAM	0x08		/* RAM installed in ROM socket */
#define SMEAR_EA_MASK	0xf0		/* EEROM address mask */
#define SMEAR_EA_SHIFT	4

/* SMIO_IRR bits */
#define SMIRR_ZWAIT	0x01		/* 8bit zero wait state enable */
#define SMIRR_OUT1	0x02		/* OUT1 pin */
#define SMIRR_OUT2	0x04		/* OUT2 pin */
#define SMIRR_OUT3	0x08		/* OUT3 pin */
#define SMIRR_FLSH	0x10		/* Flash installed in ROM socket */
#define SMIRR_IR0	0x20		/* IRQ select 0 */
#define SMIRR_IR1	0x40		/* IRQ select 1 */
#define SMIRR_IEN	0x80		/* Enable interrupts (else tri-state) */

/* SMIO_LAAR bits */
#define SMLAAR_AD_MASK	0x1f		/* 16 shared ram A19-A23 */
#define SMLAAR_0WS16	0x20		/* 0 WS 16 bit memory access */
#define SMLAAR_L16EN	0x40		/* Enable 16 bit lan operation */
#define SMLAAR_M16EN	0x80		/* Enable 16 bit memory access */

/* SMIO_DIGIN bits */
#define SMDIGI_INIT0	0x01		/* Init 0 jumper */
#define SMDIGI_INIT1	0x02		/* Init 1 jumper */
#define SMDIGI_INIT2	0x04		/* Init 2 jumper */
#define SMDIGI_IN1	0x20		/* In 1 pin */
#define SMDIGI_IN2	0x40		/* In 2 pin */

/* LAN address block detailed offsets */
#define	SMLAB_GMAC_L	0x08		/* LSB globally assigned MAC */
#define	SMLAB_GMAC_M	0x09		
#define	SMLAB_GMAC_H	0x0a		/* MSB globally assigned MAC */
#define	SMLAB_LMAC_L	0x0b		/* LSB board MAC */
#define	SMLAB_LMAC_M	0x0c		
#define	SMLAB_LMAC_H	0x0d		/* MSB board MAC */
#define	SMLAB_ID	0x0e		/* board ID */
#define SMLAB_CSUM	0x0f		/* 2's C csum of LAB == 0xff */

/* Valid IRQ mask */
#define SMIRQ_MASK	(IRQ3 | IRQ4 | IRQ5 | IRQ7 | IRQ9 | IRQ10 | IRQ11 | \
			    IRQ15)

/* Valid shared ram info */
#define SMSHM_MIN	0x80000
#define SMSHM_MAX	0xfc000
#define SMSHM_MASK	0x1fff
