/*	BSDI smc91c92.h,v 1.2 1996/07/25 22:09:55 prb Exp */
/* WILDBOAR $Wildboar: smc91c92.h,v 1.4 1996/02/13 13:02:02 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * Standard Microsystems Corporation SMC91C92 ethernet chipset
 *
 * MZ stands for MegahertZ, since the chipset is used by MegaHertz XJack
 * ethernet adapters.
 */

/*
 * byte offset for registers.
 */
#define	MZ_BANKSEL	0x0e
/* bank 0 */
#define	MZ_TCR		0x00		/* Transmit control register */
#define	MZ_STATUS	0x02		/* EPH status register  */
#define	MZ_RCR		0x04		/* Receive control register */
#define	MZ_COUNTER	0x06		/* Statistics counter register */
#define	MZ_MIR		0x08		/* Memory information register */
#define	MZ_MCR		0x0a		/* Memory configuration register */
#define	MZ_TEST		0x0c
/* bank 1 */
#define	MZ_CONFIG	0x00		/* Adapter configuration register */
#define	MZ_BASE		0x02		/* IO Base address */
#define	MZ_IA10		0x04		/* Current address bytes 0-1 */
#define	MZ_IA32		0x06		/* Current address bytes 2-3 */
#define	MZ_IA54		0x08		/* Current address bytes 4-5 */
#define	MZ_GENERAL	0x0a		/* General purpose */
#define	MZ_CONTROL	0x0c		/* Control */
/* bank 2 */
#define	MZ_MMUCOM	0x00
#define	MZ_PNR		0x02		/* Packet Number Register (8 bit) */
#define	MZ_ARR		0x03		/* Allocation Result Register (8 bit) */
#define	MZ_TXFIFO 	0x04		/* Tx Fifo Port Register (8 bit) */
#define	MZ_RXFIFO 	0x05		/* Rx Fifo Port Register (8 bit) */
#define	MZ_POINTER	0x06		/* Pointer Register */
#define	MZ_DATA1	0x08		/* Data Register */
#define	MZ_DATA2	0x0a		/* Data Register */
#define	MZ_INTERRUPT 	0x0c		/* read/write(for Ack/8bit) */
#define	MZ_INTMASK 	0x0d		/* Write only (8bit) */
/* bank 3 */
#define	MZ_MT10		0x00
#define	MZ_MT32		0x02
#define	MZ_MT54		0x04
#define	MZ_MT76		0x06

#define	MZ_NPORT	16
#define	MZ_PGSIZE	256

/*
 * bank select register(MZ_BANKSEL)
 */
#define	MZ_BANKSEL_BANK0	0x0000
#define	MZ_BANKSEL_BANK1	0x0001
#define	MZ_BANKSEL_BANK2	0x0002
#define	MZ_BANKSEL_BANK3	0x0003

/*
 * TCR register(MZ_TCR on bank 0)
 */
#define	MZ_TCR_EPHLOOP		0x2000	/* Loop at EPH block */
#define	MZ_TCR_STPSQET		0x1000	/* Stop xmit on SQET error */
#define	MZ_TCR_FDUPLX		0x0800	/* Full duplex mode */
#define	MZ_TCR_MONCSN		0x0400	/* Monitor carrier */
#define	MZ_TCR_NOCRC		0x0100	/* Don't append CRC */
#define	MZ_TCR_PADEN		0x0080	/* Pad short frames */
#define	MZ_TCR_FORCECOL		0x0004	/* Force collision */
#define	MZ_TCR_LOOP		0x0002	/* Local loopback */
#define	MZ_TCR_TXEN		0x0001	/* Enable transmitter */

#define	MZ_TCR_RWMask		0x3d87

/*
 * status register(MZ_STATUS on bank 0)
 */
#define	MZ_STATUS_TXUNRN	0x8000	/* Frame uderrun */
#define	MZ_STATUS_NOLINK	0x4000	/* 10BASET link error condition */
#define	MZ_STATUS_RXOVRN	0x2000	/* Receiver overrun */
#define	MZ_STATUS_COUNTER	0x1000	/* Counter roll over */
#define	MZ_STATUS_EXDEFER	0x0800	/* Excessive deferral */
#define	MZ_STATUS_LOSTCAR	0x0400	/* Carrier not present */
#define	MZ_STATUS_LATCOL	0x0200	/* Late collision */
#define	MZ_STATUS_DEFER		0x0080	/* Frame was deferred */
#define	MZ_STATUS_BCAST		0x0040	/* Last frame was broadcast */
#define	MZ_STATUS_SQET		0x0020	/* Signal Quality Error */
#define	MZ_STATUS_SIXTEENCOL	0x0010	/* Too many collisions */
#define	MZ_STATUS_MCAST		0x0008	/* Last frame was multicast */
#define	MZ_STATUS_MULTICOL	0x0004	/* Multiple collisions on last frame */
#define	MZ_STATUS_SINCOL	0x0002	/* Single collision on last frame */
#define	MZ_STATUS_TXSUCCESS	0x0001	/* Frame successfully transmitted */

/*
 * rcr register(MZ_RCR on bank 0)
 */
#define	MZ_RCR_EPHRST		0x8000	/* Software reset */
#define	MZ_RCR_STRIPCRC		0x0200	/* Strip CRC on received frames */
#define	MZ_RCR_RXEN		0x0100	/* Enable receiver */
#define	MZ_RCR_ALLMCAST		0x0004	/* Accept all multicasts */
#define	MZ_RCR_PROMISC		0x0002	/* Promiscuous mode */
#define	MZ_RCR_PLLGAIN		0x0c00	/* Adjust pll gain (test only) */
#define	MZ_RCR_FILTCAR		0x4000	/* Filter carrier for 12 bits */

#define	MZ_RCR_RWMask		0x4fff

/*
 * MCR register(MZ_MCR on bank 0)
 */
#define	MZ_MCR_RWMask		0x001f

/*
 * configuration register(MZ_CONFIG on bank 1)
 */
#define	MZ_CONFIG_AUISELECT	0x0100	/* =1 AUI, =0 10BT */
#define	MZ_CONFIG_SIXTEENBIT	0x0080	/* System bus width */
#define	MZ_CONFIG_DISLINK	0x0040	/* Disable link test (10BT) */
#define	MZ_CONFIG_INTSEL	0x0006
#define	MZ_CONFIG_NOWAITST	0x1000	/* No wait states */
#define	MZ_CONFIG_FULLSTEP	0x0400	/* Full step signalling to AUI */
#define	MZ_CONFIG_SETSQLCH	0x0200	/* Set squelch level */

#define	MZ_CONFIG_RWMask	0x1040

/*
 * base register(MZ_BASE on bank 1)
 */
#define	MZ_BASE_RWMask		0x00fe

/*
 * control register(MZ_CONTROL on bank 1)
 */
#define	MZ_CONTROL_BYPSMMU	0x8000	/* Bypass MMU */
#define	MZ_CONTROL_RCVBAD	0x4000	/* Receive bad CRC packets */
#define	MZ_CONTROL_PWRDWN	0x2000	/* Enter powerdown mode */
#define	MZ_CONTROL_AUTORELEASE	0x0800	/* Auto-release xmit memory */
#define	MZ_CONTROL_LEEN		0x0080	/* Link error enable (EPH) */
#define	MZ_CONTROL_CROVER	0x0040	/* Counter rollover enable (EPH) */
#define	MZ_CONTROL_XEEN		0x0020	/* Xmit error enable (EPH) */
#define	MZ_CONTROL_EEPROMSEL	0x0004	/* EEPROM select */
#define	MZ_CONTROL_RELOAD	0x0002	/* Reload from EEPROM */
#define	MZ_CONTROL_STORE	0x0001	/* Store to EEPROM */

#define	MZ_CONTROL_RWMask	0x48e0

/*
 * MMU command register(MZ_MMUCOM on bank 2)
 */
#define	MZ_MMUCOM_BUSY		0x0001
#define	MZ_MMUCOM_ALLOCTX	0x0020	/* Allocate memory */
#define	MZ_MMUCOM_RESETMMU	0x0040	/* Reset to initial state */
#define	MZ_MMUCOM_REMOVERX	0x0060	/* Remove frame from top of RX fifo */
#define	MZ_MMUCOM_RELERX	0x0080	/* Remove and release top of RX fifo */
#define	MZ_MMUCOM_RELEPNR	0x00a0	/* Release specific packet */
#define	MZ_MMUCOM_QUEUETX	0x00c0	/* Enqueue to xmit fifo */

/*
 * (MZ_ARRPNR on bank 2)
 */
#define	MZ_ARRPNR_FAILALL	0x8000	/* pnrarr alloc fail bit */

#define	MZ_ARRPNR_RWMask	0x001f

/*
 * FIFO ports register(MZ_FIFOPORTS on bank 2)
 */
#define	MZ_FIFOPORTS_REMPTY     0x0080
#define	MZ_FIFOPORTS_TEMPTY     0x0080

/*
 * pointer register(MZ_POINTER on bank 2)
 */
#define	MZ_POINTER_RXRD		0xe000
#define	MZ_POINTER_RXWR		0xc000	
#define	MZ_POINTER_TXRD		0x6000
#define	MZ_POINTER_TXWR		0x4000

#define	MZ_POINTER_RWMask	0xe700

/*
 * interrupt status register(MZ_INTERRUPT on bank 2)
 */
#define	MZ_INTERRUPT_EPHINT	0x0020	/* EPH type interrupt */
#define	MZ_INTERRUPT_RXOVRN	0x0010	/* Receive overrun interrupt */
#define	MZ_INTERRUPT_ALLOCINT	0x0008	/* Allocation interrupt */
#define	MZ_INTERRUPT_TFEINT	0x0004	/* Xmit fifo empty interrupt */
#define	MZ_INTERRUPT_TXINT	0x0002	/* Xmit complete interrupt */
#define	MZ_INTERRUPT_RXINT	0x0001	/* Receive complete interrupt */
#if 0
#define	MZ_INTERRUPT_EPHINTMASK	0x2000
#define	MZ_INTERRUPT_TXINTMASK	0x0200
#define	MZ_INTERRUPT_TFEINTMASK	0x0100
#define	MZ_INTERRUPT_RXINTMASK	0x0100
#endif
#define	MZ_INTERRUPT_ALIGNERR	0x8000
#define	MZ_INTERRUPT_BADCRC	0x2000
#define	MZ_INTERRUPT_RWMask	0x3f00
#define MZ_INTERRUPT_ALL	(MZ_INTERRUPT_EPHINT|MZ_INTERRUPT_RXOVRN| \
				 MZ_INTERRUPT_TXINT|MZ_INTERRUPT_RXINT)
/*
 * unknown
 */
#define EPHERR       		0x8630
