/*-
 * Copyright (c) 1992, 1994, 1995, 1996, 1997 Berkeley Software Design, Inc. 
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI icu.h,v 2.13 2000/04/21 07:44:04 dab Exp
 *
 * WILDBOAR $Wildboar: icu.h,v 1.6 1996/02/13 13:01:34 shigeya Exp $
 * 
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 */

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)icu.h	8.1 (Berkeley) 6/11/93
 */

#ifndef	__ICU__
#define	__ICU__

/*
 * Interrupt "level" mechanisms: hardware, variables, masks, and macros
 */
#define	NIRQ		16
#define	NISRC		48		/* APIC/mixed interrupt sources */

#if defined(KERNEL) && !defined(LOCORE)
void setidt __P((int idx, char *func, int typ, int dpl, int sel));
#endif

/*
 * NOTE: These definitions are also used in symmetric I/O mode (APIC mode).
 *	 The terminology is:
 *		IRQ:
 *		  an interrupt vector from 0 through NIRQ (15), device
 *		  drivers deal in IRQ masks (and IRQ #'s). The 'intrhand'
 *		  array associates an IRQ with a list of device driver
 *	 	  interrupt routines.
 *		Interrupt source:
 *		  An actual hardware (IDT) vector that may generate interrupts,
 *		  there can be as many of these as there are input pins to
 *		  the various interrupts controllers. The 'inin' table
 *		  associates interrupt sources with IRQ numbers (possibly
 *		  a many to one mapping).
 *
 *	The bits in 'cpl' (returned by splyyy() functions) correspond to
 *	interrupts sources. In PIC mode (after boot) there is a 1 to 1
 *	mapping between interrupt sources and IRQs, hence the cpl bits
 *	represent IRQs; in symmetric I/O mode each interrupt source (not IRQ)
 *	has a cpl bit.
 *
 *	The special bit IRQPIC is set in all cpl words returned before going
 *	to symmetric I/O mode, and clear in all cpl words used after the
 *	remapping of cpl bits that occurs when switching to symmetric I/O
 *	mode. This feature is used by splx() and splraise() to realize they
 *	must map from PIC-format to APIC-format cpl words (sleeping procs
 *	have cpl words on their stacks).
 */

/*
 * 8259A Programmable Interrupt Controller (PIC)
 */

/* OCW1 is the current interrupt mask and is read/written at IO_ICUx+1 */

/* OCW2 */
#define	ICU_LVL_MASK	0x07		/* IR level */
#define	ICU_OCW_SEL	0x08		/* select OCW2 (0) or OCW3 (1) */
#define	ICU_NS_EOI	0x20		/* Non-specific EOI */
#define	ICU_EOI		0x60		/* Specific EOI */
#define	ICU_ROT_NS_EOI	0xa0		/* Rotate on non-specific EOI */
#define	ICU_SET_RAUTO	0x80		/* Set rotate in auto EOI mode */
#define	ICU_CLR_RAUTO	0x00		/* Clear rotate in auto EOI mode */
#define	ICU_ROT_EOI	0xe0		/* Rotate on specific EOI */
#define	ICU_SETPRIO	0xc0		/* Set priority */
#define	ICU_NOP		0x40		/* Nop */

/* OCW3 (enabled with ICU_OCW_SEL) */
#define	ICU_READ_IS	0x03		/* Read IS on next inb() */
#define	ICU_READ_IR	0x02		/* Read IR on next inb() */
#define	ICU_POLL	0x04		/* Poll command */
#define	ICU_SET_SM	0x60		/* Set special mask */
#define	ICU_RST_SM	0x40		/* Reset special mask */

#ifndef	LOCORE

/*
 * Interrupt Group Masks
 */
extern	u_int highmask;		/* interrupts masked with splhigh() */
extern	u_int ttymask;		/* interrupts masked with spltty() */
extern	u_int biomask;		/* interrupts masked with splbio() */
extern	u_int impmask;		/* interrupts masked with splimp() */
extern	u_int memmask;		/* interrupts masked with splmem() */
extern	u_int protomask;	/* interrupts masked with splnet() */
extern	u_int nonemask;		/* interrupts masked with spl0() */
extern	u_int cpl;		/* current interrupt mask */

extern u_int irqindex2mask[];
/* convert index [0-15] to (pseudo) mask */
#define	irq_indextomask(irq)	irqindex2mask[irq]

#endif

/*
 * Interrupt enable bits, valid only in PIC mode (APIC mode remaps these)
 *
 * Sorted by PIC priority.
 */
#define	IRQ0		0x00000001		/* highest priority - timer */
#define	IRQ1		0x00000002
#define	IRQ_SLAVE	0x00000004
#define	IRQ8		0x00000100
#define	IRQ9		0x00000200
#define	IRQ2		IRQ9
#define	IRQ10		0x00000400
#define	IRQ11		0x00000800
#define	IRQ12		0x00001000
#define	IRQ13		0x00002000
#define	IRQ14		0x00004000
#define	IRQ15		0x00008000
#define	IRQ3		0x00000008
#define	IRQ4		0x00000010
#define	IRQ5		0x00000020
#define	IRQ6		0x00000040
#define	IRQ7		0x00000080	/* lowest hw - parallel printer */

#define	IRQ_ALLHW	0x3fffffff	/* all hardware interrupts */
#define	IRQPIC		0x40000000	/* indicates PIC mode spl word */
#define	IRQSOFT		0x80000000	/* software interrupt mask */

/* Used only during boot time (PIC) initialization */
#define	IRQSHARE	0x020000	/* IRQ may reliably be shared */

#define	IRQUNK		0xffff		/* use intr discovery to get IRQ */
#define	IRQNONE		0		/* use no interrupt */

/*
 * Interrupt Control offset into Interrupt descriptor table (IDT)
 */
#define	ICU_OFFSET	32		/* 0-31 are processor exceptions */
#define	ICU_LEN		16		/* 32-47 are ISA interrupts */

#ifndef LOCORE
/*
 * Information describing an interrupt source (and how to deal with it).
 * Only the ii_mask and ii_flags are used in PIC mode, everything else is
 * used by sio_mode only.
 */
typedef struct intr_info {
	int	ii_mask;		/* Interrupts to mask with this one */
	int	ii_flags;		/* Misc flags */
	int	ii_cnt;			/* Interrupt counter */

	/* Destination information */
	int	ii_type;		/* Handler type */
	int	ii_irq;			/* What IRQ to call this */
	void	*ii_aux;		/* Aux data to send to handler */
	char	*ii_desc;		/* For tracing */

	/* Source information (somewhat redundant to stuff below) */
	int	ii_apic;		/* Source apic */
	int	ii_pin;			/* APIC int pin (redir table entry #) */
	int	ii_vec;			/* IDT vector to use */

	/* I/O APIC quick masking/init data */
	int	*ii_base;		/* I/O APIC base address */
	int	ii_regsel;		/* I/O APIC register select value */
	int	ii_redir_high;		/* High bits of I/O redir entry */
	int	ii_disable;		/* Low bits of IO redir - disabled */
	int	ii_enable;		/* Low bits of IO redir - enabled */

	/* Mask of all sources sharing the same IRQ (not intr source) */
	int	ii_ipendmask;
} intr_info_t;

#define	ii_redir_low	ii_disable

extern intr_info_t inin[NISRC];

#endif	/* !ASSEMBLER */

#define	II_LEVEL	0x0001		/* Level trigger, must disable before
					    EOI */
#define	II_EOISLAVE	0x0010		/* 8259: eoi master and slave */
#define	II_MASTERSTRAY	0x0020		/* 8259: this is master stray catcher */
#define	II_SLAVESTRAY	0x0040		/* 8259: this is slave stray catcher */

#define	II_SHIFT	6		/* log2(sizeof(intr_info_t)) */

/*
 * Interrupt handler types
 *
 * The IPI, APIC error, and stray handlers are handled as special cases;
 * can't be more than one type at once -- using individual bits to make it
 * easier to see if interrupt is of a certain class (for dequeueing).
 */
#define	IH_FREE		0x00
#define	IH_APIC_EDGE	0x01		/* APIC edge trigger */
#define	IH_APIC_LEVEL	0x02		/* APIC level trigger */
#define	IH_APIC_EXTINT	0x03		/* Mixed mode (PIC) edge trigger */
#define	IH_APIC_CLK	0x04		/* Clock (IRQ0) interrupt */
#define	IH_APIC_EXTCLK	0x05		/* IRQ0 via ExtINT (yuk!) */
#define	IH_APIC_CLKHACK	0x06		/* IRQ0 via ExtInt as LowPri (yuk!!!) */
#define	IH_APIC_UNK	0x07		/* Unknown pin mapping (prints msg) */
#define	IH_APIC_EXTUNK	0x08		/* Unknown pin via ExtINT */
#define	IH_PIC		0x09		/* Old style 8259 handler */
#define	IH_IDT_UNK	0x0a		/* Unmapped IDT entry handler */
#define	IH_NMI		0x0b		/* NMI source (no real handler) */
#define	IH_SMI		0x0c		/* SMI source (no real handler) */
#define	IH_EXT		0x0d		/* Actual ExtINT pin (no handler) */
#define IH_LEN		0x0e

#ifdef KERNEL
#include <net/netisr.h>
#ifndef NETHER
#include "ether.h"	/* defines NFDDI and NTOKEN, too */
#endif

#define DONET(s, c)	; \
	.global	c;  \
	testl	$(1<<(s)),netisr;  \
	je	7f; \
	andl	$(~(1<<(s))),netisr;  \
	call	c; \
7:

#ifdef INET6
#define	DONET_INET6	DONET(NETISR_IPV6,ip6intr)
#else
#define	DONET_INET6
#endif

#ifdef INET
#if NETHER > 0 || NFDDI > 0 || NTOKEN > 0
#define DONET_INET							\
	DONET(NETISR_IP,ipintr);					\
	DONET(NETISR_ARP,arpintr)
#else
#define	DONET_INET							\
	DONET(NETISR_IP,ipintr)
#endif
#else
#define	DONET_INET
#endif

#ifdef IMP
#define	DONET_IMP	DONET(NETISR_IMP,impintr)
#else
#define	DONET_IMP
#endif

#ifdef NS
#define	DONET_NS	DONET(NETISR_NS,nsintr)
#else
#define	DONET_NS
#endif

#ifdef ISO
#define DONET_ISO	DONET(NETISR_ISO,clnlintr)
#else
#define	DONET_ISO
#endif

#ifdef CCITT
#define	DONET_CCITT	DONET(NETISR_CCITT,ccittintr)
#else
#define	DONET_CCITT
#endif

#endif	/* KERNEL */

#endif	/* __ICU__ */
