/*	BSDI if_ccereg.h,v 1.2 1996/07/25 22:09:49 prb Exp */
/* WILDBOAR $Wildboar: if_ccereg.h,v 1.5 1996/02/13 13:01:35 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * Standard base value for DLCR6:
 *	System I/F 8bit, Bufmem I/F 8bit, TX Buf 2K x 2, Total memory 32K
 */
#define	DLCR6_MEMCONF_CE3	(DLCR6_SB8|DLCR6_BB8|DLCR6_TXB_2x2|DLCR_MEM32K)

/*
 * Read/write DLC registers
 */
#define	ce_wreg(iobase, reg, data)	outb((iobase) + (reg), (data))
#define	ce_rreg(iobase, reg)		inb((iobase) + (reg))

/*
 * Control register locations and bit functions for Fujitsu
 * MBH10301/10302 and compatibles.
 * Note that MBH10301 control registers appear at offset 0x0
 * and MBH10302 control registers appear at offset 0x10.
 * Values are for MBH10302.
 */

#define	MBH_LCCR		0x10
#    define	LCCR_ROMWEN	(1 << 7)	/* EEPROM write enable */
#    define	LCCR_LCIMSK	(1 << 6)	/* Link integrity intr mask,
						    0 = disable, 1 = enable */
#    define	LCCR_JSIMSK	(1 << 5)	/* Jabber intr mask */
#    define	LCCR_NICMSK	(1 << 4)	/* NIC intr mask */
#    define	LCCR_UTP	(1 << 3)	/* 0 = STP, 1 = UTP */
#    define	LCCR_NTH	(1 << 2)	/* 0 = -4.5dB, 1 = Normal */
#    define	LCCR_TRLPBK	(1 << 1)	/* XCVR loopback */
#    define	LCCR_LINKINTEG	(1 << 0)	/* Link integ. test enable */

#define	MBH_LCSR		0x11
#    define	LCSR_NICINTR	(1 << 2)
#    define	LCSR_JABINTR	(1 << 1)
#    define	LCSR_LINKINTR	(1 << 0)

#define	MBH_LCTR1	0x12	/* Test register 1 */
#define	MBH_LCTR2	0x13	/* Test register 2 */
#define	MBH_MACADDR	0x1a	/* through 0x1f, MBH10302 only */
