/*-
 * Copyright (c) 1992, 1993, 1995, 1996  Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_efreg.h,v 2.11.10.2 2001/06/30 02:16:05 geertj Exp
 */

/*
 * 3Com Corp. Etherlink III Ethernet adapter driver.
 */

/*
 * Config macros
 */
#define EF_IOBASEVALID(b)	(((b) & ~0x1f0) == 0x200)

/* 3C509 supports IRQ 3, 5, 7, 9, 10, 11, 12, 15 */
#define EF_IRQS	     (IRQ3|IRQ5|IRQ7|IRQ9|IRQ10|IRQ11|IRQ12|IRQ15)
#define EF_IRQVALID(i)	((1<<(i)) & EF_IRQS)

#define EF_NPORT		16

/* Manufacturer ID code */
#define EF_MFG_ID	0x6d50		/* EISA */
#define EF_VENDOR_ID	0x10b7		/* PCI */

/* ID port address */
#define EF_ID		0x100

/* ID port commands */
#define EFID_RDROM(n)	(0x80 | (n))	/* Read the ROM address n */
#define EFID_RESET	0xc0		/* Global Reset */
#define EFID_TAG(n)	(0xd0 | (n))	/* Set adapter tag register to n */
#define EFID_TESTTAG(n) (0xd8 | (n))	/* Test adapeter for tag n */
#define EFID_ACT(a)	(0xe0 | (((a)>>4) & 0x1f))
					/* Activate adapter with base address a */
#define EFID_ACTIVATE	0xff		/* Activate adapter with EEPROM address */


/* Registers common for all windows */
#define EF_STAT		0xe		/* Status register (R) */
#define EF_CMD		0xe		/* Command register (W) */	

/* Window 0 - Setup */
#define EF0_MID		0x0		/* Manufacturer ID (R) */
#define EF0_PID		0x2		/* Product ID (R) */
#define EF0_CC		0x4		/* Configuration Control */
#define EF0_ACNF	0x6		/* Address Configuration */
#define EF0_RCNF	0x8		/* Resource Configuration */
#define EF0_PROMCMD	0xa		/* EEPROM Command */
#define EF0_PROMDATA	0xc		/* EEPROM Data */

/* Window 1 - Operating Set */
#define EF1_DATA	0x0		/* RX/TX PIO Data */
#define EF1_RXERR	0x4		/* RX Error (R) (3C59X) */
#define EF1_RXSTAT	0x8		/* RX Status (R) */
#define EF1_TIMER	0xa		/* 32 usec interrupt latency timer */
#define EF1_TXSTAT	0xb		/* TX Status (R) */
#define EF1_TXFREE	0xc		/* Free transmit bytes (R) */

/* Window 2 - Station Address */
#define EF2_ADDR(i)	(i)		/* Station address */
#define EF2_MASK(i)	(i + 6)		/* Station address mask */

/* Window 3 - FIFO Management */
#define EF3_ICONFG	0x00		/* InternalConfig (3C59X) */
#define	EF3_MCTL	0x06		/* Mac control (3C59x) */
#define EF3_RESOPT	0x08		/* ResetOptions (3C59X) */
#define	EF3_RXFREE	0x0a		/* Bytes avail in RX FIFO */

/* Window 4 - Diagnostics */
#define EF4_TXDIAG	0x0		/* TX Diagnostic */
#define EF4_HDIAG	0x2		/* Host Diagnostic */
#define EF4_FDIAG	0x4		/* FIFO Diagnostic */
#define EF4_NDIAG	0x6		/* Net Diagnostic */
#define EF4_ECS		0x8		/* Ethernet Controller Status */
#define EF4_MTS		0xa		/* Media Type and Status */
#define EF4_BADSSD	0xc		/* 100baseTX err counter */

/* Window 5  - Command Results and Internal State */
#define EF5_TXSTART	0x0		/* TX Start threshold + 4 (R) */
#define EF5_TXAVAIL	0x2		/* TX Available threshold (R) */
#define EF5_RXEARLY	0x6		/* RX Early threshold (R) */
#define EF5_RXFILTER	0x8		/* RX Filter (R) */
#define EF5_IMASK	0xa		/* Interrupt Mask (R) */
#define EF5_RZMASK	0xc		/* Read Zero Mask (R) */

/* Window 6 - Statistics */
#define EF6_CSL		0x0		/* Carrier Sense Lost during transmission */
#define EF6_NOCD	0x1		/* Frames transmitted with no CD Heartbeat */
#define EF6_MCOL	0x2		/* Frames transmitted after Multiple Collisions */
#define EF6_OCOL	0x3		/* Frames transmitted after One Collision */
#define EF6_LCOL	0x4		/* Late Collisions on transmit */
#define EF6_OVR		0x5		/* Receive Overruns */
#define EF6_TXOK	0x6		/* Frames Transmitted OK */
#define EF6_RXOK	0x7		/* Frames Received OK */
#define EF6_DEF		0x8		/* Transmit Deferrals */
#define EF6_UPPEROK	0x9		/* Upper bits RXOK, TXOK */
#define EF6_RXTOTAL	0xa		/* Total Bytes Received OK */
#define EF6_TXTOTAL	0xc		/* Total Bytes Transmitted OK */

/* Window 7 - BusMaster */
#define EF7_MADDR	0x0		/* MasterAddress */
#define EF7_MLEN	0x6		/* MasterLen */
#define EF7_MSTAT	0xc		/* MasterStatus */

/*
 * Commands to write to EF_CMD
 * The argument should be OR-ed with the command word
 */
#define EFC_RESET	0x0000		/* Global Reset */
# define EFC_RES_TPAUI	 0x0001		 /* mask 10-baseT and AUI TX logic */
# define EFC_RES_ENDEC	 0x0002		 /* mask Ethernet enc/dec TX logic */
# define EFC_RES_NETTX	 0x0004		 /* mask network TX logic */
# define EFC_RES_FIFO	 0x0008		 /* mask TX FIFO logic */
# define EFC_RES_AISM    0x0010		 /* mask auto init state machine */
# define EFC_RES_HOST    0x0020		 /* mask bus interface logic */
# define EFC_RES_DMA	 0x0040		 /* mask TX DMA logic */
# define EFC_RES_VCO	 0x0080          /* mask VCO logic */
# define EFC_RES_MASK	 0x00ff		 /* global reset mask */
#define EFC_WINDOW	0x0800		/* Select Window N */
#define EFC_COAXSTA	0x1000		/* Start Coaxial Transceiver */
#define EFC_RXDIS	0x1800		/* Disable Receiver */
#define EFC_RXENB	0x2000		/* Enable Receiver */
#define EFC_RXRST	0x2800		/* Reset Receiver */
#define EFC_TXDONE	0x3800		/* Tx upload done (3c59x) */
#define EFC_RXDTP	0x4000		/* Discard Top Received Packet */
#define EFC_TXENB	0x4800		/* Enable Transmitter */
#define EFC_TXDIS	0x5000		/* Disable Transmitter */
#define EFC_TXRST	0x5800		/* Reset Transmitter */
#define EFC_IREQ	0x6000		/* Request Interrupt */
#define EFC_ACK		0x6800		/* Acknowledge Interrupt (arg bits as in EF_STAT) */
#define EFC_SIM		0x7000		/* Set Interrupt Mask (arg bits as in EF_STAT) */
#define EFC_SZM		0x7800		/* Set Zero Mask (arg bits as in EF_STAT) */
#define EFC_SRXF	0x8000		/* Set RX Filter */
# define EFRXF_ADDR	 0x1		 /* Accept Individual Address */
# define EFRXF_AM	 0x2		 /* Accept Multicast */ 
# define EFRXF_AB	 0x4		 /* Accept Broadcast */
# define EFRXF_PROM	 0x8		 /* Promiscuous Mode (accept everything) */
#define EFC_RXEARLY	0x8800		/* Set RX Early Threshold */
#define EFC_TXAVAIL	0x9000		/* Set TX Available Threshold */
#define EFC_TXSTART	0x9800		/* Set TX Start Threshold */
#define EFC_DMASTRT	0xa000		/* Start Bus Master */
# define EFC_DMA_UP	 0x0000		 /* Bus Master upload (to CPU)*/
# define EFC_DMA_DWN	 0x0001		 /* Bus Master download (from CPU) */
#define EFC_STATENB	0xa800		/* Statistics Enable */
#define EFC_STATDIS	0xb000		/* Statistics Disable */
#define EFC_COAXSTP	0xb800		/* Stop Coaxial Transceiver */

/*
 * Status bits (read from EF_STAT)
 */
#define EFS_IL		0x0001		/* Interrupt Latch */
#define EFS_AF		0x0002		/* Adapter Failure */
#define EFS_TXC		0x0004		/* TX Complete */
#define EFS_TXA		0x0008		/* TX Available */
#define EFS_RXC		0x0010		/* RX Complete */
#define EFS_RXE		0x0020		/* RX Early */
#define EFS_IREQ	0x0040		/* Interrupt Requested */
#define EFS_UPDS	0x0080		/* Update Statistics */
#define EFS_XFI		0x0100		/* TransferInt */
#define EFS_CIP		0x1000		/* Command-In-Progress */
#define EFS_MIP		0x0800		/* Master-In-Progress */
#define EFS_WINDOW	0xe000		/* Window number */

/*
 * Receive Status (read from EF1_RXSTAT; errors in PIO models only)
 */
#define EFRS_BYTES	0x07ff		/* Bytes left in FIFO (PIO) */
#define EFRS_NBYTES	0x1fff		/* Bytes left in FIFO (Bus master) */
#define EFRS_ETYPE	0x7800		/* Error Type, including EFRS_ERR */
# define EFET_DRIB	  0x1000	  /* Dribble Bit(s) */
# define EFET_OVERRUN	  0x4000	  /* Overrun */
# define EFET_OVRSIZ	  0x4800	  /* Oversize Packet */
# define EFET_RUNT	  0x5800	  /* Runt Packet */
# define EFET_ALIGN	  0x6000	  /* Alignment (Framing) Error */
# define EFET_CRC	  0x6800	  /* CRC Error */
#define EFRS_ERR	0x4000		/* Error */
#define EFRS_INCOMPL	0x8000		/* Incomplete */

/*
 * Receive Error (read from EF1_RXERR; 3C59X Bus master models only)
 */
#define EFRE_OVERRUN	  0x01	  	/* Overrun */
#define EFRE_RUNT	  0x02	  	/* Runt Packet */
#define EFRE_ALIGN	  0x04	 	/* Alignment (Framing) Error */
#define EFRE_CRC	  0x08	  	/* CRC Error */
#define EFRE_OVRSIZ	  0x10	  	/* Oversize Packet */
#define EFRE_DRIB	  0x80		/* Dribble Bit(s) */

/*
 * Transmit Status (read from EF1_TXSTAT)
 */
#define EFTS_SOVFL	0x04		/* TX Status Overflow */
#define EFTS_MAXCOL	0x08		/* Maximum Collisions */
#define EFTS_UNDR	0x10		/* Underrun (TX Reset required) */
#define EFTS_JAB	0x20		/* Jabber Error */
#define EFTS_INT	0x40		/* Interrupt on successful transmission */
#define EFTS_COMPL	0x80		/* TX is complete */

/*
 * Configuration Control Register (EF0_CC)
 */
#define EFCC_ENA	0x0001		/* Enable adapter */
#define EFCC_RST	0x0002		/* Reset adapter to POR */
#define EFCC_ICODEC	0x0100		/* Use internal encoder/decoder (R) */
#define EFCC_TP		0x0200		/* On-board 10BASE-T (TP) is available (R) */
#define EFCC_RXTM	0x0400		/* Receive test mode (R) */
#define EFCC_TXTM	0x0800		/* Transmit test mode (R) */
#define EFCC_NORM	0x0c00		/* Normal mode (R) */
#define EFCC_BNC	0x1000		/* On-board 10BASE2 (BNC) is available (R) */
#define EFCC_AUI	0x2000		/* AUI connector is available (R) */

/*
 * Address Configuration Register (EF0_ACNF)
 */
#define EFAC_BASE(a)	(((a)>>4) & 0x1f) /* ISA base address */
#define EFAC_EISASLOT	0x001f		/* EISA slot-specific i/o address */

#define EFAC_NOROM	0x0000		/* Boot ROM disabled */
#define EFAC_ROMBASE	0x0f00		/* Boot ROM base bits */
#define EFAC_ROMSIZE	0x3000		/* Boot ROM size bits */

#define EFAC_TP		0x0000		/* Select 10BASE-T (TP) transceiver */
#define EFAC_AUI	0x4000		/* Select AUI connector */
#define EFAC_BNC	0xc000		/* Select 10BASE2 (BNC) transceiver */

/*
 * Internal Config Register (EF3_ICONFG)
 */
#define	EFIC_RAMSIZE	0
#define	EFIC_RAMWIDTH	3
#define	EFIC_RAMSPEED	4
#define	EFIC_ROMSIZE	6
#define	EFIC_BADSSD	8
#define	EFIC_RAMPART	16
#define	EFIC_MSEL	20
#define	EFIC_AUTOSEL	24

/* Ram Size */
#define	EFIC_8K		0
#define	EFIC_32K	2
#define	EFIC_64K	3
#define	EFIC_128K	4

/* Ram Width */
#define	EFIC_BYTE	0
#define	EFIC_WORD	1

/* Parition */
#define EFIC_53		0
#define EFIC_31		1
#define EFIC_11		2

/* Media */
#define	EFIC_TP		0		/* Select 10base-T */
#define	EFIC_AUI	1		/* AUI available */
#define	EFIC_BNC	3		/* 10base-2 available */
#define	EFIC_TX		4		/* 100base-TX available */
#define	EFIC_FX		5		/* 100base-FX available */
#define	EFIC_MII	6		/* MII available */

/*
 * Mac control (EF3_MCTL) (59x)
 */
#define	EFMCTL_DEFER	0x01		/* special deference mode */
#define	EFMCTL_DEFTIMER	0x1e		/* defer timer mask */
#define	EFMCTL_FDX	0x20		/* Full duplex enable */
#define	EFMCTL_LARGE	0x40		/* Allow 4491 byte packets */

/*
 * Reset Options Register (EF3_RESOPT)
 */
#define EFRO_T4		0x0001		/* 100base-T4 available */
#define EFRO_TX		0x0002		/* 100base-TX available */
#define EFRO_FX		0x0004		/* 100base-FX available */
#define EFRO_TP		0x0008		/* 10base-T available */
#define EFRO_BNC	0x0010		/* 10base-2 available */
#define EFRO_AUI	0x0020		/* AUI available */
#define EFRO_MII	0x0040		/* MII available */
#define EFRO_PHY_PWRUP	0x8000		/* Power up PHY */
#define EFRO_PHY_RESET	0x4000		/* Power up PHY */

/*
 * Media Type and Status Register (EF4_MTS)
 */
#define EFMTS_SQESE	0x0008		/* TP - SQE Statistics Enable */
#define EFMTS_COLL	0x0010		/* Collision (R) */
#define EFMTS_CRS	0x0020		/* Carrier Sense (R) */
#define EFMTS_JABE	0x0040		/* TP - Jabber Error Enable */
#define EFMTS_LBE	0x0080		/* TP - Link Beat Enable */
#define EFMTS_UNSQ	0x0100		/* TP - Unsquelch (R) */
#define EFMTS_JAB	0x0200		/* TP - Jabber (R) */
#define EFMTS_POLSW	0x0400		/* TP - Polarity Swap (R) */
#define EFMTS_LBC	0x0800		/* TP - Link Beat Correct */
#define EFMTS_SQE	0x1000		/* SQE Present (R) */
#define EFMTS_IED	0x2000		/* Internal Encoder/Decoder (R) */
#define EFMTS_BNC	0x4000		/* BNC transceiver (R) */
#define EFMTS_AUID	0x8000		/* AUI disable (R) */

/*
 * Network diagnostic (EF4_NDIAG)
 */
#define	EFNDIAG_FDXMASK	0x0fff		/* Don't-touch bits */
#define	EFNDIAG_FDX	0x8000		/* FDX enable */
#define	EFNDIAG_RXEN	0x0400		/* Receiver enabled */

/*
 * Resource Configuration Register (EF0_RCNF)
 */
#define EFRC_IRQ(i)	(((i)<<12) | 0xf00) /* Set IRQ i */

/*
 * EEPROM Command Register (EF0_PROMCMD)
 */
#define EFPC_WDIS	0x00		/* Write/Erase Disable */
#define EFPC_WALL	0x10		/* Write All Registers */
#define EFPC_EALL	0x20		/* Erase All Registers */
#define EFPC_WENB	0x30		/* Write/Erase Enable */
#define EFPCC_WREG	0x01		/* Write EEPROM command */
#define EFPCC_RREG	0x02		/* Read EEPROM command */
#define EFPCC_EREG	0x03		/* Erase EEPROM command */

#define EFPC_TAG	0x0700		/* Tag register (R) */
#define EFPC_TST	0x4000		/* Test mode jumpered (R) */
#define EFPC_EBY	0x8000		/* EEPROM is busy (R) */

/*
 * EEPROM Data Structure
 */
#define EFROM_ADDR(i)	(0x0 + (i))	/* 3Com station address (word i) */
#define EFROM_PID	0x3		/* 3C509 Product ID (0x9?50) */
#define EFROM_MFG(i)	(0x4 + (i))	/* Manufacturing Data */
#define EFROM_MFC	0x7		/* Manufacturer Code (0x6d50) */
#define EFROM_ACNF	0x8		/* Address Configuration */
#define EFROM_RCNF	0x9		/* Resource Configuration */
#define EFROM_OEMA(i)	(0xa + (i))	/* OEM station address (word i) */
#define EFROM_SI	0xd		/* Software Information */
#define EFROM_SI2	0xf		/* Software Inf 2 (for 3C59x) */
#define EFROM_NMD(i)	(0x10 + (i))	/* Network Management Data (48 words) */
#define EFROM_CSUM	0x17		/* Checksum (for 3C5x9) */

#define EFROM_ICL	0x12		/* Internal config Lo - 59x */
#define EFROM_ICH	0x13		/* Internal config Hi - 59x */

/*
 * Bits from EFROM_SI2
 */
#define EFSI2_NOROA	0x0020		/* Most be 1 for PCI 3C59x *

/*
 * Frame start header
 */
#define	EFPRE_TXIND	0x8000		/* Interrupt on TX complete */
#define	EFPRE_NOCRC	0x2000		/* Host must append CRC */
#define	EFPRE_TXLEN	0x0fff		/* Mast for packet length */

/*
 * Master Status (EF7_MSTAT)
 */
#define EFM_MIP		0x8000		/* Master in progress */
#define EFM_UD		0x4000		/* Master upload done */
#define EFM_DD		0x1000		/* Master download done */
#define EFM_TDISC	0x0008		/* Target disconnect */
#define EFM_TRETRY	0x0004		/* Target retry */
#define EFM_TABORT	0x0002		/* Target abort */
#define EFM_MABORT	0x0001		/* Master abort */

/*
 * Config data for various cards, included here because it is used
 * from efsetup as well as the driver.
 */

/* some ef_flags from the driver */
#define EF_EISA		0x01		/* On EISA */
#define EF_PCI		0x02		/* On PCI */
#define EF_BMASTER	0x04		/* Can be busmaster */
#define EF_NWEINT	0x08		/* 3C59X and beyond net i/f */

#ifdef EF_TYPE_ARRAY
struct eftype {
	u_short	ef_deviceid;		/* 5950 */
	u_short	ef_devmask;		/* Device 'mask' */
	char	*ef_name;		/* 3C595-TX */
	u_long	ef_flags;		/* EF_PCI | EF_BMASTER */
} ef_types[] = {
	0x9050,	0xffff, "3C509-TP",	0,
	0x9150,	0xffff, "3C509",	0,
	0x9450,	0xffff, "3C509-COMBO",	0,
	0x9550,	0xffff, "3C509-TPO",	0,
	0x9850,	0xffff, "3C509-TPC",	0,
	0x9250,	0xffff, "3C579-TP",	EF_EISA,
	0x9350,	0xffff, "3C579",	EF_EISA,
	0x9650,	0xffff, "3C579-COMBO",	EF_EISA,
	0x9750,	0xffff, "3C579-TPO",	EF_EISA,
	0x9050, 0xf0ff, "UNKNOWN-3C5x9", 0,		/* best guess */
#define EF_509_PID	0x9050
	0x9058, 0xffff, "3C589",	0,

	0x5900, 0xffff, "3C590",	EF_PCI  | EF_BMASTER | EF_NWEINT,
	0x2059, 0xffff, "3C592",	EF_EISA | EF_BMASTER | EF_NWEINT,
	0x5920, 0xffff, "3C592",	EF_EISA | EF_BMASTER | EF_NWEINT,/*XXX*/
	0x5950, 0xffff, "3C595-TX",	EF_PCI  | EF_BMASTER | EF_NWEINT,
	0x5951, 0xffff, "3C595-T4",	EF_PCI  | EF_BMASTER | EF_NWEINT,
	0x5952, 0xffff, "3C595-MII",	EF_PCI  | EF_BMASTER | EF_NWEINT,
	0x7059, 0xffff, "3C597-TX",	EF_EISA | EF_BMASTER | EF_NWEINT,
	0x7159, 0xffff, "3C597-T4",	EF_EISA | EF_BMASTER | EF_NWEINT,
	0x7259, 0xffff, "3C597-MII",	EF_EISA | EF_BMASTER | EF_NWEINT,
	/* next two are "best guess" wildcards */
	0x0059, 0x00ff, "3C597-UNK",	EF_EISA | EF_BMASTER | EF_NWEINT,
	0x5900, 0xff00, "UNKNOWN-3C59x", EF_PCI | EF_BMASTER | EF_NWEINT,
	0,	0xffff, "UNKNOWN",	0,
};
#endif
