/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_n2ioctl.h,v 2.2 1996/07/01 21:14:00 pjd Exp
 */


#ifndef _I386_ISA_N2IOCTL_H
#define _I386_ISA_N2IOCTL_H

#include <sys/ioccom.h>

typedef enum {N2, N2CSU, N2DDS, N2V35, N2test, N2RS232, N2HSSI, N2RS422, 
N2NONE } n2_type_t;


typedef struct n2ioc_gtype {
	char		gt_name[IFNAMSIZ];
	n2_type_t	gt_type;
} n2ioc_gtype_t;

typedef struct n2ioc_io {
	char		io_name[IFNAMSIZ];
	u_int		io_offset;
	u_char		io_data;
} n2ioc_io_t;

typedef struct n2ioc_int {
	char		i_name[IFNAMSIZ];
	u_int		i_int;
} n2ioc_int_t;


#define N2IOCGTYPE	_IOWR('i', 196, struct n2ioc_gtype)
#define N2IOCSBYTE	_IOW('i', 197, struct n2ioc_io)
#define N2IOCGBYTE	_IOWR('i', 198, struct n2ioc_io)
#define N2IOCSPOLARITY	_IOW('i', 199, struct n2ioc_int)
#define N2IOCSFLAGS	_IOW('i', 200, struct n2ioc_int)

#define N2RATE_S	12
#define N2RATE_M	0x7
#define N2RATE(x)	(((x) >> N2RATE_S) & N2RATE_M)

#define N2SRCCLK_S	15
#define N2SRCCLK_M	0x1
#define N2SRCCLK(x)	(((x) >> N2SRCCLK_S) & N2SRCCLK_M)

#define N2NODCD_S	0
#define N2NODCD_M	0x1
#define N2NODCD(x)	(((x) >> N2NODCD_S) & N2NODCD_M)

#define N2QUIET_S	1
#define N2QUIET_M	0x1
#define N2QUIET(x)	(((x) >> N2QUIET_S) & N2QUIET_M)

#define N2RX2TX_S	2
#define N2RX2TX_M	0x1
#define N2RX2TX(x)	(((x) >> N2RX2TX_S) & N2RX2TX_M)

#endif
